/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public abstract class StringOperationEval
implements OperationEval {
    protected ValueEval singleOperandEvaluate(Eval eval, int srcRow, short srcCol) {
        ValueEval retval;
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (ae.contains(srcRow, srcCol)) {
                retval = ErrorEval.CIRCULAR_REF_ERROR;
            } else if (ae.isRow()) {
                if (ae.containsColumn(srcCol)) {
                    ae.getValueAt(ae.getFirstRow(), srcCol);
                    retval = this.internalResolveEval(eval);
                } else {
                    retval = ErrorEval.NAME_INVALID;
                }
            } else if (ae.isColumn()) {
                if (ae.containsRow(srcRow)) {
                    ae.getValueAt(srcRow, ae.getFirstColumn());
                    retval = this.internalResolveEval(eval);
                } else {
                    retval = ErrorEval.NAME_INVALID;
                }
            } else {
                retval = ErrorEval.NAME_INVALID;
            }
        } else {
            retval = this.internalResolveEval(eval);
        }
        return retval;
    }

    private ValueEval internalResolveEval(Eval eval) {
        RefEval re;
        ValueEval tve;
        ValueEval retval = eval instanceof StringValueEval ? (StringValueEval)eval : (eval instanceof RefEval ? ((tve = (re = (RefEval)eval).getInnerValueEval()) instanceof StringValueEval || tve instanceof BlankEval ? tve : ErrorEval.NAME_INVALID) : (eval instanceof BlankEval ? (BlankEval)eval : ErrorEval.NAME_INVALID));
        return retval;
    }
}

