/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public abstract class BooleanFunction
implements Function {
    public final Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        boolean boolResult;
        if (args.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            boolResult = this.calculate(args);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return BoolEval.valueOf(boolResult);
    }

    private boolean calculate(Eval[] args) throws EvaluationException {
        boolean result = this.getInitialResultValue();
        boolean atleastOneNonBlank = false;
        int i = 0;
        int iSize = args.length;
        while (i < iSize) {
            Eval arg = args[i];
            if (arg instanceof AreaEval) {
                AreaEval ae = (AreaEval)arg;
                int height = ae.getHeight();
                int width = ae.getWidth();
                int rrIx = 0;
                while (rrIx < height) {
                    int rcIx = 0;
                    while (rcIx < width) {
                        ValueEval ve = ae.getRelativeValue(rrIx, rcIx);
                        Boolean tempVe = OperandResolver.coerceValueToBoolean(ve, true);
                        if (tempVe != null) {
                            result = this.partialEvaluate(result, tempVe);
                            atleastOneNonBlank = true;
                        }
                        ++rcIx;
                    }
                    ++rrIx;
                }
            } else {
                Boolean tempVe;
                ValueEval ve;
                if (arg instanceof RefEval) {
                    ve = ((RefEval)arg).getInnerValueEval();
                    tempVe = OperandResolver.coerceValueToBoolean(ve, true);
                } else if (arg instanceof ValueEval) {
                    ve = (ValueEval)arg;
                    tempVe = OperandResolver.coerceValueToBoolean(ve, false);
                } else {
                    throw new RuntimeException("Unexpected eval (" + arg.getClass().getName() + ")");
                }
                if (tempVe != null) {
                    result = this.partialEvaluate(result, tempVe);
                    atleastOneNonBlank = true;
                }
            }
            ++i;
        }
        if (!atleastOneNonBlank) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return result;
    }

    protected abstract boolean getInitialResultValue();

    protected abstract boolean partialEvaluate(boolean var1, boolean var2);
}

