/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

public final class MathX {
    private MathX() {
    }

    public static double round(double n, int p) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p != 0) {
            double temp = Math.pow(10.0, p);
            retval = (double)Math.round(n * temp) / temp;
        } else {
            retval = Math.round(n);
        }
        return retval;
    }

    public static double roundUp(double n, int p) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p != 0) {
            double temp = Math.pow(10.0, p);
            double nat = Math.abs(n * temp);
            retval = (double)MathX.sign(n) * (nat == (double)((long)nat) ? nat / temp : (double)Math.round(nat + 0.5) / temp);
        } else {
            double na = Math.abs(n);
            retval = (double)MathX.sign(n) * (na == (double)((long)na) ? na : (double)((long)na + 1L));
        }
        return retval;
    }

    public static double roundDown(double n, int p) {
        double retval;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            retval = Double.NaN;
        } else if (p != 0) {
            double temp = Math.pow(10.0, p);
            retval = (double)((long)MathX.sign(n) * Math.round(Math.abs(n) * temp - 0.5)) / temp;
        } else {
            retval = (long)n;
        }
        return retval;
    }

    public static short sign(double d) {
        return (short)(d == 0.0 ? 0 : (d < 0.0 ? -1 : 1));
    }

    public static double average(double[] values) {
        double ave = 0.0;
        double sum = 0.0;
        int i = 0;
        int iSize = values.length;
        while (i < iSize) {
            sum += values[i];
            ++i;
        }
        ave = sum / (double)values.length;
        return ave;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        int i = 0;
        int iSize = values.length;
        while (i < iSize) {
            sum += values[i];
            ++i;
        }
        return sum;
    }

    public static double sumsq(double[] values) {
        double sumsq = 0.0;
        int i = 0;
        int iSize = values.length;
        while (i < iSize) {
            sumsq += values[i] * values[i];
            ++i;
        }
        return sumsq;
    }

    public static double product(double[] values) {
        double product = 0.0;
        if (values != null && values.length > 0) {
            product = 1.0;
            int i = 0;
            int iSize = values.length;
            while (i < iSize) {
                product *= values[i];
                ++i;
            }
        }
        return product;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        int iSize = values.length;
        while (i < iSize) {
            min = Math.min(min, values[i]);
            ++i;
        }
        return min;
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        int iSize = values.length;
        while (i < iSize) {
            max = Math.max(max, values[i]);
            ++i;
        }
        return max;
    }

    public static double floor(double n, double s) {
        double f = n < 0.0 && s > 0.0 || n > 0.0 && s < 0.0 || s == 0.0 && n != 0.0 ? Double.NaN : (n == 0.0 || s == 0.0 ? 0.0 : Math.floor(n / s) * s);
        return f;
    }

    public static double ceiling(double n, double s) {
        double c = n < 0.0 && s > 0.0 || n > 0.0 && s < 0.0 ? Double.NaN : (n == 0.0 || s == 0.0 ? 0.0 : Math.ceil(n / s) * s);
        return c;
    }

    public static double factorial(int n) {
        double d = 1.0;
        if (n >= 0) {
            if (n <= 170) {
                int i = 1;
                while (i <= n) {
                    d *= (double)i;
                    ++i;
                }
            } else {
                d = Double.POSITIVE_INFINITY;
            }
        } else {
            d = Double.NaN;
        }
        return d;
    }

    public static double mod(double n, double d) {
        double result = 0.0;
        if (d == 0.0) {
            result = Double.NaN;
        } else if (MathX.sign(n) == MathX.sign(d)) {
            double t = Math.abs(n / d);
            t -= (double)((long)t);
            result = (double)MathX.sign(d) * Math.abs(t * d);
        } else {
            double t = Math.abs(n / d);
            t -= (double)((long)t);
            t = Math.ceil(t) - t;
            result = (double)MathX.sign(d) * Math.abs(t * d);
        }
        return result;
    }

    public static double acosh(double d) {
        return Math.log(Math.sqrt(Math.pow(d, 2.0) - 1.0) + d);
    }

    public static double asinh(double d) {
        return Math.log(Math.sqrt(d * d + 1.0) + d);
    }

    public static double atanh(double d) {
        return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
    }

    public static double cosh(double d) {
        double ePowX = Math.pow(Math.E, d);
        double ePowNegX = Math.pow(Math.E, -d);
        d = (ePowX + ePowNegX) / 2.0;
        return d;
    }

    public static double sinh(double d) {
        double ePowX = Math.pow(Math.E, d);
        double ePowNegX = Math.pow(Math.E, -d);
        d = (ePowX - ePowNegX) / 2.0;
        return d;
    }

    public static double tanh(double d) {
        double ePowX = Math.pow(Math.E, d);
        double ePowNegX = Math.pow(Math.E, -d);
        d = (ePowX - ePowNegX) / (ePowX + ePowNegX);
        return d;
    }

    public static double sumproduct(double[][] arrays) {
        double d = 0.0;
        try {
            int narr = arrays.length;
            int arrlen = arrays[0].length;
            int j = 0;
            while (j < arrlen) {
                double t = 1.0;
                int i = 0;
                while (i < narr) {
                    t *= arrays[i][j];
                    ++i;
                }
                d += t;
                ++j;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            d = Double.NaN;
        }
        return d;
    }

    public static double nChooseK(int n, int k) {
        double d = 1.0;
        if (n < 0 || k < 0 || n < k) {
            d = Double.NaN;
        } else {
            int maxnk;
            int minnk = Math.min(n - k, k);
            int i = maxnk = Math.max(n - k, k);
            while (i < n) {
                d *= (double)(i + 1);
                ++i;
            }
            d /= MathX.factorial(minnk);
        }
        return d;
    }
}

