/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public class Mode
implements Function {
    public static double evaluate(double[] v) throws EvaluationException {
        if (v.length < 2) {
            throw new EvaluationException(ErrorEval.NA);
        }
        int[] counts = new int[v.length];
        Arrays.fill(counts, 1);
        int i = 0;
        int iSize = v.length;
        while (i < iSize) {
            int j = i + 1;
            int jSize = v.length;
            while (j < jSize) {
                if (v[i] == v[j]) {
                    int n = i;
                    counts[n] = counts[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        double maxv = 0.0;
        int maxc = 0;
        int i2 = 0;
        int iSize2 = counts.length;
        while (i2 < iSize2) {
            if (counts[i2] > maxc) {
                maxv = v[i2];
                maxc = counts[i2];
            }
            ++i2;
        }
        if (maxc > 1) {
            return maxv;
        }
        throw new EvaluationException(ErrorEval.NA);
    }

    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        double result;
        try {
            ArrayList temp = new ArrayList();
            int i = 0;
            while (i < args.length) {
                Mode.collectValues(args[i], temp);
                ++i;
            }
            double[] values = new double[temp.size()];
            int i2 = 0;
            while (i2 < values.length) {
                values[i2] = (Double)temp.get(i2);
                ++i2;
            }
            result = Mode.evaluate(values);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    private static void collectValues(Eval arg, List temp) throws EvaluationException {
        if (arg instanceof AreaEval) {
            AreaEval ae = (AreaEval)arg;
            int width = ae.getWidth();
            int height = ae.getHeight();
            int rrIx = 0;
            while (rrIx < height) {
                int rcIx = 0;
                while (rcIx < width) {
                    ValueEval ve1 = ae.getRelativeValue(rrIx, rcIx);
                    Mode.collectValue(ve1, temp, false);
                    ++rcIx;
                }
                ++rrIx;
            }
            return;
        }
        if (arg instanceof RefEval) {
            RefEval re = (RefEval)arg;
            Mode.collectValue(re.getInnerValueEval(), temp, true);
            return;
        }
        Mode.collectValue(arg, temp, true);
    }

    private static void collectValue(Eval arg, List temp, boolean mustBeNumber) throws EvaluationException {
        if (arg instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)arg);
        }
        if (arg == BlankEval.INSTANCE || arg instanceof BoolEval || arg instanceof StringEval) {
            if (mustBeNumber) {
                throw EvaluationException.invalidValue();
            }
            return;
        }
        if (arg instanceof NumberEval) {
            temp.add(new Double(((NumberEval)arg).getNumberValue()));
            return;
        }
        throw new RuntimeException("Unexpected value type (" + arg.getClass().getName() + ")");
    }
}

