/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;

public final class HSSFDataFormatter {
    private static final Pattern numPattern = Pattern.compile("[0#]+");
    private static final Pattern daysAsText = Pattern.compile("([d]{3,})", 2);
    private static final Pattern amPmPattern = Pattern.compile("((A|P)[M/P]*)", 2);
    private static final Pattern specialPatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+\\])");
    private static final Format generalWholeNumFormat = new DecimalFormat("#");
    private static final Format generalDecimalNumFormat = new DecimalFormat("#.##########");
    private Format defaultNumFormat;
    private final Map formats = new HashMap();

    public HSSFDataFormatter() {
        Format zipFormat = ZipPlusFourFormat.instance;
        this.addFormat("00000\\-0000", zipFormat);
        this.addFormat("00000-0000", zipFormat);
        Format phoneFormat = PhoneFormat.instance;
        this.addFormat("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("[<=9999999]###-####;(###) ###-####", phoneFormat);
        this.addFormat("###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("###-####;(###) ###-####", phoneFormat);
        Format ssnFormat = SSNFormat.instance;
        this.addFormat("000\\-00\\-0000", ssnFormat);
        this.addFormat("000-00-0000", ssnFormat);
    }

    private Format getFormat(HSSFCell cell) {
        if (cell.getCellStyle() == null) {
            return null;
        }
        short formatIndex = cell.getCellStyle().getDataFormat();
        String formatStr = cell.getCellStyle().getDataFormatString();
        if (formatStr == null || formatStr.trim().length() == 0) {
            return null;
        }
        return this.getFormat(cell.getNumericCellValue(), formatIndex, formatStr);
    }

    private Format getFormat(double cellValue, int formatIndex, String formatStr) {
        Format format = (Format)this.formats.get(formatStr);
        if (format != null) {
            return format;
        }
        if (formatStr.equals("General")) {
            if (HSSFDataFormatter.isWholeNumber(cellValue)) {
                return generalWholeNumFormat;
            }
            return generalDecimalNumFormat;
        }
        format = this.createFormat(cellValue, formatIndex, formatStr);
        this.formats.put(formatStr, format);
        return format;
    }

    public Format createFormat(HSSFCell cell) {
        short formatIndex = cell.getCellStyle().getDataFormat();
        String formatStr = cell.getCellStyle().getDataFormatString();
        return this.createFormat(cell.getNumericCellValue(), formatIndex, formatStr);
    }

    private Format createFormat(double cellValue, int formatIndex, String sFormat) {
        String formatStr = sFormat.replaceAll("\\[[a-zA-Z]*\\]", "");
        Matcher m = specialPatternGroup.matcher(formatStr);
        while (m.find()) {
            String match = m.group();
            String symbol = match.substring(match.indexOf(36) + 1, match.indexOf(45));
            if (symbol.indexOf(36) > -1) {
                StringBuffer sb = new StringBuffer();
                sb.append(symbol.substring(0, symbol.indexOf(36)));
                sb.append('\\');
                sb.append(symbol.substring(symbol.indexOf(36), symbol.length()));
                symbol = sb.toString();
            }
            formatStr = m.replaceAll(symbol);
            m = specialPatternGroup.matcher(formatStr);
        }
        if (formatStr == null || formatStr.trim().length() == 0) {
            return this.getDefaultFormat(cellValue);
        }
        if (HSSFDateUtil.isADateFormat(formatIndex, formatStr) && HSSFDateUtil.isValidExcelDate(cellValue)) {
            return this.createDateFormat(formatStr, cellValue);
        }
        if (numPattern.matcher(formatStr).find()) {
            return this.createNumberFormat(formatStr, cellValue);
        }
        return null;
    }

    private Format createDateFormat(String pFormatStr, double cellValue) {
        String formatStr = pFormatStr;
        formatStr = formatStr.replaceAll("\\\\-", "-");
        formatStr = formatStr.replaceAll("\\\\,", ",");
        formatStr = formatStr.replaceAll("\\\\ ", " ");
        formatStr = formatStr.replaceAll(";@", "");
        boolean hasAmPm = false;
        Matcher amPmMatcher = amPmPattern.matcher(formatStr);
        while (amPmMatcher.find()) {
            formatStr = amPmMatcher.replaceAll("@");
            hasAmPm = true;
            amPmMatcher = amPmPattern.matcher(formatStr);
        }
        Matcher dateMatcher = daysAsText.matcher(formatStr = formatStr.replaceAll("@", "a"));
        if (dateMatcher.find()) {
            String match = dateMatcher.group(0);
            formatStr = dateMatcher.replaceAll(match.toUpperCase().replaceAll("D", "E"));
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = formatStr.toCharArray();
        boolean mIsMonth = true;
        ArrayList<Integer> ms = new ArrayList<Integer>();
        int j = 0;
        while (j < chars.length) {
            char c = chars[j];
            if (c == 'h' || c == 'H') {
                mIsMonth = false;
                if (hasAmPm) {
                    sb.append('h');
                } else {
                    sb.append('H');
                }
            } else if (c == 'm') {
                if (mIsMonth) {
                    sb.append('M');
                    ms.add(new Integer(sb.length() - 1));
                } else {
                    sb.append('m');
                }
            } else if (c == 's' || c == 'S') {
                sb.append('s');
                int i = 0;
                while (i < ms.size()) {
                    int index = (Integer)ms.get(i);
                    if (sb.charAt(index) == 'M') {
                        sb.replace(index, index + 1, "m");
                    }
                    ++i;
                }
                mIsMonth = true;
                ms.clear();
            } else if (Character.isLetter(c)) {
                mIsMonth = true;
                ms.clear();
                if (c == 'y' || c == 'Y') {
                    sb.append('y');
                } else if (c == 'd' || c == 'D') {
                    sb.append('d');
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++j;
        }
        formatStr = sb.toString();
        try {
            return new SimpleDateFormat(formatStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private Format createNumberFormat(String formatStr, double cellValue) {
        StringBuffer sb = new StringBuffer(formatStr);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c == '(') {
                int idx = sb.indexOf(")", i);
                if (idx > -1 && sb.charAt(idx - 1) == '_') {
                    sb.deleteCharAt(idx);
                    sb.deleteCharAt(idx - 1);
                    sb.deleteCharAt(i);
                    --i;
                }
            } else if (c == ')' && i > 0 && sb.charAt(i - 1) == '_') {
                sb.deleteCharAt(i);
                sb.deleteCharAt(i - 1);
                --i;
            } else if (c == '\\' || c == '\"') {
                sb.deleteCharAt(i);
                --i;
            } else if (c == '+' && i > 0 && sb.charAt(i - 1) == 'E') {
                sb.deleteCharAt(i);
                --i;
            }
            ++i;
        }
        try {
            return new DecimalFormat(sb.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private static boolean isWholeNumber(double d) {
        return d == Math.floor(d);
    }

    public Format getDefaultFormat(HSSFCell cell) {
        return this.getDefaultFormat(cell.getNumericCellValue());
    }

    private Format getDefaultFormat(double cellValue) {
        if (this.defaultNumFormat != null) {
            return this.defaultNumFormat;
        }
        if (HSSFDataFormatter.isWholeNumber(cellValue)) {
            return generalWholeNumFormat;
        }
        return generalDecimalNumFormat;
    }

    private String getFormattedDateString(HSSFCell cell) {
        Format dateFormat = this.getFormat(cell);
        Date d = cell.getDateCellValue();
        if (dateFormat != null) {
            return dateFormat.format(d);
        }
        return d.toString();
    }

    private String getFormattedNumberString(HSSFCell cell) {
        Format numberFormat = this.getFormat(cell);
        double d = cell.getNumericCellValue();
        if (numberFormat == null) {
            return String.valueOf(d);
        }
        return numberFormat.format(new Double(d));
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString) {
        if (HSSFDateUtil.isADateFormat(formatIndex, formatString) && HSSFDateUtil.isValidExcelDate(value)) {
            Format dateFormat = this.getFormat(value, formatIndex, formatString);
            Date d = HSSFDateUtil.getJavaDate(value);
            if (dateFormat == null) {
                return d.toString();
            }
            return dateFormat.format(d);
        }
        Format numberFormat = this.getFormat(value, formatIndex, formatString);
        if (numberFormat == null) {
            return String.valueOf(value);
        }
        return numberFormat.format(new Double(value));
    }

    public String formatCellValue(HSSFCell cell) {
        return this.formatCellValue(cell, null);
    }

    public String formatCellValue(HSSFCell cell, HSSFFormulaEvaluator evaluator) throws IllegalArgumentException {
        if (cell == null) {
            return "";
        }
        int cellType = cell.getCellType();
        if (evaluator != null && cellType == 2) {
            try {
                cellType = evaluator.evaluateFormulaCell(cell);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Did you forget to set the current row on the HSSFFormulaEvaluator?", e);
            }
        }
        switch (cellType) {
            case 2: {
                return cell.getCellFormula();
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted(cell)) {
                    return this.getFormattedDateString(cell);
                }
                return this.getFormattedNumberString(cell);
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return "";
            }
        }
        throw new RuntimeException("Unexpected celltype (" + cellType + ")");
    }

    public void setDefaultNumberFormat(Format format) {
        for (Map.Entry entry : this.formats.entrySet()) {
            if (entry.getValue() != generalDecimalNumFormat && entry.getValue() != generalWholeNumFormat) continue;
            entry.setValue(format);
        }
        this.defaultNumFormat = format;
    }

    public void addFormat(String excelFormatStr, Format format) {
        this.formats.put(excelFormatStr, format);
    }

    static DecimalFormat createIntegerOnlyFormat(String fmt) {
        DecimalFormat result = new DecimalFormat(fmt);
        result.setParseIntegerOnly(true);
        return result;
    }

    private static final class PhoneFormat
    extends Format {
        public static final Format instance = new PhoneFormat();
        private static final DecimalFormat df = HSSFDataFormatter.createIntegerOnlyFormat("##########");

        private PhoneFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            int len = result.length();
            if (len <= 4) {
                return result;
            }
            String seg3 = result.substring(len - 4, len);
            String seg2 = result.substring(Math.max(0, len - 7), len - 4);
            String seg1 = result.substring(Math.max(0, len - 10), Math.max(0, len - 7));
            if (seg1 != null && seg1.trim().length() > 0) {
                sb.append('(').append(seg1).append(") ");
            }
            if (seg2 != null && seg2.trim().length() > 0) {
                sb.append(seg2).append('-');
            }
            sb.append(seg3);
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(PhoneFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class SSNFormat
    extends Format {
        public static final Format instance = new SSNFormat();
        private static final DecimalFormat df = HSSFDataFormatter.createIntegerOnlyFormat("000000000");

        private SSNFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 3)).append('-');
            sb.append(result.substring(3, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(SSNFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class ZipPlusFourFormat
    extends Format {
        public static final Format instance = new ZipPlusFourFormat();
        private static final DecimalFormat df = HSSFDataFormatter.createIntegerOnlyFormat("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ZipPlusFourFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }
}

