/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.EnglishPorterFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class EnglishPorterFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    private CharArraySet protectedWords = null;

    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        if (wordFiles != null) {
            try {
                File protectedWordFiles = new File(wordFiles);
                if (protectedWordFiles.exists()) {
                    List wlist = loader.getLines(wordFiles);
                    this.protectedWords = new CharArraySet((Collection)wlist, false);
                } else {
                    List files = StrUtils.splitFileNames((String)wordFiles);
                    for (String file : files) {
                        List wlist = loader.getLines(file.trim());
                        if (this.protectedWords == null) {
                            this.protectedWords = new CharArraySet((Collection)wlist, false);
                            continue;
                        }
                        this.protectedWords.addAll((Collection)wlist);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public EnglishPorterFilter create(TokenStream input) {
        return new EnglishPorterFilter(input, this.protectedWords);
    }
}

