/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;

public class FieldQParserPlugin
extends QParserPlugin {
    public static String NAME = "field";

    public void init(NamedList args) {
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            public Query parse() throws ParseException {
                PhraseQuery q;
                Token t;
                String field = this.localParams.get("f");
                String queryText = this.localParams.get("v");
                FieldType ft = this.req.getSchema().getFieldType(field);
                if (!(ft instanceof TextField)) {
                    String internal = ft.toInternal(queryText);
                    return new TermQuery(new Term(field, internal));
                }
                int phraseSlop = 0;
                Analyzer analyzer = this.req.getSchema().getQueryAnalyzer();
                TokenStream source = null;
                try {
                    source = analyzer.reusableTokenStream(field, (Reader)new StringReader(queryText));
                    source.reset();
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
                ArrayList<Token> lst = new ArrayList<Token>();
                int positionCount = 0;
                boolean severalTokensAtSamePosition = false;
                while (true) {
                    try {
                        t = source.next();
                    }
                    catch (IOException e) {
                        t = null;
                    }
                    if (t == null) break;
                    lst.add(t);
                    if (t.getPositionIncrement() != 0) {
                        positionCount += t.getPositionIncrement();
                        continue;
                    }
                    severalTokensAtSamePosition = true;
                }
                try {
                    source.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (lst.size() == 0) {
                    return null;
                }
                if (lst.size() == 1) {
                    t = (Token)lst.get(0);
                    return new TermQuery(new Term(field, new String(t.termBuffer(), 0, t.termLength())));
                }
                if (severalTokensAtSamePosition) {
                    if (positionCount == 1) {
                        q = new BooleanQuery(true);
                        for (int i = 0; i < lst.size(); ++i) {
                            t = (Token)lst.get(i);
                            TermQuery currentQuery = new TermQuery(new Term(field, new String(t.termBuffer(), 0, t.termLength())));
                            q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
                        }
                        return q;
                    }
                    MultiPhraseQuery mpq = new MultiPhraseQuery();
                    mpq.setSlop(phraseSlop);
                    ArrayList<Term> multiTerms = new ArrayList<Term>();
                    for (int i = 0; i < lst.size(); ++i) {
                        t = (Token)lst.get(i);
                        if (t.getPositionIncrement() == 1 && multiTerms.size() > 0) {
                            mpq.add(multiTerms.toArray(new Term[0]));
                            multiTerms.clear();
                        }
                        multiTerms.add(new Term(field, new String(t.termBuffer(), 0, t.termLength())));
                    }
                    mpq.add(multiTerms.toArray(new Term[0]));
                    return mpq;
                }
                q = new PhraseQuery();
                q.setSlop(phraseSlop);
                for (int i = 0; i < lst.size(); ++i) {
                    Token token = (Token)lst.get(i);
                    q.add(new Term(field, new String(token.termBuffer(), 0, token.termLength())));
                }
                return q;
            }
        };
    }
}

