/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;

class MissingLastOrdComparator
extends FieldComparator {
    private final int[] ords;
    private final String[] values;
    private final int[] readerGen;
    private int currentReaderGen = -1;
    private String[] lookup;
    private int[] order;
    private final String field;
    private int bottomSlot = -1;
    private int bottomOrd;
    private String bottomValue;
    private final boolean reversed;
    private final int sortPos;
    private final int nullCmp;
    private final Comparable nullVal;

    public MissingLastOrdComparator(int numHits, String field, int sortPos, boolean reversed, boolean sortMissingLast, Comparable nullVal) {
        this.ords = new int[numHits];
        this.values = new String[numHits];
        this.readerGen = new int[numHits];
        this.sortPos = sortPos;
        this.reversed = reversed;
        this.field = field;
        this.nullCmp = sortMissingLast ? 1 : -1;
        this.nullVal = nullVal;
    }

    public int compare(int slot1, int slot2) {
        int ord1 = this.ords[slot1];
        int ord2 = this.ords[slot2];
        int cmp = ord1 - ord2;
        if (ord1 == 0 || ord2 == 0) {
            if (cmp == 0) {
                return 0;
            }
            return ord1 == 0 ? this.nullCmp : -this.nullCmp;
        }
        if (this.readerGen[slot1] == this.readerGen[slot2] && cmp != 0) {
            return cmp;
        }
        String val1 = this.values[slot1];
        String val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return this.nullCmp;
        }
        if (val2 == null) {
            return -this.nullCmp;
        }
        return val1.compareTo(val2);
    }

    public int compareBottom(int doc) {
        assert (this.bottomSlot != -1);
        int order = this.order[doc];
        int cmp = this.bottomOrd - order;
        if (this.bottomOrd == 0 || order == 0) {
            if (cmp == 0) {
                return 0;
            }
            return this.bottomOrd == 0 ? this.nullCmp : -this.nullCmp;
        }
        if (cmp != 0) {
            return cmp;
        }
        String val2 = this.lookup[order];
        if (this.bottomValue == null) {
            if (val2 == null) {
                return 0;
            }
            return this.nullCmp;
        }
        if (val2 == null) {
            return -this.nullCmp;
        }
        return this.bottomValue.compareTo(val2);
    }

    private void convert(int slot) {
        this.readerGen[slot] = this.currentReaderGen;
        int index = 0;
        String value = this.values[slot];
        if (value == null) {
            this.ords[slot] = 0;
            return;
        }
        if (this.sortPos == 0 && this.bottomSlot != -1 && this.bottomSlot != slot) {
            assert (this.bottomOrd < this.lookup.length);
            index = this.reversed ? MissingLastOrdComparator.binarySearch((String[])this.lookup, (String)value, (int)this.bottomOrd, (int)(this.lookup.length - 1)) : MissingLastOrdComparator.binarySearch((String[])this.lookup, (String)value, (int)0, (int)this.bottomOrd);
        } else {
            index = MissingLastOrdComparator.binarySearch((String[])this.lookup, (String)value);
        }
        if (index < 0) {
            index = -index - 2;
        }
        this.ords[slot] = index;
    }

    public void copy(int slot, int doc) {
        int ord;
        this.ords[slot] = ord = this.order[doc];
        assert (ord >= 0);
        this.values[slot] = this.lookup[ord];
        this.readerGen[slot] = this.currentReaderGen;
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        FieldCache.StringIndex currentReaderValues = FieldCache.DEFAULT.getStringIndex(reader, this.field);
        ++this.currentReaderGen;
        this.order = currentReaderValues.order;
        this.lookup = currentReaderValues.lookup;
        assert (this.lookup.length > 0);
        if (this.bottomSlot != -1) {
            this.convert(this.bottomSlot);
            this.bottomOrd = this.ords[this.bottomSlot];
        }
    }

    public void setBottom(int bottom) {
        this.bottomSlot = bottom;
        if (this.readerGen[bottom] != this.currentReaderGen) {
            this.convert(this.bottomSlot);
        }
        this.bottomOrd = this.ords[bottom];
        assert (this.bottomOrd >= 0);
        assert (this.bottomOrd < this.lookup.length);
        this.bottomValue = this.values[bottom];
    }

    public int sortType() {
        return 3;
    }

    public Comparable value(int slot) {
        String v = this.values[slot];
        return v == null ? this.nullVal : v;
    }

    public String[] getValues() {
        return this.values;
    }

    public int getBottomSlot() {
        return this.bottomSlot;
    }

    public String getField() {
        return this.field;
    }
}

