/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.engine;

import org.ascape.model.engine.ParallelExecutionStrategy;
import org.ascape.model.engine.StrategyFactory;
import org.ascape.util.ResetableIterator;

public class ParallelManager {
    private StrategyFactory factory;
    private ParallelExecutionStrategy mainStrategy;
    private int activeCount;
    int totalCallCount;
    Barrier executeBarrier = new Barrier();
    private ExecutionThread[] executors = new ExecutionThread[0];
    int i = 0;
    Object post = new Object();

    public ParallelManager(StrategyFactory factory, ParallelExecutionStrategy mainStrategy) {
        this.factory = factory;
        this.mainStrategy = mainStrategy;
    }

    public synchronized void execute() {
        this.createThreads();
        this.assignIterators();
        this.threadStart();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void threadStart() {
        int i = 0;
        while (i < this.executors.length) {
            this.executors[i].start();
            ++i;
        }
    }

    private void assignIterators() {
        ResetableIterator[] iterators = this.mainStrategy.getScape().scapeIterators(this.factory.getThreads());
        int i = 0;
        while (i < this.executors.length) {
            this.executors[i].getStrategy().setAgentIterator(iterators[i]);
            ++i;
        }
    }

    private void createThreads() {
        if (this.factory.getThreads() != this.executors.length) {
            this.executors = new ExecutionThread[this.factory.getThreads()];
            int i = 0;
            while (i < this.executors.length) {
                this.executors[i] = new ExecutionThread(this.mainStrategy + " thread " + i, this.mainStrategy);
                ++i;
            }
        }
    }

    public void setMainStrategy(ParallelExecutionStrategy mainStrategy) {
        this.mainStrategy = mainStrategy;
    }

    public void setFactory(StrategyFactory factory) {
        this.factory = factory;
    }

    class Barrier {
        int threadsFinished;

        Barrier() {
        }

        public synchronized void waitForAll() throws InterruptedException {
            ++this.threadsFinished;
            if (this.threadsFinished == ParallelManager.this.executors.length) {
                this.threadsFinished = 0;
                this.notifyAll();
            } else {
                this.wait();
            }
        }
    }

    class ExecutionThread
    extends Thread {
        ParallelExecutionStrategy strategy;
        boolean prime;

        public ExecutionThread(String name, ParallelExecutionStrategy strategy) {
            super(name);
            this.strategy = (ParallelExecutionStrategy)strategy.clone();
        }

        @Override
        public void start() {
            super.start();
            ParallelManager parallelManager = ParallelManager.this;
            parallelManager.activeCount = parallelManager.activeCount + 1;
            this.setName(String.valueOf(ParallelManager.this.activeCount) + " Execution Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            this.strategy.reset();
            while (this.strategy.hasNext()) {
                this.strategy.executeParallel();
                if (this.strategy.hasNext()) {
                    this.strategy.nextParallelSequence();
                }
                try {
                    ParallelManager.this.executeBarrier.waitForAll();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ParallelManager parallelManager = ParallelManager.this;
            synchronized (parallelManager) {
                ParallelManager.this.notify();
            }
        }

        public ParallelExecutionStrategy getStrategy() {
            return this.strategy;
        }

        public void next() {
            this.strategy.nextParallelSequence();
        }
    }
}

