/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColorManager;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public class AcceleoUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.ide.ui";
    private static AcceleoUIActivator plugin;
    private Map<String, Image> imageMap = new HashMap<String, Image>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        this.imageMap.clear();
        AcceleoColorManager.dispose();
        super.stop(context);
    }

    public static AcceleoUIActivator getDefault() {
        return plugin;
    }

    public static String getPreferenceValue(String key) {
        IEclipsePreferences defaultScope = new DefaultScope().getNode(PLUGIN_ID);
        IEclipsePreferences instanceScope = new InstanceScope().getNode(PLUGIN_ID);
        IEclipsePreferences[] lookupOrder = new IEclipsePreferences[]{instanceScope, defaultScope};
        return AcceleoUIActivator.getPreferenceValue(key, lookupOrder);
    }

    public static String getPreferenceValue(String key, IEclipsePreferences[] lookupOrder) {
        String preferenceValue = lookupOrder != null && lookupOrder.length > 0 ? Platform.getPreferencesService().get(key, null, (Preferences[])lookupOrder) : AcceleoUIActivator.getPreferenceValue(key);
        return preferenceValue;
    }

    public Image getImage(String path) {
        ImageDescriptor descriptor;
        Image result = this.imageMap.get(path);
        if (result == null && (descriptor = AcceleoUIActivator.getImageDescriptor(path)) != null) {
            result = descriptor.createImage();
            this.imageMap.put(path, result);
        }
        return result;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AcceleoUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        ILog log = AcceleoUIActivator.getDefault().getLog();
        log.log((IStatus)new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }

    public static void log(IStatus status) {
        if (status == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString((String)"AcceleoUIActivator.LogNullStatus"));
        }
        if (AcceleoUIActivator.getDefault() != null) {
            AcceleoUIActivator.getDefault().getLog().log(status);
        } else {
            System.err.println(status.getMessage());
            status.getException().printStackTrace();
        }
    }

    public static void log(String message, boolean blocker) {
        if (AcceleoUIActivator.getDefault() == null) {
            System.err.println(message);
        } else {
            String errorMessage;
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            if ((errorMessage = message) == null || "".equals(errorMessage)) {
                errorMessage = AcceleoEngineMessages.getString((String)"AcceleoUIActivator.UnexpectedException");
            }
            AcceleoUIActivator.log((IStatus)new Status(severity, PLUGIN_ID, errorMessage));
        }
    }
}

