/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.flash;

import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashTopNodeImpl;
import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;

class FlashVideoImpl
implements INodeExVideo,
IFlashConst {
    private final FlashTopNodeImpl swf;
    private final IASNode target;
    private final IASBridge player;
    private INodeExVideo.VideoState currentState = INodeExVideo.VideoState.STATE_UNKNOWN;

    FlashVideoImpl(FlashTopNodeImpl flashTopNodeImpl, IASNode iASNode) {
        this.swf = flashTopNodeImpl;
        this.target = iASNode;
        this.player = iASNode.getPlayer();
    }

    public boolean previousTrack() {
        return false;
    }

    public boolean nextTrack() {
        return false;
    }

    public boolean stopMedia() {
        this.player.callMethod(this.target, "stop");
        this.currentState = INodeExVideo.VideoState.STATE_STOP;
        return true;
    }

    public boolean playMedia() {
        this.player.callMethod(this.target, "play");
        this.currentState = INodeExVideo.VideoState.STATE_PLAY;
        return true;
    }

    public boolean pauseMedia() {
        this.player.callMethod(this.target, "pause");
        this.currentState = INodeExVideo.VideoState.STATE_PAUSE;
        return true;
    }

    public boolean fastReverse() {
        return false;
    }

    public boolean fastForward() {
        return false;
    }

    public double getCurrentPosition() {
        Object object = this.player.callMethod(this.target, "getCurrentPosition");
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        return 0.0;
    }

    public double getTotalLength() {
        return -1.0;
    }

    public INodeExVideo.VideoState getCurrentState() {
        return this.currentState;
    }

    public INodeEx getReferenceNode() {
        return this.swf;
    }

    public boolean setCurrentPosition(double d) {
        return false;
    }
}

