/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.MediaObjectImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

class WMP64NodeImpl
extends MediaObjectImpl {
    private boolean muteState;

    WMP64NodeImpl(NodeImpl nodeImpl, IDispatch iDispatch) {
        super(nodeImpl, iDispatch);
    }

    private boolean execControls(String string) {
        try {
            this.inode.invoke0(string);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private boolean putSettings(String string, Object object) {
        try {
            this.inode.put(string, object);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private Object getSettings(String string) {
        return Helper.get(this.inode, string);
    }

    public boolean fastForward() {
        return this.execControls("fastForward");
    }

    public boolean fastReverse() {
        return this.execControls("fastReverse");
    }

    public double getCurrentPosition() {
        Object object = Helper.get(this.inode, "currentPosition");
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        return 0.0;
    }

    public boolean setCurrentPosition(double d) {
        Object object = Helper.get(this.inode, "currentPosition");
        if (object instanceof Double) {
            return this.putSettings("currentPosition", new Double(d));
        }
        if (object instanceof Float) {
            return this.putSettings("currentPosition", new Float((float)d));
        }
        if (object instanceof Integer) {
            return this.putSettings("currentPosition", new Integer((int)d));
        }
        return false;
    }

    public double getTotalLength() {
        return -1.0;
    }

    public boolean nextTrack() {
        return this.execControls("next");
    }

    public boolean pauseMedia() {
        return this.execControls("pause");
    }

    public boolean playMedia() {
        return this.execControls("play");
    }

    public boolean previousTrack() {
        return this.execControls("previous");
    }

    public boolean stopMedia() {
        return this.execControls("stop");
    }

    public int getVolume() {
        Object object = this.getSettings("Volume");
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        if (n < -2000) {
            return 0;
        }
        return (n + 2000) * 1000 / 2000 + 0;
    }

    public boolean muteMedia(boolean bl) {
        if (this.putSettings("Mute", bl)) {
            this.muteState = bl;
            return true;
        }
        return false;
    }

    public boolean getMuteState() {
        Object object = this.getSettings("Mute");
        if (!(object instanceof Boolean)) {
            return false;
        }
        return (Boolean)object != false || this.muteState;
    }

    public boolean setVolume(int n) {
        n = (n = (n - 0) * 2000 / 1000) == 0 ? -10000 : (n -= 2000);
        return this.putSettings("Volume", n);
    }

    public INodeExVideo.VideoState getCurrentState() {
        Object object = Helper.get(this.inode, "PlayState");
        if (object instanceof Integer) {
            int n = (Integer)object;
            switch (n) {
                case 0: {
                    return INodeExVideo.VideoState.STATE_STOP;
                }
                case 1: {
                    return INodeExVideo.VideoState.STATE_PAUSE;
                }
                case 2: {
                    return INodeExVideo.VideoState.STATE_PLAY;
                }
                case 3: {
                    return INodeExVideo.VideoState.STATE_WAITING;
                }
                case 4: 
                case 6: {
                    return INodeExVideo.VideoState.STATE_FASTFORWARD;
                }
                case 5: 
                case 7: {
                    return INodeExVideo.VideoState.STATE_FASTREVERSE;
                }
            }
            return INodeExVideo.VideoState.STATE_STOP;
        }
        return INodeExVideo.VideoState.STATE_UNKNOWN;
    }
}

