/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.LowVisionProblemConverter;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateUnderlinedCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterMS;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSM;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogram;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogramBin;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.ImageReader;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageImage
implements IPageImage {
    private static final String NULL_STRING = "";
    public static final boolean DO_CHECK_CHARACTERS = false;
    public static final boolean DO_CHECK_IMAGES = true;
    private static int SURROUNDINGS_WIDTH = 2;
    private static int SCROLL_BAR_WIDTH = 20;
    private static boolean REMOVE_SURROUNDINGS = true;
    private static boolean REMOVE_SCROLL_BAR_AT_RIGHT = false;
    private static boolean REMOVE_SCROLL_BAR_AT_BOTTOM = false;
    private static int THRESHOLD_MIN_OCCURRENCES = 300;
    public IInt2D pixel = null;
    int numContainers;
    Container[] containers;
    int numNonContainedCharacters;
    CharacterSM[] nonContainedCharacters;
    boolean extractedFlag = false;
    public ImagePositionInfo[] imagePositions = null;
    public boolean useImagePositions = false;
    public InteriorImage[] interiorImageArray = null;
    int currentContainerID = 1;
    int[][] containerMap = null;
    Vector<Container> containerVector = new Vector();
    Vector<CandidateCharacter> candidateCharacterVector = new Vector();
    Vector<CandidateUnderlinedCharacter> candidateUnderlinedCharacterVector = new Vector();
    PrintWriter writer = null;

    public PageImage() {
    }

    public PageImage(IInt2D iInt2D) {
        this(iInt2D, true);
    }

    public PageImage(IInt2D iInt2D, boolean bl) {
        IInt2D iInt2D2 = null;
        if (bl) {
            int n;
            int n2;
            Int2D int2D;
            if (REMOVE_SURROUNDINGS) {
                try {
                    iInt2D2 = iInt2D.cutMargin(SURROUNDINGS_WIDTH);
                }
                catch (ImageException imageException) {
                    iInt2D2 = iInt2D;
                }
            } else {
                iInt2D2 = iInt2D;
            }
            if (REMOVE_SCROLL_BAR_AT_RIGHT) {
                int2D = new Int2D(iInt2D2.getWidth() - SCROLL_BAR_WIDTH, iInt2D2.getHeight());
                n2 = 0;
                while (n2 < int2D.getHeight()) {
                    n = 0;
                    while (n < int2D.getWidth()) {
                        int2D.getData()[n2][n] = iInt2D2.getData()[n2][n];
                        ++n;
                    }
                    ++n2;
                }
                iInt2D2 = int2D;
            }
            if (REMOVE_SCROLL_BAR_AT_BOTTOM) {
                int2D = new Int2D(iInt2D2.getWidth(), iInt2D2.getHeight() - SCROLL_BAR_WIDTH);
                n2 = 0;
                while (n2 < int2D.getHeight()) {
                    n = 0;
                    while (n < int2D.getWidth()) {
                        int2D.getData()[n2][n] = iInt2D2.getData()[n2][n];
                        ++n;
                    }
                    ++n2;
                }
                iInt2D2 = int2D;
            }
        } else {
            iInt2D2 = iInt2D;
        }
        this.pixel = iInt2D2.deepCopy();
        iInt2D2 = null;
    }

    public void init(BufferedImage bufferedImage) throws ImageException {
        this.pixel = ImageUtil.bufferedImageToInt2D(bufferedImage);
    }

    public static IPageImage readFromFile(String string) throws LowVisionIOException {
        BufferedImage bufferedImage = ImageReader.readBufferedImage(string);
        Int2D int2D = new Int2D(bufferedImage);
        PageImage pageImage = new PageImage(int2D);
        return pageImage;
    }

    @Override
    public int getWidth() {
        return this.pixel.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pixel.getHeight();
    }

    public int[][] getPixelData() {
        return this.pixel.getData();
    }

    @Override
    public BufferedImage getBufferedImage() {
        return ImageUtil.int2DToBufferedImage(this.pixel);
    }

    public IInt2D getInt2D() {
        return this.pixel;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public Container[] getContainers() {
        return this.containers;
    }

    public int getNumSMCharacters() {
        return this.numNonContainedCharacters;
    }

    public CharacterSM[] getSMCharacters() {
        return this.nonContainedCharacters;
    }

    public int getNumNonContainedCharacters() {
        return this.numNonContainedCharacters;
    }

    public CharacterSM[] getNonContainedCharacters() {
        return this.nonContainedCharacters;
    }

    public void setWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    @Override
    public ImagePositionInfo[] getInteriorImagePosition() {
        return this.imagePositions;
    }

    @Override
    public void setInteriorImagePosition(ImagePositionInfo[] imagePositionInfoArray) {
        if (imagePositionInfoArray != null) {
            this.imagePositions = imagePositionInfoArray;
        }
    }

    @Override
    public boolean hasInteriorImageArraySet() {
        return this.interiorImageArray != null && this.interiorImageArray.length != 0;
    }

    @Override
    public void extractCharacters() throws ImageException {
        if (this.imagePositions != null && this.imagePositions.length > 0) {
            this.useImagePositions = true;
        }
    }

    public void extractInteriorImages() {
        ImagePositionInfo imagePositionInfo;
        int n;
        if (this.imagePositions == null) {
            return;
        }
        int n2 = this.imagePositions.length;
        Vector<InteriorImage> vector = new Vector<InteriorImage>();
        if (REMOVE_SURROUNDINGS) {
            n = 0;
            while (n < n2) {
                imagePositionInfo = this.imagePositions[n];
                imagePositionInfo.setX(imagePositionInfo.getX() - SURROUNDINGS_WIDTH);
                if (imagePositionInfo.getX() < 0) {
                    imagePositionInfo.setX(0);
                }
                imagePositionInfo.setY(imagePositionInfo.getY() - SURROUNDINGS_WIDTH);
                if (imagePositionInfo.getY() < 0) {
                    imagePositionInfo.setY(0);
                }
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            imagePositionInfo = this.imagePositions[n];
            if (this.isFullyContained(imagePositionInfo)) {
                InteriorImage interiorImage = new InteriorImage(this, imagePositionInfo);
                interiorImage.setImageElement(imagePositionInfo.getElement());
                vector.addElement(interiorImage);
            }
            ++n;
        }
        n = vector.size();
        if (n > 0) {
            this.interiorImageArray = new InteriorImage[n];
            int n3 = 0;
            while (n3 < n) {
                this.interiorImageArray[n3] = (InteriorImage)vector.elementAt(n3);
                ++n3;
            }
        }
    }

    private boolean isFullyContained(ImagePositionInfo imagePositionInfo) {
        if (imagePositionInfo.getX() + imagePositionInfo.getWidth() > this.getWidth()) {
            return false;
        }
        return imagePositionInfo.getY() + imagePositionInfo.getHeight() <= this.getHeight();
    }

    public void extractAllCharacters() throws ImageException {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        Object object4;
        int n3;
        int n4;
        if (this.extractedFlag) {
            return;
        }
        int n5 = 0;
        this.containerMap = new int[this.pixel.getHeight()][this.pixel.getWidth()];
        ColorHistogram colorHistogram = ColorHistogram.makeColorHistogram(this.pixel);
        n5 = n4 = colorHistogram.getSize();
        ColorHistogramBin[] colorHistogramBinArray = colorHistogram.getSortedArrayByOccurrence();
        int n6 = 0;
        while (n6 < n4) {
            if (colorHistogramBinArray[n6].occurrence < THRESHOLD_MIN_OCCURRENCES) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n5) {
            n3 = colorHistogramBinArray[n6].color;
            object4 = new BinaryImage(this.pixel, 0, n3);
            object3 = new LabeledImage((BinaryImage)object4, 0);
            n2 = ((LabeledImage)object3).numComponents;
            object2 = ((LabeledImage)object3).components;
            int n7 = 0;
            while (n7 < n2) {
                PageComponent pageComponent;
                object = object2[n7];
                n = DecisionMaker.judgeComponentType((ConnectedComponent)object, this, true);
                if (n == 1) {
                    pageComponent = new Container(this, this.currentContainerID, (ConnectedComponent)object, n3);
                    this.containerVector.addElement((Container)pageComponent);
                    this.paintContainerMap(this.currentContainerID, (ConnectedComponent)object);
                    ++this.currentContainerID;
                } else if (n == 2) {
                    pageComponent = new CandidateCharacter(this, (ConnectedComponent)object, n3);
                    this.candidateCharacterVector.addElement((CandidateCharacter)pageComponent);
                } else if (n == 3) {
                    pageComponent = new CandidateUnderlinedCharacter(this, (ConnectedComponent)object, n3);
                    this.candidateUnderlinedCharacterVector.addElement((CandidateUnderlinedCharacter)pageComponent);
                } else if (n != 100) {
                    throw new ImageException("Unexpected type = " + n);
                }
                ++n7;
            }
            ++n6;
        }
        this.fillContainerMap(this.currentContainerID);
        n6 = this.candidateCharacterVector.size();
        n3 = n6 - 1;
        while (n3 >= 0) {
            object4 = this.candidateCharacterVector.elementAt(n3);
            int n8 = ((CandidateCharacter)object4).cc.shape.width;
            n2 = 0;
            while (n2 < n8) {
                if (((CandidateCharacter)object4).cc.shape.data[0][n2] != 0) break;
                ++n2;
            }
            int n9 = this.containerMap[((CandidateCharacter)object4).cc.top][((CandidateCharacter)object4).cc.left + n2];
            if (n9 > 0) {
                Container container = this.containerVector.elementAt(n9 - 1);
                ((CandidateCharacter)object4).setContainer(container);
                container.candidateCharacterVector.addElement((CandidateCharacter)object4);
                this.candidateCharacterVector.removeElementAt(n3);
            }
            --n3;
        }
        n3 = this.candidateUnderlinedCharacterVector.size();
        int n10 = n3 - 1;
        while (n10 >= 0) {
            object3 = this.candidateUnderlinedCharacterVector.elementAt(n10);
            n2 = ((CandidateUnderlinedCharacter)object3).cc.shape.width;
            int n11 = 0;
            while (n11 < n2) {
                if (((CandidateUnderlinedCharacter)object3).cc.shape.data[0][n11] != 0) break;
                ++n11;
            }
            int n12 = this.containerMap[((CandidateUnderlinedCharacter)object3).cc.top][((CandidateUnderlinedCharacter)object3).cc.left + n11];
            if (n12 > 0) {
                object = this.containerVector.elementAt(n12 - 1);
                ((CandidateUnderlinedCharacter)object3).setContainer((Container)object);
                ((Container)object).candidateUnderlinedCharacterVector.addElement((CandidateUnderlinedCharacter)object3);
                this.candidateUnderlinedCharacterVector.removeElementAt(n10);
            }
            --n10;
        }
        Vector<CharacterSM> vector = this.makeSMCharacterVector(this.candidateCharacterVector, this.candidateUnderlinedCharacterVector);
        this.candidateCharacterVector.removeAllElements();
        this.candidateUnderlinedCharacterVector.removeAllElements();
        int n13 = vector.size();
        n2 = n13 - 1;
        while (n2 >= 0) {
            object2 = vector.elementAt(n2);
            if (!DecisionMaker.isSMCharacter((CharacterSM)object2)) {
                vector.removeElementAt(n2);
            }
            --n2;
        }
        this.numNonContainedCharacters = vector.size();
        this.nonContainedCharacters = new CharacterSM[this.numNonContainedCharacters];
        n2 = 0;
        while (n2 < this.numNonContainedCharacters) {
            this.nonContainedCharacters[n2] = vector.elementAt(n2);
            ++n2;
        }
        vector.removeAllElements();
        vector = null;
        n2 = this.containerVector.size();
        int n14 = 0;
        while (n14 < n2) {
            int n15;
            Container container = this.containerVector.elementAt(n14);
            int n16 = container.cc.shape.width;
            n = container.cc.shape.height;
            int n17 = container.cc.left;
            int n18 = container.cc.top;
            int n19 = container.getColor();
            BinaryImage binaryImage = new BinaryImage(n16, n);
            BinaryImage binaryImage2 = new BinaryImage(n16, n);
            int n20 = 0;
            while (n20 < n) {
                int n21 = 0;
                while (n21 < n16) {
                    n15 = this.pixel.getData()[n20 + n18][n21 + n17];
                    try {
                        if (n15 == n19) {
                            binaryImage.data[n20][n21] = 1;
                        }
                    }
                    catch (Exception exception) {
                        throw new ImageException("An error occurred while making contBin.");
                    }
                    if (this.containerMap[n20 + n18][n21 + n17] == n14 + 1) {
                        binaryImage2.data[n20][n21] = 1;
                    }
                    ++n21;
                }
                ++n20;
            }
            BinaryImage binaryImage3 = BinaryImage.subtract(binaryImage2, binaryImage);
            LabeledImage labeledImage = new LabeledImage(binaryImage3, 0);
            n15 = labeledImage.numComponents;
            if (n15 != 0) {
                PageComponent pageComponent;
                PageComponent pageComponent2;
                int n22;
                ConnectedComponent[] connectedComponentArray = labeledImage.components;
                int n23 = n15 - 1;
                while (n23 >= 0) {
                    ConnectedComponent connectedComponent = connectedComponentArray[n23];
                    connectedComponent.setLeft(connectedComponent.getLeft() + n17);
                    connectedComponent.setTop(connectedComponent.getTop() + n18);
                    if (!this.collateCandidates(container, connectedComponent) && DecisionMaker.isMSCharacter(connectedComponent)) {
                        n22 = -1;
                        n22 = this.getForegroundColor(connectedComponent);
                        if (n22 == -1) {
                            pageComponent2 = new CharacterMS((IPageImage)this, connectedComponent, container, this.pixel);
                            container.msCharacterVector.addElement((CharacterMS)pageComponent2);
                        } else {
                            short s = DecisionMaker.judgeComponentType(connectedComponent, this);
                            if (s == 2) {
                                pageComponent = new CharacterSS(this, connectedComponent, container, n22);
                                container.ssCharacterVector.addElement((CharacterSS)pageComponent);
                            } else if (s == 3) {
                                pageComponent = new CandidateUnderlinedCharacter(this, connectedComponent, n22);
                                ((CandidateUnderlinedCharacter)pageComponent).setContainer(container);
                                container.ssCharacterVector.addAll(this.removeUnderlineAndGenerateSS((CandidateUnderlinedCharacter)pageComponent));
                            }
                        }
                    }
                    --n23;
                }
                Vector<CharacterSM> vector2 = this.makeSMCharacterVector(container.candidateCharacterVector, container.candidateUnderlinedCharacterVector);
                container.candidateCharacterVector.removeAllElements();
                container.candidateUnderlinedCharacterVector.removeAllElements();
                int n24 = vector2.size();
                n22 = n24 - 1;
                while (n22 >= 0) {
                    pageComponent2 = vector2.elementAt(n22);
                    if (((CharacterSM)pageComponent2).getForegroundColor() == container.getColor()) {
                        vector2.removeElementAt(n22);
                    } else if (this.includingMSCharacter((CharacterSM)pageComponent2, container) != null) {
                        vector2.removeElementAt(n22);
                    } else if (this.getBackgroundColor(((CharacterSM)pageComponent2).cc) > -1) {
                        pageComponent = new CharacterSS(this, ((CharacterSM)pageComponent2).cc, ((CharacterSM)pageComponent2).container, ((CharacterSM)pageComponent2).getForegroundColor());
                        container.ssCharacterVector.addElement((CharacterSS)pageComponent);
                        vector2.removeElementAt(n22);
                    }
                    --n22;
                }
                n22 = container.msCharacterVector.size();
                int n25 = n22 - 1;
                while (n25 >= 0) {
                    pageComponent = container.msCharacterVector.elementAt(n25);
                    if (DecisionMaker.isTooSmallThinedMSCharacter((CharacterMS)pageComponent)) {
                        container.msCharacterVector.removeElementAt(n25);
                    }
                    --n25;
                }
                container.ssVector2Array();
                container.msVector2Array();
                n25 = vector2.size();
                int n26 = n25 - 1;
                while (n26 >= 0) {
                    CharacterSM characterSM = vector2.elementAt(n26);
                    if (!DecisionMaker.isSMCharacter(characterSM)) {
                        vector2.removeElementAt(n26);
                    }
                    --n26;
                }
                container.numSMCharacters = vector2.size();
                container.smCharacters = new CharacterSM[container.numSMCharacters];
                n26 = 0;
                while (n26 < container.numSMCharacters) {
                    container.smCharacters[n26] = vector2.elementAt(n26);
                    ++n26;
                }
                vector2.removeAllElements();
                vector2 = null;
            }
            ++n14;
        }
        n14 = n2 - 1;
        while (n14 >= 0) {
            Container container = this.containerVector.elementAt(n14);
            if (container.numSSCharacters == 0 && container.numMSCharacters == 0 && container.numSMCharacters == 0) {
                this.containerVector.removeElementAt(n14);
            }
            --n14;
        }
        this.numContainers = this.containerVector.size();
        this.containers = new Container[this.numContainers];
        n14 = 0;
        while (n14 < this.numContainers) {
            this.containers[n14] = this.containerVector.elementAt(n14);
            ++n14;
        }
        this.containerVector.removeAllElements();
        this.extractedFlag = true;
    }

    private void paintContainerMap(int n, ConnectedComponent connectedComponent) {
        int n2 = connectedComponent.shape.width;
        int n3 = connectedComponent.shape.height;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                if (connectedComponent.shape.data[n4][n5] != 0) {
                    this.containerMap[connectedComponent.top + n4][connectedComponent.left + n5] = n;
                }
                ++n5;
            }
            ++n4;
        }
    }

    private void fillContainerMap(int n) throws ImageException {
        int n2 = 1;
        while (n2 < n) {
            this.fillOneContainer(n2);
            ++n2;
        }
    }

    private void fillOneContainer(int n) throws ImageException {
        Container container = this.containerVector.elementAt(n - 1);
        int n2 = container.cc.left;
        int n3 = container.cc.top;
        int n4 = n2 + container.cc.shape.width;
        int n5 = n3 + container.cc.shape.height;
        int[][] nArray = new int[this.pixel.getHeight()][this.pixel.getWidth()];
        int n6 = n3;
        while (n6 < n5) {
            boolean bl = false;
            boolean bl2 = false;
            int n7 = n2;
            while (n7 < n4) {
                if (this.containerMap[n6][n7] == n) {
                    if (!bl) {
                        nArray[n6][n7] = 1;
                        bl = true;
                        bl2 = false;
                    } else if (bl2) {
                        nArray[n6][n7] = 1;
                        bl2 = false;
                    }
                } else if (this.containerMap[n6][n7] > 0) {
                    bl2 = true;
                }
                ++n7;
            }
            n7 = 0;
            boolean bl3 = false;
            int n8 = n4 - 1;
            while (n8 >= n2) {
                if (this.containerMap[n6][n8] == n) {
                    if (n7 == 0) {
                        nArray[n6][n8] = nArray[n6][n8] != 1 ? 2 : 3;
                        n7 = 1;
                        bl3 = false;
                    } else if (bl3) {
                        nArray[n6][n8] = nArray[n6][n8] != 1 ? 2 : 3;
                        bl3 = false;
                    }
                } else if (this.containerMap[n6][n8] > 0) {
                    bl3 = true;
                }
                --n8;
            }
            n8 = 0;
            int n9 = n2;
            while (n9 < n4) {
                if (nArray[n6][n9] == 0 && n8 != 0) {
                    if (this.containerMap[n6][n9] != 0 && this.containerMap[n6][n9] != n) {
                        DebugUtil.outMsg(this, "i = " + n9 + ", j = " + n6);
                        DebugUtil.outMsg(this, "Dumping containerMap");
                        int n10 = 0;
                        while (n10 < this.pixel.getWidth()) {
                            System.err.print(NULL_STRING + this.containerMap[n6][n10]);
                            ++n10;
                        }
                        System.err.println(NULL_STRING);
                        DebugUtil.outMsg(this, "Dumping workMap");
                        n10 = 0;
                        while (n10 < this.pixel.getWidth()) {
                            System.err.print(NULL_STRING + nArray[n6][n10]);
                            ++n10;
                        }
                        System.err.println(NULL_STRING);
                        throw new ImageException("filling error 0: id = " + n);
                    }
                    this.containerMap[n6][n9] = n;
                } else if (nArray[n6][n9] == 1) {
                    if (n8 != 0) {
                        throw new ImageException("filling error 1: id = " + n);
                    }
                    n8 = 1;
                } else if (nArray[n6][n9] == 2) {
                    n8 = 0;
                }
                ++n9;
            }
            ++n6;
        }
    }

    private boolean collateCandidates(Container container, ConnectedComponent connectedComponent) throws ImageException {
        int n = container.candidateCharacterVector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            CandidateCharacter candidateCharacter = container.candidateCharacterVector.elementAt(n2);
            if (connectedComponent.equals(candidateCharacter.cc)) {
                CharacterSS characterSS = new CharacterSS(candidateCharacter);
                container.ssCharacterVector.addElement(characterSS);
                container.candidateCharacterVector.removeElementAt(n2);
                return true;
            }
            --n2;
        }
        n2 = container.candidateUnderlinedCharacterVector.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            CandidateUnderlinedCharacter candidateUnderlinedCharacter = container.candidateUnderlinedCharacterVector.elementAt(n3);
            if (connectedComponent.equals(candidateUnderlinedCharacter.cc)) {
                container.ssCharacterVector.addAll(this.removeUnderlineAndGenerateSS(candidateUnderlinedCharacter));
                container.candidateUnderlinedCharacterVector.removeElementAt(n3);
                return true;
            }
            --n3;
        }
        return false;
    }

    private int getForegroundColor(ConnectedComponent connectedComponent) {
        int n = -1;
        int n2 = 0;
        while (n2 < connectedComponent.shape.height) {
            int n3 = 0;
            while (n3 < connectedComponent.shape.width) {
                if (connectedComponent.shape.data[n2][n3] != 0) {
                    if (n == -1) {
                        n = this.pixel.getData()[n2 + connectedComponent.top][n3 + connectedComponent.left];
                    } else if (n != this.pixel.getData()[n2 + connectedComponent.top][n3 + connectedComponent.left]) {
                        return -1;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    private int getBackgroundColor(ConnectedComponent connectedComponent) {
        int n = -1;
        int n2 = 0;
        while (n2 < connectedComponent.shape.height) {
            int n3 = 0;
            while (n3 < connectedComponent.shape.width) {
                if (connectedComponent.shape.data[n2][n3] == 0) {
                    if (n == -1) {
                        n = this.pixel.getData()[n2 + connectedComponent.top][n3 + connectedComponent.left];
                    } else if (n != this.pixel.getData()[n2 + connectedComponent.top][n3 + connectedComponent.left]) {
                        return -1;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    private Vector<CharacterSM> makeSMCharacterVector(Vector<CandidateCharacter> vector, Vector<CandidateUnderlinedCharacter> vector2) throws ImageException {
        PageComponent pageComponent;
        Vector<CharacterSM> vector3 = new Vector<CharacterSM>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            CandidateCharacter candidateCharacter = vector.elementAt(n2);
            pageComponent = new CharacterSM(candidateCharacter, this.pixel);
            vector3.addElement((CharacterSM)pageComponent);
            ++n2;
        }
        n2 = vector2.size();
        int n3 = 0;
        while (n3 < n2) {
            pageComponent = vector2.elementAt(n3);
            vector3.addAll(this.removeUnderlineAndGenerateSM((CandidateUnderlinedCharacter)pageComponent));
            ++n3;
        }
        return vector3;
    }

    private CharacterMS includingMSCharacter(CharacterSM characterSM, Container container) {
        int n = 0;
        while (n < container.msCharacterVector.size()) {
            CharacterMS characterMS = container.msCharacterVector.elementAt(n);
            if (characterSM.cc.isIncludedBy(characterMS.cc)) {
                return characterMS;
            }
            ++n;
        }
        return null;
    }

    @Override
    public List<IProblemItem> checkCharacters(LowVisionType lowVisionType, String string, int n) throws ImageException, LowVisionProblemException {
        LowVisionProblemGroup[] lowVisionProblemGroupArray = null;
        LowVisionProblemGroup[] lowVisionProblemGroupArray2 = null;
        LowVisionProblemGroup[] lowVisionProblemGroupArray3 = null;
        if (this.useImagePositions) {
            this.extractInteriorImages();
            lowVisionProblemGroupArray2 = this.checkInteriorImages(lowVisionType);
            this.interiorImageArray = null;
        }
        lowVisionProblemGroupArray3 = lowVisionProblemGroupArray2 == null ? new LowVisionProblemGroup[]{} : lowVisionProblemGroupArray2;
        return LowVisionProblemConverter.convert(lowVisionProblemGroupArray3, string, n);
    }

    private LowVisionProblemGroup[] checkInteriorImages(LowVisionType lowVisionType) throws ImageException {
        LowVisionProblemGroup[] lowVisionProblemGroupArray;
        if (!this.useImagePositions) {
            return new LowVisionProblemGroup[0];
        }
        Vector<LowVisionProblemGroup> vector = new Vector<LowVisionProblemGroup>();
        int n = 0;
        if (this.interiorImageArray != null && this.interiorImageArray.length > 0) {
            n = this.interiorImageArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            lowVisionProblemGroupArray = this.interiorImageArray[n2];
            LowVisionProblemGroup[] lowVisionProblemGroupArray2 = lowVisionProblemGroupArray.checkColors(lowVisionType);
            if (lowVisionProblemGroupArray2 != null) {
                int n3 = lowVisionProblemGroupArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    vector.addElement(lowVisionProblemGroupArray2[n4]);
                    ++n4;
                }
            }
            ++n2;
        }
        n2 = vector.size();
        if (n2 > 0) {
            lowVisionProblemGroupArray = new LowVisionProblemGroup[n2];
            int n5 = 0;
            while (n5 < n2) {
                lowVisionProblemGroupArray[n5] = (LowVisionProblemGroup)vector.elementAt(n5);
                ++n5;
            }
            vector = null;
            return lowVisionProblemGroupArray;
        }
        vector = null;
        return new LowVisionProblemGroup[0];
    }

    private LabeledImage removeUnderlineAndCCL(CandidateUnderlinedCharacter candidateUnderlinedCharacter) throws ImageException {
        BinaryImage binaryImage = candidateUnderlinedCharacter.cc.shape;
        BinaryImage binaryImage2 = binaryImage.drawUnderline();
        BinaryImage binaryImage3 = binaryImage.subtract(binaryImage2);
        LabeledImage labeledImage = new LabeledImage(binaryImage3, 0);
        return labeledImage;
    }

    private Vector<CharacterSS> removeUnderlineAndGenerateSS(CandidateUnderlinedCharacter candidateUnderlinedCharacter) throws ImageException {
        Vector<CharacterSS> vector = new Vector<CharacterSS>();
        int n = candidateUnderlinedCharacter.cc.left;
        int n2 = candidateUnderlinedCharacter.cc.top;
        short s = candidateUnderlinedCharacter.cc.connectivity;
        LabeledImage labeledImage = this.removeUnderlineAndCCL(candidateUnderlinedCharacter);
        int n3 = labeledImage.numComponents;
        int n4 = 0;
        while (n4 < n3) {
            ConnectedComponent connectedComponent = labeledImage.components[n4];
            connectedComponent.left += n;
            connectedComponent.top += n2;
            connectedComponent.connectivity = s;
            if (DecisionMaker.judgeComponentType(connectedComponent, this) == 2) {
                CharacterSS characterSS = new CharacterSS(this, connectedComponent, candidateUnderlinedCharacter.container, candidateUnderlinedCharacter.getForegroundColor());
                vector.addElement(characterSS);
            }
            ++n4;
        }
        return vector;
    }

    private Vector<CharacterSM> removeUnderlineAndGenerateSM(CandidateUnderlinedCharacter candidateUnderlinedCharacter) throws ImageException {
        Vector<CharacterSM> vector = new Vector<CharacterSM>();
        int n = candidateUnderlinedCharacter.cc.left;
        int n2 = candidateUnderlinedCharacter.cc.top;
        short s = candidateUnderlinedCharacter.cc.connectivity;
        LabeledImage labeledImage = this.removeUnderlineAndCCL(candidateUnderlinedCharacter);
        int n3 = labeledImage.numComponents;
        int n4 = 0;
        while (n4 < n3) {
            ConnectedComponent connectedComponent = labeledImage.components[n4];
            connectedComponent.left += n;
            connectedComponent.top += n2;
            connectedComponent.connectivity = s;
            if (DecisionMaker.judgeComponentType(connectedComponent, this) == 2) {
                CharacterSM characterSM = new CharacterSM((IPageImage)this, connectedComponent, candidateUnderlinedCharacter.container, candidateUnderlinedCharacter.getForegroundColor(), this.pixel);
                vector.addElement(characterSM);
            }
            ++n4;
        }
        return vector;
    }

    @Override
    public void writeToBMPFile(String string) throws LowVisionIOException {
        this.pixel.writeToBMPFile(string);
    }

    @Override
    public void writeToBMPFile(String string, int n) throws LowVisionIOException {
        this.pixel.writeToBMPFile(string, n);
    }
}

