/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.Collection;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.SContext;
import org.metaabm.SContinuousSpace;
import org.metaabm.SGeography;
import org.metaabm.SGrid;
import org.metaabm.SNetwork;
import org.metaabm.SProjection;
import org.metaabm.act.AAct;
import org.metaabm.act.ABuild;
import org.metaabm.act.ABuildProjection;
import org.metaabm.act.ABuildSpace;
import org.metaabm.act.AGroup;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.commands.AddAgentsActsCommand;

public class AddSpacesActsCommand
extends AbstractOverrideableCommand {
    protected CompoundCommand command;
    SContext parent;
    Collection<?> spaces;

    public AddSpacesActsCommand(EditingDomain domain, SContext parent, Collection<?> spaces) {
        super(domain, "Add Agent Acts");
        this.spaces = spaces;
        this.parent = parent;
    }

    public Collection<?> doGetAffectedObjects() {
        return this.spaces;
    }

    public boolean doCanExecute() {
        return this.parent != null;
    }

    public static ABuildProjection findBuilderOf(SContext context, SProjection proj) {
        AGroup root = (AGroup)context.getRootActivity();
        if (root != null) {
            for (AAct act : root.getMembers()) {
                if (!(act instanceof ABuildProjection) || ((ABuildProjection)act).getProjection() != proj) continue;
                return (ABuildProjection)act;
            }
        }
        return null;
    }

    public void doExecute() {
        this.command = new CompoundCommand("Add Agent Activities and Attributes");
        for (Object object : this.spaces) {
            ABuildProjection spaceBuilder;
            SProjection space = (SProjection)object;
            if (this.parent == null) continue;
            ABuild builder = AddAgentsActsCommand.findBuilderOf(this.parent);
            if (builder == null) {
                builder = MetaABMActFactory.eINSTANCE.createABuild();
                this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)this.parent.getRootActivity(), (Object)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)builder));
            }
            if ((spaceBuilder = AddSpacesActsCommand.findBuilderOf(this.parent, space)) != null) continue;
            this.createSpaceBuilder(space, builder);
        }
    }

    protected void createSpaceBuilder(SProjection proj, ABuild builder) {
        ABuildSpace projBuilder = null;
        String name = "Build ";
        if (proj instanceof SContinuousSpace) {
            projBuilder = MetaABMActFactory.eINSTANCE.createABuildSpace();
            name = String.valueOf(name) + "Space";
        } else if (proj instanceof SGrid) {
            projBuilder = MetaABMActFactory.eINSTANCE.createABuildGrid();
            name = String.valueOf(name) + "Grid";
        } else if (proj instanceof SGeography) {
            projBuilder = MetaABMActFactory.eINSTANCE.createABuildGeography();
            name = String.valueOf(name) + "Geography";
        } else if (proj instanceof SNetwork) {
            projBuilder = MetaABMActFactory.eINSTANCE.createABuildNetwork();
            name = String.valueOf(name) + "Network";
        }
        this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)builder, (Object)MetaABMActPackage.Literals.AACT__TARGETS, (Object)projBuilder));
        if (this.parent.getAgents().size() == 1) {
            this.command.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)projBuilder, (Object)MetaABMActPackage.Literals.ABUILD_PROJECTION__AGENTS, (Object)this.parent.getAgents().get(0)));
        }
        this.command.appendAndExecute(SetCommand.create((EditingDomain)this.domain, (Object)projBuilder, (Object)MetaABMActPackage.Literals.ABUILD_PROJECTION__PROJECTION, (Object)proj));
    }

    public void doRedo() {
        this.command.redo();
    }

    public void doUndo() {
        this.command.undo();
    }
}

