/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.general;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class Finance {
    private static final String DDB = "ddb";
    private static final String SLN = "sln";
    private static final String SYD = "syd";
    private static final String FV = "fv";
    private static final String PMT = "pmt";
    private static final String IPMT = "ipmt";
    private static final String PPMT = "ppmt";
    private static final String NPER = "nper";
    private static final String PV = "pv";
    private static final String RATE = "rate";
    private static final String PERCENT = "percent";
    private static final String NPV = "npv";
    private static final String IRR = "irr";
    private static final String MIRR = "mirr";

    private Finance() {
    }

    private static double getDouble(Object o) throws BirtException {
        if (o == null) {
            return Double.NaN;
        }
        return DataTypeUtil.toDouble((Object)o);
    }

    private static int getInteger(Object o) throws BirtException {
        if (o == null) {
            return 0;
        }
        return DataTypeUtil.toInteger((Object)o);
    }

    static double ddb(double cost, double salvage, double life, int period) throws IllegalArgumentException {
        double prior = 0.0;
        double depr = 0.0;
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0 || period <= 0 || life == Double.NaN || salvage == Double.NaN || Double.isNaN(cost) || Double.isNaN(period)) {
            throw new IllegalArgumentException("There exists illegal parameter in the function DDB");
        }
        int x = 0;
        while (x < period) {
            double basis = cost - prior;
            depr = Math.min(basis - salvage, basis * (1.0 / life) * 2.0);
            prior += depr;
            ++x;
        }
        return depr;
    }

    static double sln(double cost, double salvage, double life) throws IllegalArgumentException {
        return (cost - salvage) / life;
    }

    static double syd(double cost, double salvage, double life, int period) throws IllegalArgumentException {
        return (cost - salvage) * (life - (double)period + 1.0) * 2.0 / (life * (life + 1.0));
    }

    static double fv(double rate, int nPer, double pmt, double pv, int due) throws IllegalArgumentException {
        double fv = 0.0;
        int start = 0;
        int end = 0;
        if (rate < 0.0 || nPer < 0 || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function FV");
        }
        switch (due) {
            case 1: {
                start = 1;
                end = nPer;
                break;
            }
            case 0: {
                start = 0;
                end = nPer - 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("There exists illegal parameter" + due);
            }
        }
        int i = start;
        while (i <= end) {
            fv += Math.pow(1.0 + rate, i);
            ++i;
        }
        fv *= pmt;
        if (pv != 0.0) {
            fv += pv * Math.pow(1.0 + rate, nPer);
        }
        return 0.0 - fv;
    }

    static double pmt(double rate, int nper, double pv, double fv, int due) throws IllegalArgumentException {
        double pmt;
        if (nper <= 0) {
            throw new IllegalArgumentException("There exists illegal parameter  nper=" + nper);
        }
        if (due != 0 && due != 1) {
            throw new IllegalArgumentException("There exists illegal parameter due=" + due);
        }
        if (rate == 0.0) {
            pmt = -(fv + pv) / (double)nper;
        } else {
            double denom = Math.pow(1.0 + rate, nper);
            pmt = (-fv - pv * denom) * (rate / ((1.0 + rate * (double)due) * (denom - 1.0)));
        }
        return pmt;
    }

    static double ipmt(double rate, int per, int nPer, double pv, double fv, int due) throws IllegalArgumentException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function IPMT");
        }
        double pmt = Finance.pmt(rate, nPer, pv, fv, due);
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            if (curper != 1 || due == 0) {
                ipmt = rate * principal;
            }
            ppmt = pmt - ipmt;
            principal -= ppmt;
            ++curper;
        }
        return ipmt;
    }

    static double ppmt(double rate, int per, int nPer, double pv, double fv, int due) throws IllegalArgumentException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function PPMT");
        }
        double pmt = Finance.pmt(rate, nPer, pv, fv, due);
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            ppmt = pmt - ipmt;
            ipmt = rate * (principal -= ppmt);
            ++curper;
        }
        return ppmt;
    }

    static double nper(double rate, double pmt, double pv, double fv, int due) throws IllegalArgumentException {
        double retval = 0.0;
        if (rate == 0.0) {
            retval = -1.0 * (fv + pv) / pmt;
        } else {
            double r1 = rate + 1.0;
            double ryr = (due == 1 ? r1 : 1.0) * pmt / rate;
            double a1 = ryr - fv < 0.0 ? Math.log(fv - ryr) : Math.log(ryr - fv);
            double a2 = ryr - fv < 0.0 ? Math.log(-pv - ryr) : Math.log(pv + ryr);
            double a3 = Math.log(r1);
            retval = (a1 - a2) / a3;
        }
        return retval;
    }

    static double pv(double rate, int nPer, double pmt, double fv, int due) throws IllegalArgumentException {
        double pv = 0.0;
        if (nPer < 0 || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function PV");
        }
        if (rate == 0.0) {
            pv = -fv - pmt * (double)nPer;
        } else {
            double denom = Math.pow(1.0 + rate, nPer);
            double num = -fv - pmt * (1.0 + rate * (double)due) * (denom - 1.0) / rate;
            pv = num / denom;
        }
        return pv;
    }

    private static double solvePmt(int nPer, double true_pmt, double loanamt, double fv, int due, double rate, double incr, int attempt, boolean found) {
        double tolerance = 1.0E-7;
        if (attempt > 1000) {
            found = false;
            return -1.0;
        }
        double diff1 = true_pmt - Finance.pmt(rate + incr, nPer, loanamt, fv, due);
        if (Math.abs(diff1) <= tolerance) {
            found = true;
            return rate + incr;
        }
        double diff2 = true_pmt - Finance.pmt(rate, nPer, loanamt, fv, due);
        if (Math.abs(diff2) <= tolerance) {
            found = true;
            return rate;
        }
        if (diff1 * diff2 < 0.0) {
            incr /= 10.0;
        } else {
            rate += incr;
        }
        return Finance.solvePmt(nPer, true_pmt, loanamt, fv, due, rate, incr, ++attempt, found);
    }

    static double rate(int nPer, double pmt, double pv, double fv, int due, double guess) throws IllegalArgumentException {
        double tmp;
        double incr = 0.1;
        boolean found = true;
        double result = 0.0;
        if (nPer <= 0 || due != 1 && due != 0) {
            if (nPer <= 0) {
                throw new IllegalArgumentException("There exists illegal parameter:" + nPer);
            }
            throw new IllegalArgumentException("There exists illegal parameter:" + due);
        }
        int i = 5;
        double curr_guess = guess;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = 0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess /= 2.0;
            --i;
        }
        i = 4;
        curr_guess = guess * 2.0;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = 0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess *= 2.0;
            --i;
        }
        i = 5;
        curr_guess = guess;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = -0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess /= 2.0;
            --i;
        }
        i = 4;
        curr_guess = guess * 2.0;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = -0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess *= 2.0;
            --i;
        }
        throw new IllegalArgumentException("User should reset a new rate guess");
    }

    static double percent(double denom, double num, double valueIfZero) {
        if (num == 0.0) {
            return valueIfZero;
        }
        if (denom == 0.0) {
            throw new IllegalArgumentException("There exists illegal parameter:" + denom);
        }
        return num / denom * 100.0;
    }

    static double npv(double rate, double[] arptr) throws IllegalArgumentException {
        double r1;
        if (arptr == null) {
            throw new IllegalArgumentException("There exists illegal parameter:arptr");
        }
        double npv = 0.0;
        double trate = r1 = 1.0 + rate;
        int i = 0;
        while (i < arptr.length) {
            npv += arptr[i] / trate;
            trate *= r1;
            ++i;
        }
        return npv;
    }

    private static double calcIrr(double[] cash, double intrate, double inc, int attempt) {
        double npv2;
        double tolerance = 1.0E-7;
        if (attempt > 1000) {
            return -1.0;
        }
        double npv1 = Finance.npv(intrate + inc, cash);
        if (Math.abs(npv1 - (npv2 = Finance.npv(intrate, cash))) <= tolerance) {
            return intrate + inc;
        }
        if (npv2 * npv1 < 0.0) {
            inc /= 10.0;
        } else {
            intrate += inc;
        }
        return Finance.calcIrr(cash, intrate, inc, ++attempt);
    }

    static double irr(double[] cash, double intrate) throws IllegalArgumentException {
        double result;
        double incr;
        boolean arg1Positive = true;
        long arsize = 0L;
        arsize = cash.length;
        double tmp = cash[0];
        if (tmp < 0.0) {
            arg1Positive = false;
        } else if (tmp > 0.0) {
            arg1Positive = true;
        } else {
            throw new IllegalArgumentException("BADSIGNSINARRAY");
        }
        boolean found = false;
        int i = 1;
        while ((long)i <= arsize) {
            tmp = cash[i - 1];
            if (arg1Positive && tmp < 0.0 || !arg1Positive && tmp > 0.0) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new IllegalArgumentException("BADSIGNSINARRAY");
        }
        i = 10;
        double curr_rate = intrate;
        --i;
        while (i > 0) {
            double d;
            incr = 0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d < 0.0 && result != -1.0) {
                return result;
            }
            curr_rate /= 2.0;
            --i;
        }
        i = 4;
        curr_rate = intrate * 2.0;
        --i;
        while (i > 0) {
            double d;
            incr = 0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d >= 0.0) {
                return result;
            }
            curr_rate *= 2.0;
            --i;
        }
        i = 10;
        curr_rate = intrate;
        --i;
        while (i > 0) {
            double d;
            incr = -0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d < 0.0 && result != -1.0) {
                return result;
            }
            curr_rate /= 2.0;
            --i;
        }
        i = 4;
        curr_rate = intrate * 2.0;
        --i;
        while (i > 0) {
            double d;
            incr = -0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d >= 0.0) {
                return result;
            }
            curr_rate *= 2.0;
            --i;
        }
        throw new IllegalArgumentException("NOSOLUTIONFOUND");
    }

    private static double neg_npv(double rate, double[] arptr) {
        double r1;
        double npv = 0.0;
        double trate = r1 = 1.0 + rate;
        int i = 0;
        while (i < arptr.length) {
            if (arptr[i] < 0.0) {
                npv += arptr[i] / trate;
            }
            trate *= r1;
            ++i;
        }
        return npv;
    }

    private static double pos_npv(double rate, double[] arptr) {
        double r1;
        double npv = 0.0;
        double trate = r1 = 1.0 + rate;
        int i = 0;
        while (i < arptr.length) {
            if (arptr[i] >= 0.0) {
                npv += arptr[i] / trate;
            }
            trate *= r1;
            ++i;
        }
        return npv;
    }

    static double mirr(double[] arptr, double frate, double rrate) throws IllegalArgumentException {
        if (arptr == null) {
            throw new IllegalArgumentException("ARRAYREFERR");
        }
        int negCount = 0;
        int posCount = 0;
        int i = 0;
        while (i < arptr.length) {
            if (arptr[i] >= 0.0) {
                ++posCount;
            } else {
                ++negCount;
            }
            ++i;
        }
        if (negCount == 0 || posCount == 0) {
            throw new IllegalArgumentException("ARRAYREFERR");
        }
        double posNpv = Finance.pos_npv(rrate, arptr);
        double negNpv = Finance.neg_npv(frate, arptr);
        double tmp = -posNpv * Math.pow(1.0 + rrate, arptr.length) / (negNpv * (1.0 + frate));
        return Math.pow(tmp, 1.0 / (double)(arptr.length - 1)) - 1.0;
    }

    static IScriptFunctionExecutor getExecutor(String functionName) throws BirtException {
        if (DDB.equals(functionName)) {
            return new DdbScriptFunctionExecutor();
        }
        if (SLN.equals(functionName)) {
            return new SlnScriptFunctionExecutor();
        }
        if (SYD.equals(functionName)) {
            return new SydScriptFunctionExecutor();
        }
        if (FV.equals(functionName)) {
            return new FvScriptFunctionExecutor();
        }
        if (PMT.equals(functionName)) {
            return new PmtScriptFunctionExecutor();
        }
        if (IPMT.equals(functionName)) {
            return new IpmtScriptFunctionExecutor();
        }
        if (PPMT.equals(functionName)) {
            return new PpmtScriptFunctionExecutor();
        }
        if (NPER.equals(functionName)) {
            return new NperScriptFunctionExecutor();
        }
        if (PV.equals(functionName)) {
            return new PvScriptFunctionExecutor();
        }
        if (RATE.equals(functionName)) {
            return new RateScriptFunctionExecutor();
        }
        if (PERCENT.equals(functionName)) {
            return new PercentScriptFunctionExecutor();
        }
        if (NPV.equals(functionName)) {
            return new NpvScriptFunctionExecutor();
        }
        if (IRR.equals(functionName)) {
            return new IrrScriptFunctionExecutor();
        }
        if (MIRR.equals(functionName)) {
            return new MirrScriptFunctionExecutor();
        }
        throw new BirtException("org.eclipse.birt.core.script.function.general", null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "Finance." + functionName));
    }

    private static class DdbScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private DdbScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 4) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.ddb()"));
            }
            return Finance.ddb(Finance.getDouble(arguments[0]), Finance.getDouble(arguments[1]), Finance.getDouble(arguments[2]), Finance.getInteger(arguments[3]));
        }
    }

    private static class FvScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private FvScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 5) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.fv()"));
            }
            return Finance.fv(Finance.getDouble(arguments[0]), Finance.getInteger(arguments[1]), Finance.getDouble(arguments[2]), Finance.getDouble(arguments[3]), Finance.getInteger(arguments[4]));
        }
    }

    private static class IpmtScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private IpmtScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 6) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.ipmt()"));
            }
            return Finance.ipmt(Finance.getDouble(arguments[0]), Finance.getInteger(arguments[1]), Finance.getInteger(arguments[2]), Finance.getDouble(arguments[3]), Finance.getDouble(arguments[4]), Finance.getInteger(arguments[5]));
        }
    }

    private static class IrrScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private IrrScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.irr()"));
            }
            if (arguments[0] instanceof Object[]) {
                Object[] array = (Object[])arguments[0];
                double[] arg = new double[array.length];
                int i = 0;
                while (i < arg.length) {
                    arg[i] = Finance.getDouble(array[i]);
                    ++i;
                }
                return Finance.irr(arg, Finance.getDouble(arguments[1]));
            }
            if (arguments[0].getClass().isAssignableFrom(double[].class)) {
                return Finance.irr((double[])arguments[0], Finance.getDouble(arguments[1]));
            }
            throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.type.of.argument")) + "Finance.irr()"));
        }
    }

    private static class MirrScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private MirrScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2 && arguments.length != 3) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.mirr()"));
            }
            if (arguments[0] instanceof Object[]) {
                Object[] array = (Object[])arguments[0];
                double[] arg = new double[array.length];
                int i = 0;
                while (i < arg.length) {
                    arg[i] = Finance.getDouble(array[i]);
                    ++i;
                }
                return Finance.mirr(arg, Finance.getDouble(arguments[1]), arguments.length == 3 ? Finance.getDouble(arguments[2]) : 0.0);
            }
            if (arguments[0].getClass().isAssignableFrom(double[].class)) {
                return Finance.mirr((double[])arguments[0], Finance.getDouble(arguments[1]), arguments.length == 3 ? Finance.getDouble(arguments[2]) : 0.0);
            }
            throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.type.of.argument")) + "Finance.mirr()"));
        }
    }

    private static class NperScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private NperScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 5) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.nper()"));
            }
            return Finance.nper(Finance.getDouble(arguments[0]), Finance.getDouble(arguments[1]), Finance.getDouble(arguments[2]), Finance.getDouble(arguments[3]), Finance.getInteger(arguments[4]));
        }
    }

    private static class NpvScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private NpvScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.npv()"));
            }
            if (arguments[1] instanceof Object[]) {
                Object[] array = (Object[])arguments[1];
                double[] arg = new double[array.length];
                int i = 0;
                while (i < arg.length) {
                    arg[i] = Finance.getDouble(array[i]);
                    ++i;
                }
                return Finance.npv(Finance.getDouble(arguments[0]), arg);
            }
            throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.type.of.argument")) + "Finance.npv()"));
        }
    }

    private static class PercentScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private PercentScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 2 && arguments.length != 3) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.percent()"));
            }
            return Finance.percent(Finance.getDouble(arguments[0]), Finance.getDouble(arguments[1]), arguments.length == 3 ? Finance.getDouble(arguments[2]) : 0.0);
        }
    }

    private static class PmtScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private PmtScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 5) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.pmt()"));
            }
            return Finance.pmt(Finance.getDouble(arguments[0]), Finance.getInteger(arguments[1]), Finance.getDouble(arguments[2]), Finance.getDouble(arguments[3]), Finance.getInteger(arguments[4]));
        }
    }

    private static class PpmtScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private PpmtScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 6) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.ppmt()"));
            }
            return Finance.ppmt(Finance.getDouble(arguments[0]), Finance.getInteger(arguments[1]), Finance.getInteger(arguments[2]), Finance.getDouble(arguments[3]), Finance.getDouble(arguments[4]), Finance.getInteger(arguments[5]));
        }
    }

    private static class PvScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private PvScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 5) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.pv()"));
            }
            return Finance.pv(Finance.getDouble(arguments[0]), Finance.getInteger(arguments[1]), Finance.getDouble(arguments[2]), Finance.getDouble(arguments[3]), Finance.getInteger(arguments[4]));
        }
    }

    private static class RateScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private RateScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 6) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.rate()"));
            }
            return Finance.rate(Finance.getInteger(arguments[0]), Finance.getDouble(arguments[1]), Finance.getDouble(arguments[2]), Finance.getDouble(arguments[3]), Finance.getInteger(arguments[4]), Finance.getDouble(arguments[5]));
        }
    }

    private static class SlnScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private SlnScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 3) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.sln()"));
            }
            return Finance.sln(Finance.getDouble(arguments[0]), Finance.getDouble(arguments[1]), Finance.getDouble(arguments[2]));
        }
    }

    private static class SydScriptFunctionExecutor
    implements IScriptFunctionExecutor {
        private SydScriptFunctionExecutor() {
        }

        public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
            if (arguments == null || arguments.length != 4) {
                throw new BirtException("org.eclipse.birt.core.script.general", null, (Object)(String.valueOf(Messages.getString("invalid.number.of.argument")) + "Finance.syd()"));
            }
            return Finance.syd(Finance.getDouble(arguments[0]), Finance.getDouble(arguments[1]), Finance.getDouble(arguments[2]), Finance.getInteger(arguments[3]));
        }
    }
}

