/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ChildrenAllowedNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.FilterConfig;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.IDBNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.ProcedureFlagNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.TableNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaNode
extends ChildrenAllowedNode
implements Comparable<SchemaNode> {
    private static Logger logger = Logger.getLogger(SchemaNode.class.getName());
    private static String SCHEMA_ICON = String.valueOf(SchemaNode.class.getName()) + ".SchemaIcon";
    private String schemaName;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(SCHEMA_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/schema.gif"));
    }

    public SchemaNode(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    protected IDBNode[] refetchChildren(FilterConfig fc) {
        ResultSet rs;
        String[] tableTypes = fc.getTableTypesForJDBC();
        ArrayList<ChildrenAllowedNode> children = new ArrayList<ChildrenAllowedNode>();
        if (tableTypes != null && (rs = JdbcMetaDataProvider.getInstance().getAlltables(this.schemaName, fc.getNamePattern(), tableTypes)) != null) {
            int maxTableCountPerSchema = fc.getMaxTableCountPerSchema();
            int count = 0;
            try {
                while (rs.next() && count < maxTableCountPerSchema) {
                    String tableName = rs.getString("TABLE_NAME");
                    String type = rs.getString("TABLE_TYPE");
                    TableNode table = new TableNode(this.schemaName, tableName, "VIEW".equalsIgnoreCase(type));
                    children.add(table);
                    ++count;
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        if (JdbcMetaDataProvider.getInstance().isSupportProcedure() && (fc.getType() == FilterConfig.Type.ALL || fc.getType() == FilterConfig.Type.PROCEDURE)) {
            children.add(new ProcedureFlagNode(this.schemaName));
        }
        return children.toArray(new IDBNode[0]);
    }

    @Override
    public int compareTo(SchemaNode o) {
        return this.schemaName.compareTo(o.schemaName);
    }

    @Override
    public String getDisplayName(String metadataBidiFormatStr) {
        return BidiTransform.transform((String)this.schemaName, (String)metadataBidiFormatStr, (String)"ILYNN");
    }

    @Override
    public Image getImage() {
        return JFaceResources.getImageRegistry().get(SCHEMA_ICON);
    }

    @Override
    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString, boolean includeSchema, String metadataBidiFormatStr) {
        String quoteFlag = "";
        if (useIdentifierQuoteString) {
            quoteFlag = JdbcMetaDataProvider.getInstance().getIdentifierQuoteString();
        }
        return Utility.quoteString(BidiTransform.transform((String)this.schemaName, (String)metadataBidiFormatStr, (String)"ILYNN"), quoteFlag);
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

