/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ConnectionMetaData;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Table;

public class Schema
implements Serializable {
    private static final long serialVersionUID = 4701365854117670629L;
    private String name = null;
    private ArrayList tables = null;
    private ConnectionMetaData metaData = null;
    private long timeout;

    Schema(ConnectionMetaData metaData, long timeout) {
        this.metaData = metaData;
        this.timeout = timeout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getTables() throws SQLException {
        if (this.tables == null) {
            Thread h = new Thread(){

                public void run() {
                    try {
                        Schema.this.retrieveTables();
                    }
                    catch (SQLException sQLException) {}
                }
            };
            h.start();
            try {
                h.join(this.timeout);
            }
            catch (InterruptedException interruptedException) {}
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
        }
        return this.tables;
    }

    public Table getTable(String tableName) throws SQLException {
        Table table2 = null;
        for (Table table2 : this.getTables()) {
            if (!tableName.equals(table2.getName())) continue;
            return table2;
        }
        return null;
    }

    private synchronized void retrieveTables() throws SQLException {
        if (this.tables == null) {
            this.tables = new ArrayList();
            ResultSet resultset = this.metaData.getMetaData().getTables(this.metaData.getCatalogname(), this.getName(), null, null);
            Table table = null;
            while (resultset.next()) {
                table = new Table(this);
                table.setName(resultset.getString("TABLE_NAME"));
                table.setType(resultset.getString("TABLE_TYPE"));
                this.tables.add(table);
            }
        }
    }

    ConnectionMetaData getMetaData() {
        return this.metaData;
    }

    protected void finalize() throws Throwable {
        this.tables.clear();
        super.finalize();
    }
}

