/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.sampledb.ui;

import java.util.Properties;
import org.eclipse.birt.report.data.oda.sampledb.ui.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SampleDataSetEditor
extends DataSetWizardPage {
    private DataSetDesign datasetDesign;
    private DataSourceDesign dataSourceDesign;
    private Properties props;
    private static final String SAMPLE_DB_SCHEMA = "ClassicModels";

    public SampleDataSetEditor(String pageName) {
        super(pageName);
    }

    public void createPageCustomControl(Composite parent) {
        this.initializeControl();
        this.setControl(this.createPageControl(parent));
    }

    private void initializeControl() {
        this.datasetDesign = this.getInitializationDesign();
        this.dataSourceDesign = this.datasetDesign.getDataSourceDesign();
    }

    public Control createPageControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)new GridData(1808));
        Label txt = new Label(content, 16384);
        txt.setText(Messages.formatMessage("datasource.upgrade.msg.firstLine", new Object[]{this.dataSourceDesign.getName()}));
        Label nextLineLabel = new Label(content, 16384);
        nextLineLabel.setText(Messages.formatMessage("datasource.upgrade.msg.secondLine", new Object[]{this.dataSourceDesign.getName()}));
        Label thirdLineLabel = new Label(content, 16384);
        thirdLineLabel.setText(Messages.getMessage("datasource.upgrade.msg.thirdLine"));
        return content;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty("odaDriverClass", "org.eclipse.birt.report.data.oda.sampledb.Driver");
        this.props.setProperty("odaURL", "jdbc:classicmodels:sampledb");
        this.props.setProperty("odaUser", SAMPLE_DB_SCHEMA);
        this.props.setProperty("odaPassword", "");
        design.getDataSourceDesign().setOdaExtensionId("org.eclipse.birt.report.data.oda.jdbc");
        try {
            design.getDataSourceDesign().setPublicProperties(DesignSessionUtil.createDataSourcePublicProperties((String)"org.eclipse.birt.report.data.oda.jdbc", (Properties)this.props));
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        return design;
    }

    protected boolean canLeave() {
        return true;
    }
}

