/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.property;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.birt.report.designer.data.ui.property.PropertyContentProvider;
import org.eclipse.birt.report.designer.data.ui.property.PropertyLabelProvider;
import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractPropertyDialog
extends BaseDialog
implements IPropertyPageContainer,
IPageChangeProvider {
    private static final String SASHFORM_RIGHT = "SASHFORM.RIGHT";
    private static final String SASHFORM_LEFT = "SASHFORM.LEFT";
    private transient Object modelObject = null;
    protected transient PropertyNode rootNode = null;
    private transient StackLayout propertyPaneLayout = null;
    private transient Composite propertyPane = null;
    private transient PropertyNode currentNode = null;
    private transient boolean processSelection = true;
    private transient Label titleImage = null;
    protected TreeViewer viewer = null;
    private DialogMessageArea messageArea = null;
    private String nodeId;
    protected boolean showPage = false;
    private int[] widthHints = new int[2];
    private Control treeViewer;
    private Control pageContainer;
    private Composite container;
    private ListenerList pageChangedListeners = new ListenerList();

    public AbstractPropertyDialog(Shell parentShell, Object model) {
        super(parentShell, "");
        this.setModel(model);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.propertyPaneLayout = new StackLayout();
        this.rootNode = new PropertyNode("org.eclipse.birt.report.designer.ui.dialogs.properties.propertydialog.rootnode");
    }

    public void setModel(Object model) {
        this.modelObject = model;
    }

    public final Object getModel() {
        return this.modelObject;
    }

    public final void addNodeTo(String path, PropertyNode node) {
        node.setContainer(this);
        if (path == null || path.trim().equals("/")) {
            this.rootNode.add(node);
        } else {
            PropertyNode parentNode = this.getNode(path);
            if (parentNode != null) {
                parentNode.add(node);
            }
        }
    }

    public final void addPageTo(String path, String nodeId, String nodeLabel, Image nodeImage, IPropertyPage page) {
        PropertyNode node = new PropertyNode(nodeId, nodeLabel, nodeImage, page);
        this.addNodeTo(path, node);
    }

    private final PropertyNode getNode(String path) {
        PropertyNode currentNode = null;
        if (path != null) {
            path = path.trim();
            currentNode = this.rootNode;
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                if ((currentNode = currentNode.getSubNode(tokenizer.nextToken())) != null) continue;
                return null;
            }
        }
        return currentNode;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.container = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(1808));
        this.treeViewer = this.createTreeViewer(this.container);
        this.treeViewer.setLayoutData((Object)new GridData(1040));
        Sash sash = this.createSash(this.container);
        this.pageContainer = this.createPropertyPane(this.container);
        this.pageContainer.setLayoutData((Object)new GridData(1808));
        this.addDragListerner(sash, this.container, this.treeViewer, this.pageContainer);
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(768));
        this.initTreeSelection();
        return composite;
    }

    public boolean close() {
        IDialogSettings setting = this.getDialogBoundsSettings();
        if (setting != null) {
            setting.put(SASHFORM_LEFT, this.widthHints[0]);
            setting.put(SASHFORM_RIGHT, this.widthHints[1]);
        }
        return super.close();
    }

    protected void initializeBounds() {
        try {
            IDialogSettings setting = this.getDialogBoundsSettings();
            if (setting != null) {
                this.widthHints[0] = setting.getInt(SASHFORM_LEFT);
                this.widthHints[1] = setting.getInt(SASHFORM_RIGHT);
            } else {
                int total = this.getDefaultSize().x;
                this.widthHints[0] = (int)((double)total * 0.2);
                this.widthHints[1] = (int)((double)total * 0.8);
            }
        }
        catch (NumberFormatException numberFormatException) {
            int total = this.getDefaultSize().x;
            this.widthHints[0] = (int)((double)total * 0.2);
            this.widthHints[1] = (int)((double)total * 0.8);
        }
        GridData data = (GridData)this.treeViewer.getLayoutData();
        data.widthHint = this.widthHints[0];
        data = (GridData)this.pageContainer.getLayoutData();
        data.widthHint = this.widthHints[1];
        this.container.layout(true);
        super.initializeBounds();
    }

    private void addDragListerner(Sash sash, final Composite parent, final Control left, final Control right) {
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 1) {
                    return;
                }
                Sash sash = (Sash)event.widget;
                int shift = event.x - sash.getBounds().x;
                GridData data = (GridData)left.getLayoutData();
                int newWidthHint = data.widthHint + shift;
                if (newWidthHint < 100) {
                    newWidthHint = 100;
                    shift = 100 - data.widthHint;
                }
                ((AbstractPropertyDialog)AbstractPropertyDialog.this).widthHints[0] = data.widthHint = newWidthHint;
                data = (GridData)right.getLayoutData();
                ((AbstractPropertyDialog)AbstractPropertyDialog.this).widthHints[1] = data.widthHint = (newWidthHint = data.widthHint - shift);
                parent.layout();
            }
        });
    }

    private void initTreeSelection() {
        PropertyNode node = this.getNode(this.getDeafultNode());
        if (node != null) {
            StructuredSelection select = new StructuredSelection((Object)node);
            this.viewer.setSelection((ISelection)select);
        } else if (this.viewer.getTree().getItems().length > 0) {
            TreeItem firstNode = this.viewer.getTree().getItems()[0];
            StructuredSelection select = new StructuredSelection(firstNode.getData());
            this.viewer.setSelection((ISelection)select);
        }
    }

    private final Control createTreeViewer(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                final PropertyNode selectedNode = (PropertyNode)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedNode == null) {
                    return;
                }
                if (AbstractPropertyDialog.this.processSelection) {
                    BusyIndicator.showWhile((Display)AbstractPropertyDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            AbstractPropertyDialog.this.showSelectionPage(selectedNode);
                        }
                    });
                }
                AbstractPropertyDialog.this.processSelection = true;
            }
        });
        this.viewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == AbstractPropertyDialog.this.viewer.getTree()) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = AbstractPropertyDialog.this.viewer.getTree().getItem(pt);
                    if (item == null) {
                        AbstractPropertyDialog.this.viewer.getTree().setToolTipText("");
                    } else {
                        String text = null;
                        if (item.getData() instanceof PropertyNode) {
                            text = ((PropertyNode)item.getData()).getPage().getToolTip();
                        }
                        AbstractPropertyDialog.this.viewer.getTree().setToolTipText(text);
                    }
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        this.viewer.setInput((Object)this.rootNode);
        return this.viewer.getTree();
    }

    public void showSelectionPage(PropertyNode selectedNode) {
        if (selectedNode == null) {
            return;
        }
        this.showPage = this.showPage(selectedNode);
        if (!this.showPage) {
            this.processSelection = false;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.currentNode));
        }
    }

    private final Composite createPropertyPane(Composite parent) {
        Composite propertyContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        propertyContainer.setLayout((Layout)layout);
        Composite titleComposite = new Composite(propertyContainer, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        GridData titleLayoutData = new GridData(768);
        titleLayoutData.horizontalIndent = 7;
        titleComposite.setLayoutData((Object)titleLayoutData);
        if (this.isTitleVisible()) {
            this.createTitleArea(titleComposite);
            Label separator = new Label(propertyContainer, 258);
            separator.setLayoutData((Object)new GridData(768));
        }
        GridData data = new GridData(1808);
        this.propertyPane = new Composite(propertyContainer, 0);
        this.propertyPane.setLayout((Layout)this.propertyPaneLayout);
        this.propertyPane.setLayoutData((Object)data);
        return propertyContainer;
    }

    public Composite createTitleArea(Composite parent) {
        Composite messageComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        messageComposite.setLayoutData((Object)data);
        FormLayout messageLayout = new FormLayout();
        messageComposite.setLayout((Layout)messageLayout);
        this.messageArea = new DialogMessageArea();
        this.messageArea.createContents(messageComposite);
        this.titleImage = new Label(messageComposite, 16384);
        FormData imageData = new FormData();
        imageData.right = new FormAttachment(100);
        imageData.top = new FormAttachment(0);
        imageData.bottom = new FormAttachment(100);
        this.titleImage.setLayoutData((Object)imageData);
        FormData messageData = new FormData();
        messageData.left = new FormAttachment(0, 0);
        messageData.right = new FormAttachment((Control)this.titleImage, 100);
        messageData.bottom = new FormAttachment((Control)this.titleImage, 0, 1024);
        messageData.top = new FormAttachment(0, 0);
        this.messageArea.setTitleLayoutData((Object)messageData);
        this.messageArea.setMessageLayoutData((Object)messageData);
        return messageComposite;
    }

    private final boolean showPage(PropertyNode node) {
        if (!(this.currentNode == null || node != this.currentNode && this.currentNode.getPage().canLeave())) {
            return false;
        }
        if (!node.isPageControlCreated()) {
            Control control = node.createPageControl(this.propertyPane);
            if (node.getId() != null && node.getId().equals(this.nodeId)) {
                control.setFocus();
            }
            assert (control != null) : "Control has not been created for node " + node.getId();
        }
        this.currentNode = node;
        this.propertyPaneLayout.topControl = node.getPageControl();
        node.getPage().pageActivated();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)node));
        this.propertyPane.layout();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)new DialogPageAdapter(this.currentNode)));
        return true;
    }

    protected Composite getPropertyPane() {
        return this.propertyPane;
    }

    protected final void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
                break;
            }
            case 17: {
                this.performHelp();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    public abstract boolean performOk();

    public abstract boolean performCancel();

    private final void performHelp() {
        if (this.currentNode != null) {
            this.currentNode.getPageControl().notifyListeners(28, new Event());
        }
    }

    protected final void cancelPressed() {
        if (this.rootNode.hasSubNodes()) {
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            int n = 0;
            while (n < nodes.length) {
                if (!this.cancelPressed(nodes[n])) {
                    return;
                }
                ++n;
            }
        }
        if (this.performCancel()) {
            super.cancelPressed();
        }
    }

    private final boolean cancelPressed(PropertyNode node) {
        if (node.getPage().performCancel()) {
            if (node.hasSubNodes()) {
                PropertyNode[] nodes = node.getSubNodes();
                int n = 0;
                while (n < nodes.length) {
                    if (!this.cancelPressed(nodes[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    protected void okPressed() {
        if (this.currentNode != null && !this.okPressed(this.currentNode)) {
            return;
        }
        if (this.rootNode.hasSubNodes()) {
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            int n = 0;
            while (n < nodes.length) {
                if (nodes[n] != this.currentNode && !this.okPressed(nodes[n])) {
                    return;
                }
                ++n;
            }
        }
        if (this.performOk()) {
            super.okPressed();
        }
    }

    private final boolean okPressed(PropertyNode node) {
        if (node.getPage().performOk()) {
            if (node.hasSubNodes()) {
                PropertyNode[] nodes = node.getSubNodes();
                int n = 0;
                while (n < nodes.length) {
                    if (!this.okPressed(nodes[n])) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected Point getDefaultSize() {
        return new Point(800, 500);
    }

    protected boolean isTitleVisible() {
        return true;
    }

    public final void setMessage(String message, int messageType) {
        if (this.messageArea != null) {
            if (messageType != 0) {
                this.titleImage.setVisible(false);
            } else {
                this.titleImage.setVisible(true);
            }
            if (message == null && messageType == 3) {
                this.messageArea.updateText("", messageType);
            } else {
                this.messageArea.updateText(message, messageType);
            }
        }
    }

    public final void setMessage(String message) {
        this.setMessage(message, 0);
    }

    protected void setDefaultNode(String attribute) {
        this.nodeId = attribute;
    }

    protected String getDeafultNode() {
        return this.nodeId;
    }

    protected PropertyNode getCurrentNode() {
        return this.currentNode;
    }

    private Sash createSash(Composite composite) {
        Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)new GridData(1040));
        return sash;
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public Object getSelectedPage() {
        return this.currentNode != null ? this.currentNode.getPage() : null;
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    protected void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }

    static class DialogPageAdapter
    extends DialogPage {
        private PropertyNode node;

        DialogPageAdapter(PropertyNode node) {
            this.node = node;
        }

        public Control getControl() {
            return this.node.getPageControl();
        }

        public void createControl(Composite parent) {
        }
    }
}

