/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class ExpressionUtility {
    private static final String STRING_ROW = "row";
    private static final String STRING_DATASET_ROW = "dataSetRow";
    private static final int EXPR_CACHE_SIZE = 20;
    private static Map compiledExprCacheInRowMode = Collections.synchronizedMap(new LinkedHashMap(20, 0.75f, true){
        private static final long serialVersionUID = 54331232145454L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 20;
        }
    });
    private static Map compiledExprCacheInDataSetRowMode = Collections.synchronizedMap(new LinkedHashMap(20, 0.75f, true){
        private static final long serialVersionUID = 54331232145454L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 20;
        }
    });

    public static boolean isColumnExpression(String expression, boolean mode) {
        ScriptOrFnNode tree;
        boolean isColumn = false;
        if (expression == null || expression.trim().length() == 0) {
            return isColumn;
        }
        if (ExpressionUtility.getCompiledExpCacheMap(mode).containsKey(expression)) {
            return (Boolean)ExpressionUtility.getCompiledExpCacheMap(mode).get(expression);
        }
        Context context = Context.enter();
        try {
            try {
                CompilerEnvirons m_compilerEnv = new CompilerEnvirons();
                m_compilerEnv.initFromContext(context);
                Parser p = new Parser(m_compilerEnv, context.getErrorReporter());
                tree = p.parse(expression, null, 0);
            }
            catch (Exception exception) {
                ExpressionUtility.getCompiledExpCacheMap(mode).put(expression, false);
                Context.exit();
                return false;
            }
        }
        finally {
            Context.exit();
        }
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() != 133 && tree.getFirstChild().getType() != 132 && tree.getFirstChild().getType() != 128) {
                isColumn = false;
            }
            Node exprNode = tree.getFirstChild();
            Node child = exprNode.getFirstChild();
            assert (child != null);
            isColumn = child.getType() == 36 || child.getType() == 33 ? ExpressionUtility.getDirectColRefExpr(child, mode) : false;
        } else {
            isColumn = false;
        }
        ExpressionUtility.getCompiledExpCacheMap(mode).put(expression, isColumn);
        return isColumn;
    }

    private static Map getCompiledExpCacheMap(boolean mode) {
        return mode ? compiledExprCacheInRowMode : compiledExprCacheInDataSetRowMode;
    }

    public static String getReplacedColRefExpr(String columnStr) {
        if (ExpressionUtility.isColumnExpression(columnStr, true)) {
            return columnStr.replaceFirst("\\Qrow\\E", STRING_DATASET_ROW);
        }
        return columnStr;
    }

    private static boolean getDirectColRefExpr(Node refNode, boolean mode) {
        assert (refNode.getType() == 33 || refNode.getType() == 36);
        Node rowName = refNode.getFirstChild();
        assert (rowName != null);
        if (rowName.getType() != 39) {
            return false;
        }
        String str = rowName.getString();
        assert (str != null);
        if (mode && !str.equals(STRING_ROW)) {
            return false;
        }
        if (!mode && !str.equals(STRING_DATASET_ROW)) {
            return false;
        }
        Node rowColumn = rowName.getNext();
        assert (rowColumn != null);
        if (refNode.getType() == 33 && rowColumn.getType() == 41) {
            return true;
        }
        return refNode.getType() == 36 && (rowColumn.getType() == 40 || rowColumn.getType() == 41);
    }
}

