/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.BaseInsertHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.Request;

public class InsertExpressionHandler
extends BaseInsertHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        super.execute(event);
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Insert expression menu action >> Run ...");
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        if (this.slotHandle != null) {
            expressionBuilder.setExpressionProvier(new ExpressionProvider(this.slotHandle.getElementHandle()));
        }
        if (expressionBuilder.open() == 0) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(STACK_MSG_INSERT_ELEMENT);
            try {
                Request req = this.insertElement();
                Object obj = req.getExtendedData().get("result");
                if (obj instanceof DataItemHandle) {
                    ((DataItemHandle)obj).setResultSetColumn(expressionBuilder.getResult());
                }
                stack.commit();
                this.selectElement(obj, false);
            }
            catch (Exception e) {
                stack.rollbackAll();
                ExceptionHandler.handle(e);
            }
        }
        return Boolean.FALSE;
    }
}

