/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BorderUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.LineBorder;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class CellBorder
extends LineBorder {
    public static final int FROM_ROW = 0;
    public static final int FROM_CELL = 1;
    private static final Insets DEFAULT_CROP = new Insets(2, 2, 2, 2);
    private static final Insets DEFAULTINSETS = new Insets(3, 3, 2, 2);
    private Insets paddingInsets = new Insets(DEFAULTINSETS);
    private Insets borderInsets;
    private int bottomFrom = 1;
    private int topFrom = 1;

    public Insets getInsets(IFigure figure) {
        if (this.borderInsets != null) {
            return new Insets(this.borderInsets).add(this.paddingInsets);
        }
        return new Insets(this.paddingInsets);
    }

    public Insets getBorderInsets() {
        if (this.borderInsets != null) {
            return new Insets(this.borderInsets);
        }
        return Figure.NO_INSETS;
    }

    public void setBorderInsets(Insets borderInsets) {
        this.borderInsets = borderInsets;
    }

    public void setPaddingInsets(Insets in) {
        if (in == null || in.left == 0 && in.right == 0 && in.top == 0 && in.bottom == 0) {
            this.paddingInsets = new Insets(DEFAULTINSETS);
            return;
        }
        this.paddingInsets.top = in.top > CellBorder.DEFAULTINSETS.top ? in.top : CellBorder.DEFAULTINSETS.top;
        this.paddingInsets.bottom = in.bottom > CellBorder.DEFAULTINSETS.bottom ? in.bottom : CellBorder.DEFAULTINSETS.bottom;
        this.paddingInsets.left = in.left > CellBorder.DEFAULTINSETS.left ? in.left : CellBorder.DEFAULTINSETS.left;
        this.paddingInsets.right = in.right > CellBorder.DEFAULTINSETS.right ? in.right : CellBorder.DEFAULTINSETS.right;
    }

    protected void drawBorder(IFigure figure, Graphics g, int side, int style, int[] width, String color, Insets insets) {
        Rectangle r = figure.getBounds().getCopy().crop(DEFAULT_CROP).crop(insets);
        if (style != 0) {
            g.setForegroundColor(ColorManager.getColor((int)ColorUtil.parseColor((String)color)));
            BorderUtil.drawBorderLine(g, side, style, width, r);
        } else {
            g.setForegroundColor(ReportColorConstants.ShadowLineColor);
            BorderUtil.drawDefaultLine(g, side, r);
        }
        g.restoreState();
    }

    public int getBottomFrom() {
        return this.bottomFrom;
    }

    public void setBottomFrom(int bottomFrom) {
        this.bottomFrom = bottomFrom;
    }

    public int getTopFrom() {
        return this.topFrom;
    }

    public void setTopFrom(int topFrom) {
        this.topFrom = topFrom;
    }
}

