/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.ColumnDragHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.ColumnHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.TableHFHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.handles.MoveHandleLocator;

public class TableColumnHandle
extends TableHFHandle {
    public TableColumnHandle(TableEditPart owner) {
        super(owner, (Locator)new TableColumnHandleLocator(owner));
    }

    protected void initChildrenHandle() {
        TableEditPart part = this.getTableEditPart();
        int count = part.getColumnCount();
        int width = 0;
        int i = 1;
        while (i < count + 1) {
            ColumnHandle handle = new ColumnHandle(part, i);
            handle.setPreferredSize(this.getColumnWidth(i), this.getBounds().height);
            handle.setBounds(new Rectangle(width, this.getBounds().y, this.getColumnWidth(i), this.getBounds().height));
            width += this.getColumnWidth(i);
            this.add((IFigure)handle);
            if (i == count) {
                width -= 2;
            }
            ColumnDragHandle dragHandle = new ColumnDragHandle(part, i, i == count ? i : i + 1);
            dragHandle.setBounds(new Rectangle(width, this.getBounds().y, 2, this.getBounds().height));
            this.add((IFigure)dragHandle);
            ++i;
        }
    }

    private static class TableColumnHandleLocator
    extends MoveHandleLocator {
        private TableEditPart owner;

        public TableColumnHandleLocator(TableEditPart part) {
            super(part.getFigure());
            this.setOwner(part);
        }

        public void relocate(IFigure target) {
            Rectangle bounds = this.getReference() instanceof HandleBounds ? ((HandleBounds)this.getReference()).getHandleBounds() : this.getReference().getBounds();
            Insets referenceInsets = this.getReference().getInsets();
            bounds = new PrecisionRectangle(new Rectangle(bounds.x + referenceInsets.left, bounds.y + referenceInsets.top - 19, bounds.width - 1 - (referenceInsets.left + referenceInsets.right), 19));
            this.getReference().translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            target.setBounds(bounds);
            this.relocateChildren(target, this.getReference());
        }

        private void relocateChildren(IFigure parent, IFigure reference) {
            List children = parent.getChildren();
            int size = children.size();
            int width = 0;
            Dimension pDim = parent.getSize();
            int height = pDim.height;
            int y = parent.getBounds().y;
            int i = 0;
            while (i < size) {
                IFigure f = (IFigure)children.get(i);
                Rectangle bounds = f.getBounds().getCopy();
                bounds = new PrecisionRectangle(bounds);
                PrecisionDimension dim = new PrecisionDimension(bounds.getSize());
                if (f instanceof ColumnDragHandle) {
                    dim = new PrecisionDimension(2.0, (double)bounds.height);
                } else if (f instanceof ColumnHandle) {
                    Object column = this.getOwner().getColumn(((ColumnHandle)f).getColumnNumber());
                    dim = new PrecisionDimension((double)TableUtil.caleVisualWidth(this.getOwner(), column), (double)bounds.height);
                }
                reference.translateToAbsolute((Translatable)dim);
                f.translateToRelative((Translatable)dim);
                if (i == 0) {
                    width = bounds.x;
                }
                bounds.width = dim.width;
                bounds.height = height;
                bounds.y = y;
                bounds.x = width;
                if (!(f instanceof ColumnDragHandle)) {
                    width += dim.width;
                }
                if (i == size - 1 && f instanceof ColumnDragHandle) {
                    bounds.x -= dim.width;
                }
                f.setBounds(bounds);
                ++i;
            }
        }

        public TableEditPart getOwner() {
            return this.owner;
        }

        public void setOwner(TableEditPart owner) {
            this.owner = owner;
        }
    }
}

