/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.pdf;

import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.OptionValue;
import org.eclipse.birt.report.engine.emitter.config.pdf.i18n.Messages;

public class PDFEmitterDescriptor
extends AbstractEmitterDescriptor {
    private static final String FONT_SUBSTITUTION = "FontSubstitution";
    private static final String BIDI_PROCESSING = "BIDIProcessing";
    private static final String TEXT_WRAPPING = "TextWrapping";
    private static final String TEXT_HYPHENATION = "TextHyphenation";
    private static final String EMBEDDED_FONT = "EmbeddedFont";
    private static final String CHART_DPI = "ChartDpi";
    private static final String RENDER_CHART_IN_SVG = "RenderChartInSVG";

    protected void initOptions() {
        this.loadDefaultValues("org.eclipse.birt.report.engine.emitter.config.pdf");
        ConfigurableOption bidiProcessing = new ConfigurableOption(BIDI_PROCESSING);
        bidiProcessing.setDisplayName(this.getMessage("OptionDisplayValue.BidiProcessing"));
        bidiProcessing.setDataType(IConfigurableOption.DataType.BOOLEAN);
        bidiProcessing.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        bidiProcessing.setDefaultValue((Object)Boolean.TRUE);
        bidiProcessing.setToolTip(null);
        bidiProcessing.setDescription(this.getMessage("OptionDescription.BidiProcessing"));
        ConfigurableOption textHyphenation = new ConfigurableOption(TEXT_HYPHENATION);
        textHyphenation.setDisplayName(this.getMessage("OptionDisplayValue.TextHyphenation"));
        textHyphenation.setDataType(IConfigurableOption.DataType.BOOLEAN);
        textHyphenation.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        textHyphenation.setDefaultValue((Object)Boolean.FALSE);
        textHyphenation.setToolTip(null);
        textHyphenation.setDescription(this.getMessage("OptionDescription.TextHyphenation"));
        ConfigurableOption textWrapping = new ConfigurableOption(TEXT_WRAPPING);
        textWrapping.setDisplayName(this.getMessage("OptionDisplayValue.TextWrapping"));
        textWrapping.setDataType(IConfigurableOption.DataType.BOOLEAN);
        textWrapping.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        textWrapping.setDefaultValue((Object)Boolean.TRUE);
        textWrapping.setToolTip(null);
        textWrapping.setDescription(this.getMessage("OptionDescription.TextWrapping"));
        ConfigurableOption fontSubstitution = new ConfigurableOption(FONT_SUBSTITUTION);
        fontSubstitution.setDisplayName(this.getMessage("OptionDisplayValue.FontSubstitution"));
        fontSubstitution.setDataType(IConfigurableOption.DataType.BOOLEAN);
        fontSubstitution.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        fontSubstitution.setDefaultValue((Object)Boolean.TRUE);
        fontSubstitution.setToolTip(null);
        fontSubstitution.setDescription(this.getMessage("OptionDescription.FontSubstitution"));
        ConfigurableOption pageOverFlow = new ConfigurableOption("pdfRenderOption.pageOverflow");
        pageOverFlow.setDisplayName(this.getMessage("OptionDisplayValue.PageOverFlow"));
        pageOverFlow.setDataType(IConfigurableOption.DataType.INTEGER);
        pageOverFlow.setDisplayType(IConfigurableOption.DisplayType.COMBO);
        pageOverFlow.setChoices((IOptionValue[])new OptionValue[]{new OptionValue((Object)1, this.getMessage("OptionDisplayValue.CLIP_CONTENT")), new OptionValue((Object)2, this.getMessage("OptionDisplayValue.FIT_TO_PAGE_SIZE")), new OptionValue((Object)4, this.getMessage("OptionDisplayValue.OUTPUT_TO_MULTIPLE_PAGES")), new OptionValue((Object)8, this.getMessage("OptionDisplayValue.ENLARGE_PAGE_SIZE"))});
        pageOverFlow.setDefaultValue((Object)4);
        pageOverFlow.setToolTip(null);
        pageOverFlow.setDescription(this.getMessage("OptionDescription.PageOverFlow"));
        ConfigurableOption embeddedFont = new ConfigurableOption(EMBEDDED_FONT);
        embeddedFont.setDisplayName(this.getMessage("OptionDisplayValue.EmbeddedFont"));
        embeddedFont.setDataType(IConfigurableOption.DataType.BOOLEAN);
        embeddedFont.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        embeddedFont.setDefaultValue((Object)Boolean.TRUE);
        embeddedFont.setToolTip(null);
        embeddedFont.setDescription(this.getMessage("OptionDescription.EmbeddedFont"));
        ConfigurableOption chartDpi = new ConfigurableOption(CHART_DPI);
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue((Object)new Integer(192));
        chartDpi.setToolTip(this.getMessage("Tooltip.ChartDpi"));
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        ConfigurableOption renderChartInSVG = new ConfigurableOption(RENDER_CHART_IN_SVG);
        renderChartInSVG.setDisplayName(this.getMessage("OptionDisplayValue.RenderChartInSVG"));
        renderChartInSVG.setDataType(IConfigurableOption.DataType.BOOLEAN);
        renderChartInSVG.setDisplayType(IConfigurableOption.DisplayType.CHECKBOX);
        renderChartInSVG.setDefaultValue((Object)Boolean.TRUE);
        renderChartInSVG.setToolTip(null);
        renderChartInSVG.setDescription(this.getMessage("OptionDescription.RenderChartInSVG"));
        this.options = new IConfigurableOption[]{bidiProcessing, textWrapping, textHyphenation, fontSubstitution, pageOverFlow, embeddedFont, chartDpi, renderChartInSVG};
        this.applyDefaultValues();
    }

    private String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return new PDFOptionObserver();
    }

    public String getDescription() {
        return this.getMessage("PDFEmitter.Description");
    }

    public String getDisplayName() {
        return this.getMessage("PDFEmitter.DisplayName");
    }

    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.pdf";
    }

    public String getRenderOptionName(String name) {
        assert (name != null);
        if (TEXT_WRAPPING.equals(name)) {
            return "pdfRenderOption.textWrapping";
        }
        if (BIDI_PROCESSING.equals(name)) {
            return "pdfRenderOption.bidiProcessing";
        }
        if (TEXT_HYPHENATION.equals(name)) {
            return "pdfRenderOption.hyphenation";
        }
        if (FONT_SUBSTITUTION.equals(name)) {
            return "pdfRenderOption.fontSubstitution";
        }
        if (EMBEDDED_FONT.equals(name)) {
            return "pdfRenderOption.embeddedFonts";
        }
        if (CHART_DPI.equals(name)) {
            return CHART_DPI;
        }
        return name;
    }

    class PDFOptionObserver
    extends AbstractConfigurableOptionObserver {
        PDFOptionObserver() {
        }

        public IConfigurableOption[] getOptions() {
            return PDFEmitterDescriptor.this.options;
        }

        public IRenderOption getPreferredRenderOption() {
            PDFRenderOption renderOption = new PDFRenderOption();
            renderOption.setEmitterID(PDFEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("pdf");
            if (this.values != null && this.values.length > 0) {
                IOptionValue[] iOptionValueArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IOptionValue optionValue = iOptionValueArray[n2];
                    if (optionValue != null) {
                        if (optionValue.getName().equals(PDFEmitterDescriptor.RENDER_CHART_IN_SVG)) {
                            boolean renderChartInSVG = true;
                            Object value = optionValue.getValue();
                            if (value != null && value instanceof Boolean) {
                                renderChartInSVG = (Boolean)value;
                            }
                            if (renderChartInSVG) {
                                renderOption.setSupportedImageFormats("PNG;GIF;JPG;BMP;SWF;SVG");
                            } else {
                                renderOption.setSupportedImageFormats("PNG;GIF;JPG;BMP;SWF");
                            }
                        } else {
                            renderOption.setOption(PDFEmitterDescriptor.this.getRenderOptionName(optionValue.getName()), optionValue.getValue());
                        }
                    }
                    ++n2;
                }
            }
            return renderOption;
        }
    }
}

