/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.ods.BlankData;
import org.eclipse.birt.report.engine.emitter.ods.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.ods.Data;
import org.eclipse.birt.report.engine.emitter.ods.IOdsWriter;
import org.eclipse.birt.report.engine.emitter.ods.ImageData;
import org.eclipse.birt.report.engine.emitter.ods.OdsUtil;
import org.eclipse.birt.report.engine.emitter.ods.SheetData;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsContext;
import org.eclipse.birt.report.engine.odf.SpanInfo;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.AbstractOdfWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdsXmlWriter
extends AbstractOdfWriter
implements IOdsWriter {
    private HashMap<String, BookmarkDef> bookmarkList;
    private int sheetIndex = 1;
    protected static Logger logger = Logger.getLogger(OdsXmlWriter.class.getName());
    OdsContext context = null;

    public OdsXmlWriter(OutputStream out, OdsContext context) {
        this(out, "UTF-8", context);
    }

    public OdsXmlWriter(OutputStream out) {
        this(out, "UTF-8", null);
    }

    public OdsXmlWriter(OutputStream out, String encoding, OdsContext context) {
        this.context = context;
        this.writer = new XMLWriter();
        this.writer.setIndent(false);
        this.writer.open(out, encoding);
    }

    public OdsXmlWriter(OutputStream out, boolean isRTLSheet) {
        this.writer.open(out, "UTF-8");
    }

    public OdsXmlWriter(OutputStream out, OdsContext context, boolean isRTLSheet) {
        this(out, "UTF-8", context);
    }

    public OdsXmlWriter(OutputStream out, String encoding, OdsContext context, boolean isRTLSheet) {
        this.context = context;
        this.writer.open(out, encoding);
    }

    private String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r') {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    @Override
    public void startRow(StyleEntry rowStyle) {
        this.startTableRow(rowStyle);
    }

    @Override
    public void endRow() {
        this.endTableRow();
    }

    private void startCell(int cellIndex, int colspan, int rowspan, StyleEntry cellStyle, HyperlinkInfo hyperLink, BookmarkDef linkedBookmark) {
        SpanInfo spanInfo = new SpanInfo(cellIndex, colspan + 1, rowspan + 1, false, cellStyle);
        this.startTableCell(cellStyle, spanInfo);
    }

    @Override
    public void outputData(SheetData sheetData, StyleEntry style, int column, int colSpan) {
        int rowSpan = sheetData.getRowSpan();
        int type = sheetData.getDataType();
        if (type == 5 && sheetData instanceof ImageData) {
            this.outputImageData((ImageData)sheetData, style, column, colSpan);
        } else {
            BlankData blank;
            Data d = (Data)sheetData;
            if (d instanceof BlankData && (blank = (BlankData)d).getType() != BlankData.Type.NONE) {
                this.writer.openTag("table:covered-table-cell");
                if (style != null) {
                    this.writer.attribute("table:style-name", style.getName());
                }
                this.writer.closeTag("table:covered-table-cell");
                return;
            }
            Object value = d.getValue();
            HyperlinkInfo hyperLink = d.getHyperlinkDef();
            BookmarkDef linkedBookmark = d.getLinkedBookmark();
            this.outputData(type, value, style, column, colSpan, rowSpan, hyperLink, linkedBookmark);
        }
    }

    private void outputImageData(ImageData imageData, StyleEntry style, int column, int colSpan) {
        HyperlinkInfo hyperLink = imageData.getHyperlinkDef();
        BookmarkDef linkedBookmark = imageData.getLinkedBookmark();
        this.startCell(column, colSpan, imageData.getRowSpan(), style, hyperLink, linkedBookmark);
        this.openHyperlink(hyperLink, linkedBookmark);
        this.drawImage(imageData.getImageUrl(), null, null, null, imageData.getImageHeight() / 72.0f, imageData.getImageWidth() / 72.0f, style, imageData.getDescription(), null, this.getImageID());
        this.closeHyperlink(hyperLink);
        this.endCell();
    }

    @Override
    public void outputData(int col, int row, int type, Object value) {
        this.outputData(type, value, null, col, 0, 0, null, null);
    }

    private void outputData(int type, Object value, StyleEntry style, int column, int colSpan, int rowSpan, HyperlinkInfo hyperLink, BookmarkDef linkedBookmark) {
        this.startCell(column, colSpan, rowSpan, style, hyperLink, linkedBookmark);
        this.writer.attribute("office:value-type", "string");
        String txt = OdsUtil.format(value, type);
        this.writer.openTag("text:p");
        if (style != null) {
            this.writer.attribute("text:style-name", style.getName());
        }
        this.openHyperlink(hyperLink, linkedBookmark);
        if (txt.length() > 0) {
            if (style != null) {
                String textTransform = style.getStringProperty(26);
                if ("capitalize".equalsIgnoreCase(textTransform)) {
                    txt = this.capitalize(txt);
                } else if ("uppercase".equalsIgnoreCase(textTransform)) {
                    txt = txt.toUpperCase();
                } else if ("lowercase".equalsIgnoreCase(textTransform)) {
                    txt = txt.toLowerCase();
                }
            }
            this.writeString(txt);
        }
        this.closeHyperlink(hyperLink);
        this.writer.closeTag("text:p");
        this.endCell();
    }

    private void openHyperlink(HyperlinkInfo hyperLink, BookmarkDef linkedBookmark) {
        if (hyperLink != null) {
            this.writer.openTag("text:a");
            String urlAddress = hyperLink.getUrl();
            if (hyperLink.getType() == 2) {
                if (linkedBookmark != null) {
                    urlAddress = "#" + linkedBookmark.getValidName();
                } else {
                    logger.log(Level.WARNING, "The bookmark: {" + urlAddress + "} is not defined!");
                }
            }
            if (urlAddress != null && urlAddress.length() >= 255) {
                logger.log(Level.WARNING, "The URL: {" + urlAddress + "} is too long!");
                urlAddress = urlAddress.substring(0, 254);
            }
            this.writer.attribute("xlink:href", urlAddress);
            if (hyperLink.getTooltip() != null) {
                this.writer.attribute("xlink:title", hyperLink.getTooltip());
            }
        }
    }

    private void endCell() {
        this.endTableCell();
    }

    private void defineNames(Map.Entry<String, BookmarkDef> bookmarkEntry) {
        BookmarkDef bookmark = bookmarkEntry.getValue();
        String name = bookmark.getValidName();
        String refer = this.getRefer(bookmark.getSheetName(), bookmark);
        this.defineName(name, refer);
    }

    private String getRefer(String sheetName, BookmarkDef bookmark) {
        StringBuffer sb = new StringBuffer("$");
        sb.append(sheetName);
        sb.append(".$");
        sb.append(OdsUtil.getColumnName(bookmark.getColumnNo() - 1));
        sb.append("$");
        sb.append(bookmark.getRowNo());
        return sb.toString();
    }

    private void defineName(String name, String refer) {
        this.writer.openTag("table:named-range");
        this.writer.attribute("table:name", name);
        this.writer.attribute("table:base-cell-address", refer);
        this.writer.attribute("table:cell-range-address", refer);
        this.writer.closeTag("table:named-range");
    }

    @Override
    public void startSheet(String name) {
        this.startSheet(name, null, null);
    }

    public void startSheet(String name, StyleEntry tableStyle, StyleEntry[] colStyles) {
        this.startTable(name, tableStyle);
        this.writeColumn(colStyles);
    }

    public void closeSheet() {
        this.endTable();
    }

    @Override
    public void startSheet(StyleEntry tableStyle, StyleEntry[] colStyles, String name) {
        this.startSheet(name, tableStyle, colStyles);
        ++this.sheetIndex;
    }

    @Override
    public void endSheet() {
        this.closeSheet();
    }

    @Override
    public void start(IReportContent report, HashMap<String, BookmarkDef> bookmarkList) {
        this.bookmarkList = bookmarkList;
        this.writer.openTag("office:body");
        this.writer.openTag("office:spreadsheet");
    }

    private void outputBookmarks(HashMap<String, BookmarkDef> bookmarkList) {
        if (!bookmarkList.isEmpty()) {
            this.writer.openTag("table:named-expressions");
            Set<Map.Entry<String, BookmarkDef>> bookmarkEntry = bookmarkList.entrySet();
            for (Map.Entry<String, BookmarkDef> bookmark : bookmarkEntry) {
                this.defineNames(bookmark);
            }
            this.writer.closeTag("table:named-expressions");
        }
    }

    @Override
    public void end() {
        this.outputBookmarks(this.bookmarkList);
        this.writer.closeTag("office:spreadsheet");
        this.writer.closeTag("office:body");
        this.close();
    }

    public void close() {
        this.writer.endWriter();
        this.writer.close();
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    @Override
    public void startRow() {
        this.startRow(null);
    }

    @Override
    public String defineName(String cells) {
        return null;
    }

    public XMLWriter getWriter() {
        return this.writer;
    }
}

