/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.odt.EmitterContext;
import org.eclipse.birt.report.engine.emitter.odt.IOdtWriter;
import org.eclipse.birt.report.engine.emitter.odt.TocInfo;
import org.eclipse.birt.report.engine.emitter.odt.writer.BodyWriter;
import org.eclipse.birt.report.engine.emitter.odt.writer.MasterPageWriter;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.odf.AbstractOdfEmitter;
import org.eclipse.birt.report.engine.odf.AbstractOdfEmitterContext;
import org.eclipse.birt.report.engine.odf.DiagonalLineInfo;
import org.eclipse.birt.report.engine.odf.MasterPageManager;
import org.eclipse.birt.report.engine.odf.OdfUtil;
import org.eclipse.birt.report.engine.odf.SpanInfo;
import org.eclipse.birt.report.engine.odf.pkg.ImageEntry;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.util.FlashFile;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdtEmitter
extends AbstractOdfEmitter {
    public static final String MIME_TYPE = "application/vnd.oasis.opendocument.text";
    public static final int NORMAL = -1;
    public static final int MAX_COLUMN = 63;
    protected AbstractOdfEmitter emitterImplement = null;
    private int omitCellLayer = 0;
    private boolean isClipped = false;
    public EmitterContext context;
    protected static Logger logger = Logger.getLogger(OdtEmitter.class.getName());
    private static final String OUTPUT_FORMAT = "odt";
    private Stack<IStyle> inlineStyles = new Stack();
    protected IOdtWriter bodyWriter = null;
    private boolean inForeign = false;
    private boolean hasPInside = false;
    protected IPageContent previousPage = null;
    protected Stack<IStyle> styles = new Stack();
    public double pageWidth = 0.0;
    public double contentWidth = 0.0;
    public double leftMargin = 0.0;
    public double rightMargin = 0.0;
    private StyleEntry pageLayout = null;
    private HashSet<String> bookmarks = new HashSet();
    private boolean rowFilledFlag = false;
    private ArrayList<InstanceID> groupIdList = new ArrayList();
    private int tocLevel = 1;
    private List<TocInfo> tableTocs = new ArrayList<TocInfo>();
    private String messageFlashObjectNotSupported;
    private String layoutPreference = null;
    private boolean fixedLayout;
    private List<String> containerBookmarks = new ArrayList<String>(3);
    private MasterPageWriter masterPageWriter;
    private boolean pageBreakBefore = false;
    private String masterPage = null;

    public OdtEmitter() {
        this.tableCount = 0;
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT;
    }

    public void endContainer(IContainerContent container) {
        if (this.isClipped) {
            return;
        }
        boolean flag = this.hasForeignParent(container);
        if (flag) {
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.adjustInline();
            }
            if (!this.styles.isEmpty()) {
                this.styles.pop();
            }
            if (!this.inlineStyles.isEmpty()) {
                this.inlineStyles.pop();
            }
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                if (this.inForeign && this.hasPInside) {
                    this.context.addContainer(false);
                    this.hasPInside = false;
                } else if (!this.inForeign) {
                    this.context.addContainer(true);
                }
                this.context.setLastIsTable(true);
            }
        }
    }

    public void startContainer(IContainerContent container) {
        if (this.isClipped) {
            return;
        }
        boolean flag = this.hasForeignParent(container);
        if (flag) {
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.adjustInline();
            }
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.styles.push(container.getComputedStyle());
            } else {
                this.inlineStyles.push(container.getComputedStyle());
            }
        }
    }

    private boolean hasForeignParent(IContainerContent container) {
        IContainerContent con = container;
        while (con != null) {
            if (con.getParent() instanceof IForeignContent) {
                return true;
            }
            con = (IContainerContent)con.getParent();
        }
        return false;
    }

    public void endTable(ITableContent table) {
        if (this.isClipped) {
            return;
        }
        this.hasPInside = false;
        this.endTable();
        this.decreaseTOCLevel((IContent)table);
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        if (this.isClipped) {
            return;
        }
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            boolean inlineBrother;
            this.inForeign = true;
            boolean bl = inlineBrother = !this.context.isFirstInline();
            if (!"inline".equalsIgnoreCase(foreign.getComputedStyle().getDisplay())) {
                this.adjustInline();
                inlineBrother = false;
            } else {
                this.context.endInline();
            }
            HTML2Content.html2Content((IForeignContent)foreign);
            this.context.startCell();
            ++this.tableCount;
            StyleEntry foreignStyle = StyleBuilder.createStyleEntry((IStyle)foreign.getComputedStyle(), (int)2);
            foreignStyle.setProperty(35, (Object)this.context.getCurrentWidth());
            StyleEntry cellStyle = StyleBuilder.createStyleEntry((IStyle)foreign.getComputedStyle(), (int)5);
            cellStyle.setProperty(35, (Object)this.context.getCurrentWidth());
            this.context.addStyle(this.getTableStylePrefix(), foreignStyle);
            this.context.addStyle(this.getTableStylePrefix(), cellStyle);
            this.bodyWriter.startTable(null, foreignStyle);
            this.bodyWriter.writeColumn(new StyleEntry[1]);
            this.bodyWriter.startTableRow(null);
            this.bodyWriter.startTableCell(cellStyle, null);
            this.writeToc((IContent)foreign);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.adjustInline();
            this.bodyWriter.endTableCell();
            this.context.endCell();
            this.bodyWriter.endTableRow();
            this.bodyWriter.endTable();
            this.context.setLastIsTable(true);
            this.context.addContainer(true);
            this.hasPInside = false;
            if (inlineBrother) {
                this.context.startInline();
            }
            this.inForeign = false;
        } else {
            Object rawValue = foreign.getRawValue();
            String text = rawValue == null ? "" : rawValue.toString();
            this.writeContent(-1, text, (IContent)foreign);
        }
    }

    protected void writeContent(int type, String txt, IContent content) {
        if (this.inForeign) {
            this.hasPInside = true;
        }
        this.context.addContainer(false);
        InlineFlag inlineFlag = InlineFlag.BLOCK;
        IStyle computedStyle = content.getComputedStyle();
        IStyle inlineStyle = null;
        if ("inline".equalsIgnoreCase(content.getComputedStyle().getDisplay())) {
            if (this.context.isFirstInline()) {
                this.context.startInline();
                inlineFlag = InlineFlag.FIRST_INLINE;
                if (!this.styles.isEmpty()) {
                    computedStyle = this.styles.peek();
                }
            } else {
                inlineFlag = InlineFlag.MIDDLE_INLINE;
            }
            if (!this.inlineStyles.isEmpty()) {
                inlineStyle = this.mergeStyles(this.inlineStyles);
            }
        } else {
            this.adjustInline();
        }
        StyleEntry computedStyleEntry = StyleBuilder.createStyleEntry((IStyle)computedStyle, (int)0);
        StyleEntry inlineStyleEntry = null;
        inlineStyleEntry = inlineStyle != null ? StyleBuilder.createStyleEntry(inlineStyle, (int)1) : StyleBuilder.createStyleEntry((IStyle)computedStyle, (int)1);
        this.processBackgroundImageStyle(computedStyleEntry);
        this.context.addStyle(computedStyleEntry);
        this.context.addStyle(inlineStyleEntry);
        if (this.pageBreakBefore || this.masterPage != null) {
            computedStyleEntry = (StyleEntry)computedStyleEntry.clone();
            this.processMasterPage(computedStyleEntry);
            this.context.addStyle(computedStyleEntry);
        }
        this.writeText(type, txt, content, inlineFlag, computedStyleEntry, inlineStyleEntry);
        this.context.setLastIsTable(false);
    }

    private IStyle mergeStyles(Stack<IStyle> inlineStyles) {
        IStyle style = inlineStyles.peek();
        int i = 0;
        while (i < 59) {
            if (this.isNullValue(style.getProperty(i))) {
                style.setProperty(i, null);
                int p = inlineStyles.size() - 1;
                while (p >= 0) {
                    IStyle pstyle = (IStyle)inlineStyles.get(p);
                    if (!this.isNullValue(pstyle.getProperty(i))) {
                        style.setProperty(i, pstyle.getProperty(i));
                        break;
                    }
                    --p;
                }
            }
            ++i;
        }
        return style;
    }

    public void initialize(IEmitterServices service) throws EngineException {
        super.initialize(service);
        if (service != null) {
            EngineResourceHandle resourceHandle = new EngineResourceHandle(this.context.getLocale());
            this.messageFlashObjectNotSupported = resourceHandle.getMessage("Error.FlashObjectNotSupported");
            IRenderOption renderOption = service.getRenderOption();
            if (renderOption != null) {
                HTMLRenderOption htmlOption = new HTMLRenderOption(renderOption);
                this.layoutPreference = htmlOption.getLayoutPreference();
            }
        }
        try {
            this.bodyWriter = new BodyWriter(this.bodyOut);
            this.masterPageWriter = new MasterPageWriter(this.masterPageOut);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected AbstractOdfEmitterContext createContext() {
        this.context = new EmitterContext();
        return this.context;
    }

    public void start(IReportContent report) throws BirtException {
        super.start(report);
        if (this.layoutPreference == null) {
            ReportDesignHandle designHandle = report.getDesign().getReportDesign();
            if (designHandle != null) {
                String reportLayoutPreference = designHandle.getLayoutPreference();
                if ("fixed layout".equals(reportLayoutPreference)) {
                    this.layoutPreference = "fixed";
                } else if ("auto layout".equals(reportLayoutPreference)) {
                    this.layoutPreference = "auto";
                }
            }
            this.fixedLayout = "fixed".equals(this.layoutPreference);
        }
        this.masterPageWriter.start(false);
    }

    public void startPage(IPageContent page) {
        MasterPageManager masterPageManager = this.context.getMasterPageManager();
        if (this.previousPage != null) {
            try {
                this.outputPrePageProperties(page);
                this.pageBreakBefore = true;
                this.masterPage = masterPageManager.getCurrentMasterPage();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
            catch (BirtException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
            this.previousPage = page;
            this.context.resetWidth();
        } else {
            this.previousPage = page;
            boolean isRtl = false;
            if (this.reportContent != null) {
                IContent rootContent = this.reportContent.getRoot();
                isRtl = rootContent != null && rootContent.isRTL();
            }
            try {
                this.writeMetaProperties(this.reportContent);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
            catch (BirtException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
            try {
                this.bodyWriter.start(isRtl);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
            SimpleMasterPageDesign master = (SimpleMasterPageDesign)page.getGenerateBy();
            masterPageManager.newPage(master.getName());
            this.masterPage = masterPageManager.getCurrentMasterPage();
        }
        this.processPageLayout(page);
        this.context.addWidth(this.contentWidth);
        this.bodyWriter.startPage();
    }

    private void outputPrePageProperties(IPageContent page) throws IOException, BirtException {
        this.adjustInline();
        this.writeHeaderFooter(page, false);
        this.bodyWriter.endPage();
    }

    public void end(IReportContent report) throws BirtException {
        this.adjustInline();
        try {
            this.writeHeaderFooter(null, true);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        this.bodyWriter.endPage();
        try {
            this.bodyWriter.end();
            this.masterPageWriter.end();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        super.end(report);
    }

    public void processPageLayout(IPageContent page) {
        int reportDpi = this.context.getReportDpi();
        this.pageWidth = OdfUtil.convertTo((DimensionType)page.getPageWidth(), (double)0.0, (int)reportDpi);
        this.leftMargin = OdfUtil.convertTo((DimensionType)page.getMarginLeft(), (double)0.0, (int)reportDpi);
        this.rightMargin = OdfUtil.convertTo((DimensionType)page.getMarginRight(), (double)0.0, (int)reportDpi);
        this.contentWidth = this.pageWidth - this.leftMargin - this.rightMargin;
        this.pageLayout = this.makePageLayoutStyle(page);
    }

    public void startAutoText(IAutoTextContent autoText) {
        if (this.isClipped) {
            return;
        }
        this.writeContent(autoText.getType(), autoText.getText(), (IContent)autoText);
    }

    public void startData(IDataContent data) {
        if (this.isClipped) {
            return;
        }
        this.writeContent(-1, data.getText(), (IContent)data);
    }

    public void startLabel(ILabelContent label) {
        if (this.isClipped) {
            return;
        }
        String txt = label.getText() == null ? label.getLabelText() : label.getText();
        txt = txt == null ? "" : txt;
        this.writeContent(-1, txt, (IContent)label);
    }

    public void startText(ITextContent text) {
        if (this.isClipped) {
            return;
        }
        this.writeContent(-1, text.getText(), (IContent)text);
    }

    public void startList(IListContent list) {
        if (this.isClipped) {
            return;
        }
        this.adjustInline();
        this.styles.push(list.getComputedStyle());
        this.addTableToc((IContent)list);
        this.increaseTOCLevel((IContent)list);
        double width = OdfUtil.convertTo((DimensionType)list.getWidth(), (double)this.context.getCurrentWidth(), (int)this.context.getReportDpi());
        width = Math.min(width, this.context.getCurrentWidth());
        StyleEntry tableStyle = StyleBuilder.createStyleEntry((IStyle)list.getComputedStyle(), (int)2);
        tableStyle.setProperty(35, (Object)width);
        this.processMasterPage(tableStyle);
        this.context.addStyle(tableStyle);
        this.bodyWriter.startTable(null, tableStyle);
        this.addContainerBookmark((IContent)list);
    }

    public void startListBand(IListBandContent listBand) {
        if (this.isClipped) {
            return;
        }
        this.context.startCell();
        this.bodyWriter.startTableRow(null);
        StyleEntry cellStyle = StyleBuilder.createStyleEntry((IStyle)this.computeStyle(listBand.getComputedStyle()), (int)5);
        cellStyle.setProperty(35, (Object)this.context.getCurrentWidth());
        this.context.addStyle(cellStyle);
        this.bodyWriter.startTableCell(cellStyle, null);
    }

    public void startListGroup(IListGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.setGroupToc((IGroupContent)group);
    }

    public void startRow(IRowContent row) {
        if (this.isClipped) {
            return;
        }
        if (!this.isHidden((IContent)row)) {
            this.rowFilledFlag = false;
            this.styles.push(row.getComputedStyle());
            StyleEntry rowStyle = this.context.getRowHeightStyle(row.getHeight());
            this.context.addStyle(this.getTableStylePrefix(), rowStyle);
            this.bodyWriter.startTableRow(rowStyle);
            this.addContainerBookmark((IContent)row);
            this.context.newRow();
        }
    }

    public void startContent(IContent content) {
        if (this.isClipped) {
            return;
        }
    }

    public void startGroup(IGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.setGroupToc(group);
    }

    public void startCell(ICellContent cell) {
        if (this.isClipped) {
            ++this.omitCellLayer;
            return;
        }
        int colCount = cell.getColumn();
        if (colCount >= 63) {
            ++this.omitCellLayer;
            this.isClipped = true;
            return;
        }
        this.rowFilledFlag = true;
        this.context.startCell();
        int columnId = cell.getColumn();
        double cellWidth = this.context.getCellWidth(columnId, cell.getColSpan());
        IStyle style = this.computeStyle(cell.getComputedStyle());
        StyleEntry cellStyle = StyleBuilder.createStyleEntry((IStyle)style, (int)5);
        cellStyle.setProperty(35, (Object)cellWidth);
        this.processBackgroundImageStyle(cellStyle);
        this.context.addStyle(this.getTableStylePrefix(), cellStyle);
        SpanInfo info = this.processSpan(cell, cellStyle);
        this.bodyWriter.startTableCell(cellStyle, info);
        this.addContainerBookmark((IContent)cell);
        this.context.addWidth(this.getCellWidth(cellWidth, style));
        if (cell.getDiagonalNumber() != 0 && cell.getDiagonalStyle() != null && !"none".equalsIgnoreCase(cell.getDiagonalStyle())) {
            this.drawDiagonalLine(cell, OdfUtil.twipToPt((double)cellWidth));
        }
    }

    private SpanInfo processSpan(ICellContent cell, StyleEntry cellStyle) {
        int columnId = cell.getColumn();
        List spans = this.context.getSpans(columnId);
        if (spans != null) {
            int i = 0;
            while (i < spans.size()) {
                this.bodyWriter.writeSpanCell((SpanInfo)spans.get(i));
                ++i;
            }
        }
        int columnSpan = cell.getColSpan();
        int rowSpan = cell.getRowSpan();
        if (rowSpan > 1) {
            this.context.addSpan(columnId, columnSpan, rowSpan, cellStyle);
        }
        SpanInfo info = null;
        if (columnSpan > 1 || rowSpan > 1) {
            info = new SpanInfo(columnId, columnSpan, rowSpan, true, cellStyle);
        }
        return info;
    }

    private void drawDiagonalLine(ICellContent cell, double cellWidth) {
        if (cellWidth == 0.0) {
            return;
        }
        int cellHeight = OdfUtil.convertTo((DimensionType)this.getCellHeight(cell), (int)0, (int)this.context.getReportDpi()) / 20;
        if (cellHeight == 0) {
            return;
        }
        DiagonalLineInfo diagonalLineInfo = new DiagonalLineInfo();
        int diagonalWidth = PropertyUtil.getDimensionValue((IContent)cell, (DimensionType)cell.getDiagonalWidth(), (int)((int)cellWidth)) / 1000;
        diagonalLineInfo.setDiagonalLine(cell.getDiagonalNumber(), cell.getDiagonalStyle(), diagonalWidth);
        diagonalLineInfo.setAntidiagonalLine(0, null, 0);
        diagonalLineInfo.setCoordinateSize(cellWidth, (double)cellHeight);
        String lineColor = null;
        lineColor = cell.getDiagonalColor() != null ? OdfUtil.parseColor((String)cell.getDiagonalColor()) : OdfUtil.parseColor((String)cell.getComputedStyle().getColor());
        diagonalLineInfo.setColor(lineColor);
        this.bodyWriter.drawDiagonalLine(diagonalLineInfo);
    }

    protected DimensionType getCellHeight(ICellContent cell) {
        IElement parent = cell.getParent();
        while (!(parent instanceof IRowContent)) {
            parent = parent.getParent();
        }
        return ((IRowContent)parent).getHeight();
    }

    public void startTable(ITableContent table) {
        if (this.isClipped) {
            return;
        }
        ++this.tableCount;
        this.adjustInline();
        this.styles.push(table.getComputedStyle());
        StyleEntry tableStyle = StyleBuilder.createStyleEntry((IStyle)table.getComputedStyle(), (int)2);
        this.processBackgroundImageStyle(tableStyle);
        this.context.addStyle(this.getTableStylePrefix(), tableStyle);
        this.addTableToc((IContent)table);
        this.increaseTOCLevel((IContent)table);
        String caption = table.getCaption();
        if (caption != null) {
            StyleEntry captionStyle = StyleBuilder.createEmptyStyleEntry((int)0);
            captionStyle.setProperty(8, (Object)"center");
            this.context.addStyle(captionStyle);
            this.processMasterPage(captionStyle);
            this.bodyWriter.writeCaption(caption, captionStyle);
        }
        double width = OdfUtil.convertTo((DimensionType)table.getWidth(), (double)this.context.getCurrentWidth(), (int)this.context.getReportDpi());
        width = Math.min(width, this.context.getCurrentWidth());
        double[] cols = this.computeTblColumnWidths(table, width);
        tableStyle.setProperty(35, (Object)this.getTableWidth(cols));
        this.processMasterPage(tableStyle);
        this.bodyWriter.startTable(null, tableStyle);
        this.addContainerBookmark((IContent)table);
        this.bodyWriter.writeColumn(this.getColStyles(cols));
        this.context.addTable(cols, table.getComputedStyle());
    }

    private void processMasterPage(StyleEntry style) {
        if (this.pageBreakBefore) {
            this.pageBreakBefore = false;
            style.setProperty(57, (Object)"page");
        }
        if (this.masterPage != null) {
            style.setProperty(58, (Object)this.masterPage);
            this.masterPage = null;
        }
    }

    private void addTableToc(IContent table) {
        Object tableToc = table.getTOC();
        if (tableToc != null) {
            this.tableTocs.add(new TocInfo(tableToc.toString(), this.tocLevel));
        }
    }

    private double getTableWidth(double[] cols) {
        double tableWidth = 0.0;
        int i = 0;
        while (i < cols.length) {
            tableWidth += cols[i];
            ++i;
        }
        return tableWidth;
    }

    public void startTableBand(ITableBandContent band) {
        if (this.isClipped) {
            return;
        }
        if (band.getBandType() == 1 && ((ITableContent)band.getParent()).isHeaderRepeat()) {
            this.bodyWriter.startTableHeader();
        }
    }

    public void startTableGroup(ITableGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.setGroupToc((IGroupContent)group);
    }

    private void setGroupToc(IGroupContent group) {
        if (group != null) {
            InstanceID groupId = group.getInstanceID();
            if (!this.groupIdList.contains(groupId)) {
                this.groupIdList.add(groupId);
                this.addTableToc((IContent)group);
            }
            this.increaseTOCLevel((IContent)group);
        }
    }

    public void endCell(ICellContent cell) {
        if (this.omitCellLayer != 0) {
            --this.omitCellLayer;
            if (this.omitCellLayer == 0) {
                this.isClipped = false;
            }
            return;
        }
        this.adjustInline();
        this.context.removeWidth();
        if (!this.containerBookmarks.isEmpty() || !this.tableTocs.isEmpty()) {
            this.bodyWriter.writeMarkersParagraph(this.containerBookmarks, this.tableTocs);
        }
        this.bodyWriter.endTableCell();
        this.context.endCell();
    }

    public void endContent(IContent content) {
    }

    public void endGroup(IGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.decreaseTOCLevel((IContent)group);
    }

    public void endList(IListContent list) {
        if (this.isClipped) {
            return;
        }
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.context.addContainer(true);
        this.bodyWriter.endTable();
        this.context.setLastIsTable(true);
        this.decreaseTOCLevel((IContent)list);
    }

    public void endListBand(IListBandContent listBand) {
        if (this.isClipped) {
            return;
        }
        this.adjustInline();
        this.bodyWriter.endTableCell();
        this.context.endCell();
        this.bodyWriter.endTableRow();
    }

    public void endListGroup(IListGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.decreaseTOCLevel((IContent)group);
    }

    public void endRow(IRowContent row) {
        if (this.isClipped) {
            return;
        }
        if (!this.isHidden((IContent)row)) {
            int col;
            List spans;
            if (!this.styles.isEmpty()) {
                this.styles.pop();
            }
            if ((spans = this.context.getSpans(col = this.context.getCurrentTableColmns().length - 1)) != null) {
                int spanSize = spans.size();
                if (spanSize > 0) {
                    this.rowFilledFlag = true;
                }
                int i = 0;
                while (i < spanSize) {
                    this.bodyWriter.writeSpanCell((SpanInfo)spans.get(i));
                    ++i;
                }
            }
            if (!this.rowFilledFlag) {
                this.bodyWriter.writeEmptyCell();
                this.rowFilledFlag = true;
            }
            this.bodyWriter.endTableRow();
        }
    }

    public void endTableBand(ITableBandContent band) {
        if (this.isClipped) {
            return;
        }
        if (band.getBandType() == 1 && ((ITableContent)band.getParent()).isHeaderRepeat()) {
            this.bodyWriter.endTableHeader();
        }
    }

    public void endTableGroup(ITableGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.decreaseTOCLevel((IContent)group);
    }

    public void endPage(IPageContent page) {
        if (this.isClipped) {
            return;
        }
    }

    public void startImage(IImageContent image) {
        if (this.isClipped) {
            return;
        }
        StyleEntry style = StyleBuilder.createStyleEntry((IStyle)image.getComputedStyle(), (int)7);
        this.context.addStyle(style);
        InlineFlag inlineFlag = this.getInlineFlag(style.getStyle());
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        String extension = image.getExtension();
        String altText = image.getAltText();
        double height = OdfUtil.convertImageSize((DimensionType)image.getHeight(), (int)0, (int)this.context.getReportDpi());
        int parentWidth = (int)(OdfUtil.twipToPt((double)this.context.getCurrentWidth()) * (double)this.context.getReportDpi() / 72.0);
        double width = OdfUtil.convertImageSize((DimensionType)image.getWidth(), (int)parentWidth, (int)this.context.getReportDpi());
        this.context.addContainer(false);
        String bookmark = this.getBookmark((IContent)image);
        TocInfo tocInfo = null;
        if (image.getTOC() != null) {
            tocInfo = new TocInfo(image.getTOC().toString(), this.tocLevel);
        }
        StyleEntry pStyle = null;
        if (this.pageBreakBefore || this.masterPage != null) {
            pStyle = StyleBuilder.createEmptyStyleEntry((int)0);
            this.processMasterPage(pStyle);
            this.context.addStyle(pStyle);
        }
        if (FlashFile.isFlash((String)mimeType, (String)uri, (String)extension)) {
            if (altText == null) {
                altText = this.messageFlashObjectNotSupported;
            }
            this.bodyWriter.drawImage(null, height, width, null, style, pStyle, inlineFlag, altText, bookmark, tocInfo);
            return;
        }
        try {
            float scale;
            int imageFileHeightDpi;
            ImageEntry entry = this.context.getImageManager().addImage(image);
            Image imageInfo = entry.getImage();
            byte[] data = imageInfo.getData();
            if (data == null || data.length == 0) {
                this.bodyWriter.drawImage(null, 0.0, 0.0, null, style, pStyle, inlineFlag, altText, bookmark, tocInfo);
                return;
            }
            int imageFileWidthDpi = imageInfo.getPhysicalWidthDpi() == -1 ? 0 : imageInfo.getPhysicalWidthDpi();
            int n = imageFileHeightDpi = imageInfo.getPhysicalHeightDpi() == -1 ? 0 : imageInfo.getPhysicalHeightDpi();
            if (image.getHeight() == null && image.getWidth() == null) {
                height = OdfUtil.convertImageSize((DimensionType)image.getHeight(), (int)imageInfo.getHeight(), (int)PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileHeightDpi, (int)0));
                width = OdfUtil.convertImageSize((DimensionType)image.getWidth(), (int)imageInfo.getWidth(), (int)PropertyUtil.getImageDpi((IImageContent)image, (int)imageFileWidthDpi, (int)0));
            } else if (image.getWidth() == null) {
                scale = (float)imageInfo.getHeight() / (float)imageInfo.getWidth();
                width = height / (double)scale;
            } else if (image.getHeight() == null) {
                scale = (float)imageInfo.getHeight() / (float)imageInfo.getWidth();
                height = width * (double)scale;
            }
            HyperlinkInfo hyper = this.getHyperlink((IContent)image);
            this.bodyWriter.drawImage(entry.getUri(), height, width, hyper, style, pStyle, inlineFlag, altText, bookmark, tocInfo);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            this.bodyWriter.drawImage(null, height, width, null, style, pStyle, inlineFlag, altText, bookmark, tocInfo);
        }
    }

    protected void endTable() {
        if (this.isClipped) {
            return;
        }
        this.context.addContainer(true);
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.bodyWriter.endTable();
        this.context.setLastIsTable(true);
        this.context.removeTable();
    }

    protected void increaseTOCLevel(IContent content) {
        if (content != null && content.getTOC() != null) {
            ++this.tocLevel;
        }
    }

    protected void decreaseTOCLevel(IContent content) {
        if (content != null && content.getTOC() != null) {
            --this.tocLevel;
        }
    }

    protected void adjustInline() {
        if (!this.context.isFirstInline()) {
            this.bodyWriter.endParagraph();
            this.context.endInline();
        }
    }

    protected void writeToc(IContent content) {
        Object tocObj;
        if (content != null && (tocObj = content.getTOC()) != null) {
            String toc = tocObj.toString();
            if (!"".equals(toc = toc.trim())) {
                this.bodyWriter.writeTOC(new TocInfo(toc, this.tocLevel));
            }
        }
    }

    private InlineFlag getInlineFlag(IStyle style) {
        InlineFlag inlineFlag = InlineFlag.BLOCK;
        if ("inline".equalsIgnoreCase(style.getDisplay())) {
            if (this.context.isFirstInline()) {
                this.context.startInline();
                inlineFlag = InlineFlag.FIRST_INLINE;
            } else {
                inlineFlag = InlineFlag.MIDDLE_INLINE;
            }
        } else {
            this.adjustInline();
        }
        return inlineFlag;
    }

    protected String getBookmark(IContent content) {
        String bookmark = content.getBookmark();
        if (bookmark == null || bookmark.startsWith("_TOC")) {
            return null;
        }
        if (this.bookmarks.contains(bookmark = OdfUtil.validBookmarkName((String)bookmark))) {
            return null;
        }
        return bookmark;
    }

    protected HyperlinkInfo getHyperlink(IContent content) {
        HyperlinkInfo hyperlink = null;
        IHyperlinkAction linkAction = content.getHyperlinkAction();
        if (linkAction != null) {
            String tooltip = linkAction.getTooltip();
            String bookmark = linkAction.getBookmark();
            switch (linkAction.getType()) {
                case 2: {
                    bookmark = bookmark.replaceAll(" ", "_");
                    hyperlink = new HyperlinkInfo(0, bookmark, tooltip);
                    break;
                }
                case 1: 
                case 3: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)this.reportRunnable, (IHTMLActionHandler)this.actionHandler, (IReportContext)this.reportContext);
                    hyperlink = new HyperlinkInfo(1, url, tooltip);
                }
            }
        }
        if (hyperlink != null) {
            StyleEntry style = StyleBuilder.createStyleEntry((IStyle)content.getStyle(), (int)1);
            this.context.addStyle(style);
            hyperlink.setStyle(style);
        }
        return hyperlink;
    }

    protected void writeText(int type, String txt, IContent content, InlineFlag inlineFlag, StyleEntry computedStyle, StyleEntry inlineStyle) {
        this.addContainerBookmark(content);
        this.addTableToc(content);
        HyperlinkInfo hyper = this.getHyperlink(content);
        int paragraphWidth = (int)OdfUtil.twipToPt((double)this.context.getCurrentWidth());
        boolean rtl = content.isDirectionRTL();
        if (content instanceof TextContent) {
            TextFlag textFlag = TextFlag.START;
            String fontFamily = null;
            this.bodyWriter.writeContent(type, txt, computedStyle, inlineStyle, fontFamily, hyper, inlineFlag, textFlag, paragraphWidth, rtl, this.containerBookmarks, this.tableTocs);
            if (inlineFlag == InlineFlag.BLOCK) {
                this.bodyWriter.writeContent(type, null, computedStyle, inlineStyle, fontFamily, hyper, inlineFlag, TextFlag.END, paragraphWidth, rtl, this.containerBookmarks, this.tableTocs);
            }
        } else {
            this.bodyWriter.writeContent(type, txt, computedStyle, inlineStyle, computedStyle.getStyle().getFontFamily(), hyper, inlineFlag, TextFlag.WHOLE, paragraphWidth, rtl, this.containerBookmarks, this.tableTocs);
        }
        this.containerBookmarks.clear();
        this.tableTocs.clear();
    }

    private String getFontFamily(IStyle c_style, Chunk ch) {
        String fontFamily = null;
        FontInfo info = ch.getFontInfo();
        fontFamily = info != null ? info.getFontName() : c_style.getFontFamily();
        return fontFamily;
    }

    private boolean isHidden(IContent content) {
        if (content != null) {
            IStyle style = content.getStyle();
            if (!IStyle.NONE_VALUE.equals(style.getProperty(54))) {
                return this.isHiddenByVisibility(content);
            }
            return true;
        }
        return false;
    }

    private boolean isHiddenByVisibility(IContent content) {
        assert (content != null);
        IStyle style = content.getStyle();
        String formats = style.getVisibleFormat();
        return this.contains(formats, this.getOutputFormat());
    }

    private boolean contains(String formats, String format) {
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0 || formats.indexOf(format) >= 0);
    }

    protected IStyle computeStyle(IStyle style) {
        if (this.styles.size() == 0) {
            return style;
        }
        int i = 0;
        while (i < 59) {
            if (this.isInherityProperty(i) && this.isNullValue(style.getProperty(i))) {
                style.setProperty(i, null);
                int p = this.styles.size() - 1;
                while (p >= 0) {
                    IStyle parent = (IStyle)this.styles.get(p);
                    if (!this.isNullValue(parent.getProperty(i))) {
                        style.setProperty(i, parent.getProperty(i));
                        break;
                    }
                    --p;
                }
            }
            ++i;
        }
        return style;
    }

    protected boolean isNullValue(CSSValue value) {
        if (value == null) {
            return true;
        }
        if (value instanceof DataFormatValue) {
            return true;
        }
        if (value instanceof FloatValue) {
            return false;
        }
        String cssText = value.getCssText();
        return "none".equalsIgnoreCase(cssText) || "transparent".equalsIgnoreCase(cssText);
    }

    private void writeHeaderFooter(IPageContent currentPage, boolean isLastPage) throws IOException, BirtException {
        MasterPageManager masterPageManager = this.context.getMasterPageManager();
        this.context.startMasterPage();
        IOdtWriter savedBodyWriter = this.bodyWriter;
        this.bodyWriter = this.masterPageWriter;
        SimpleMasterPageDesign master = (SimpleMasterPageDesign)this.previousPage.getGenerateBy();
        SimpleMasterPageDesign nextMaster = null;
        if (currentPage != null && !isLastPage) {
            nextMaster = (SimpleMasterPageDesign)currentPage.getGenerateBy();
        }
        String displayName = master.getName();
        if (masterPageManager.getInstanceNumber() > 1) {
            displayName = String.valueOf(displayName) + "-" + masterPageManager.getInstanceNumber();
        }
        this.masterPageWriter.startMasterPage(this.pageLayout, masterPageManager.getCurrentMasterPage(), displayName);
        if (this.previousPage.getPageHeader() != null && (this.previousPage.getPageNumber() > 1L || master.isShowHeaderOnFirst())) {
            this.masterPageWriter.startHeader();
            this.contentVisitor.visitChildren(this.previousPage.getPageHeader(), null);
            this.masterPageWriter.endHeader();
        }
        if (this.previousPage.getPageFooter() != null && (!isLastPage || master.isShowFooterOnLast())) {
            this.masterPageWriter.startFooter();
            this.contentVisitor.visitChildren(this.previousPage.getPageFooter(), null);
            this.masterPageWriter.endFooter();
        }
        this.masterPageWriter.endMasterPage();
        this.bodyWriter = savedBodyWriter;
        this.context.endMasterPage();
        if (nextMaster != null) {
            masterPageManager.newPage(nextMaster.getName());
        }
    }

    private boolean isInherityProperty(int propertyIndex) {
        return !NON_INHERITY_STYLES.contains(propertyIndex);
    }

    private double getCellWidth(double cellWidth, IStyle style) {
        double leftPadding = this.getPadding(style.getProperty(7));
        double rightPadding = this.getPadding(style.getProperty(12));
        if (leftPadding > cellWidth) {
            leftPadding = 0.0;
        }
        if (rightPadding > cellWidth) {
            rightPadding = 0.0;
        }
        if (leftPadding + rightPadding > cellWidth) {
            rightPadding = 0.0;
        }
        return cellWidth - leftPadding - rightPadding;
    }

    private double getPadding(CSSValue padding) {
        return OdfUtil.getDimensionValue((CSSValue)padding, (int)this.context.getReportDpi());
    }

    private double[] computeTblColumnWidths(ITableContent table, double tblWidth) {
        int colCount = table.getColumnCount();
        int[] tblColumns = new int[colCount];
        double[] doubleCols = new double[tblColumns.length];
        int count = 0;
        int total = 0;
        int i = 0;
        while (i < colCount) {
            IColumn col = table.getColumn(i);
            if (col.getWidth() == null) {
                tblColumns[i] = -1;
                doubleCols[i] = -1.0;
                ++count;
            } else {
                double val;
                doubleCols[i] = val = OdfUtil.convertTo((DimensionType)col.getWidth(), (double)tblWidth, (int)this.context.getReportDpi());
                tblColumns[i] = (int)(val * 1000.0);
                total += tblColumns[i];
            }
            ++i;
        }
        if (table.getWidth() == null && count == 0) {
            return doubleCols;
        }
        tblColumns = EmitterUtil.resizeTableColumn((int)((int)(tblWidth * 1000.0)), (int[])tblColumns, (int)count, (int)total);
        i = 0;
        while (i < tblColumns.length) {
            doubleCols[i] = (double)tblColumns[i] / 1000.0;
            ++i;
        }
        return doubleCols;
    }

    private void addContainerBookmark(IContent content) {
        String bookmark = this.getBookmark(content);
        if (content != null) {
            this.containerBookmarks.add(bookmark);
        }
    }

    protected String getRootMime() {
        return MIME_TYPE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InlineFlag {
        FIRST_INLINE,
        MIDDLE_INLINE,
        BLOCK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextFlag {
        START,
        MIDDLE,
        END,
        WHOLE;

    }
}

