/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.HashSet;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class NonVirtualDestructor
extends AbstractIndexAstChecker {
    public static final String PROBLEM_ID = "org.eclipse.cdt.codan.internal.checkers.NonVirtualDestructorProblem";
    private static HashSet<ICPPClassType> checkedClassTypes = new HashSet();

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnEachClass());
    }

    private static ICPPMethod getDestructor(ICPPClassType classType) {
        ICPPMethod[] iCPPMethodArray = classType.getDeclaredMethods();
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.isDestructor()) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasVirtualDestructor(ICPPClassType classType) {
        ICPPBase[] bases;
        checkedClassTypes.add(classType);
        ICPPMethod destructor = NonVirtualDestructor.getDestructor(classType);
        if (destructor != null && destructor.isVirtual()) {
            return true;
        }
        ICPPBase[] iCPPBaseArray = bases = classType.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType cppClassType;
            ICPPBase base = iCPPBaseArray[n2];
            IBinding baseClass = base.getBaseClass();
            if (baseClass instanceof ICPPClassType && !checkedClassTypes.contains(cppClassType = (ICPPClassType)baseClass) && NonVirtualDestructor.hasVirtualDestructor(cppClassType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class OnEachClass
    extends ASTVisitor {
        OnEachClass() {
            this.shouldVisitDeclSpecifiers = true;
        }

        public int visit(IASTDeclSpecifier decl) {
            if (decl instanceof ICPPASTCompositeTypeSpecifier) {
                IASTNode[] decls;
                ICPPASTCompositeTypeSpecifier spec = (ICPPASTCompositeTypeSpecifier)decl;
                IASTName className = spec.getName();
                IBinding binding = className.resolveBinding();
                if (!(binding instanceof ICPPClassType)) {
                    return 1;
                }
                ICPPClassType classType = (ICPPClassType)binding;
                boolean hasVirtualDestructor = NonVirtualDestructor.hasVirtualDestructor(classType);
                checkedClassTypes.clear();
                if (hasVirtualDestructor) {
                    return 1;
                }
                ICPPMethod virtualMethod = null;
                ICPPMethod[] iCPPMethodArray = classType.getAllDeclaredMethods();
                int n = iCPPMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPMethod method = iCPPMethodArray[n2];
                    if (!method.isDestructor() && method.isVirtual()) {
                        virtualMethod = method;
                    }
                    ++n2;
                }
                if (virtualMethod == null) {
                    return 1;
                }
                ICPPMethod destructor = NonVirtualDestructor.getDestructor(classType);
                if (destructor != null && destructor.getVisibility() != 1 && classType.getFriends().length == 0) {
                    return 1;
                }
                IASTDeclSpecifier node = decl;
                if (destructor instanceof ICPPInternalBinding && (decls = ((ICPPInternalBinding)destructor).getDeclarations()) != null && decls.length > 0) {
                    node = decls[0];
                }
                NonVirtualDestructor.this.reportProblem(NonVirtualDestructor.PROBLEM_ID, (IASTNode)node, new Object[]{className.getSimpleID().toString(), virtualMethod.getName()});
                return 1;
            }
            return 3;
        }
    }
}

