/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.core.model.ILanguageMappingChangeEvent;
import org.eclipse.cdt.core.model.ILanguageMappingChangeListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageMappingChangeEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.CContentTypes;
import org.eclipse.cdt.internal.core.language.LanguageMappingResolver;
import org.eclipse.cdt.internal.core.language.LanguageMappingStore;
import org.eclipse.cdt.internal.core.model.LanguageDescriptor;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageManager {
    private static final String NAMESPACE_SEPARATOR = ".";
    private static final String LANGUAGE_EXTENSION_POINT_ID = "org.eclipse.cdt.core.language";
    private static final String ELEMENT_LANGUAGE = "language";
    private static final String ELEMENT_CONTENT_TYPE = "contentType";
    private static final String ELEMENT_PDOM_LINKAGE_FACTORY = "pdomLinkageFactory";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_ID = "id";
    private static LanguageManager instance;
    private Map<String, ILanguage> fLanguageCache = new HashMap<String, ILanguage>();
    private Map<String, IPDOMLinkageFactory> fPDOMLinkageFactoryCache = new HashMap<String, IPDOMLinkageFactory>();
    private Map<String, ILanguage> fContentTypeToLanguageCache = new HashMap<String, ILanguage>();
    private Map<IProject, ProjectLanguageConfiguration> fLanguageConfigurationCache = new HashMap<IProject, ProjectLanguageConfiguration>();
    private boolean fIsFullyCached;
    private HashMap<String, ILanguageDescriptor> fIdToLanguageDescriptorCache;
    private HashMap<String, List<ILanguageDescriptor>> fContentTypeToDescriptorListCache;
    private ListenerList fLanguageChangeListeners = new ListenerList(1);
    private WorkspaceLanguageConfiguration fWorkspaceMappings;

    public static LanguageManager getInstance() {
        if (instance == null) {
            instance = new LanguageManager();
        }
        return instance;
    }

    public ILanguageDescriptor getLanguageDescriptor(String id) {
        HashMap<String, ILanguageDescriptor> map = this.getDescriptorCache();
        return (ILanguageDescriptor)map.get(id);
    }

    private HashMap<String, ILanguageDescriptor> getDescriptorCache() {
        if (this.fIdToLanguageDescriptorCache == null) {
            this.fIdToLanguageDescriptorCache = this.createDescriptorCache();
        }
        return this.fIdToLanguageDescriptorCache;
    }

    public ILanguageDescriptor[] getLanguageDescriptors() {
        HashMap<String, ILanguageDescriptor> map = this.getDescriptorCache();
        return map.values().toArray(new ILanguageDescriptor[map.size()]);
    }

    private HashMap<String, ILanguageDescriptor> createDescriptorCache() {
        HashMap<String, ILanguageDescriptor> map = new HashMap<String, ILanguageDescriptor>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT_ID);
        int j = 0;
        while (j < configs.length) {
            IConfigurationElement languageElem = configs[j];
            if (ELEMENT_LANGUAGE.equals(languageElem.getName())) {
                LanguageDescriptor lDes = new LanguageDescriptor(languageElem);
                map.put(lDes.getId(), lDes);
            }
            ++j;
        }
        return map;
    }

    private HashMap<String, List<ILanguageDescriptor>> getContentTypeToDescriptorCache() {
        if (this.fContentTypeToDescriptorListCache == null) {
            this.fContentTypeToDescriptorListCache = this.createContentTypeToDescriptorCache();
        }
        return this.fContentTypeToDescriptorListCache;
    }

    public Map<String, ILanguageDescriptor[]> getContentTypeIdToLanguageDescriptionsMap() {
        HashMap<String, ILanguageDescriptor[]> map = new HashMap<String, ILanguageDescriptor[]>();
        HashMap<String, List<ILanguageDescriptor>> cache = this.getContentTypeToDescriptorCache();
        for (Map.Entry entry : cache.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() <= 0) continue;
            ILanguageDescriptor[] dess = list.toArray(new ILanguageDescriptor[list.size()]);
            map.put((String)entry.getKey(), dess);
        }
        return map;
    }

    private HashMap<String, List<ILanguageDescriptor>> createContentTypeToDescriptorCache() {
        HashMap<String, List<ILanguageDescriptor>> map = new HashMap<String, List<ILanguageDescriptor>>();
        HashMap<String, ILanguageDescriptor> dc = this.getDescriptorCache();
        for (ILanguageDescriptor des : dc.values()) {
            IContentType[] types;
            IContentType[] iContentTypeArray = types = des.getContentTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type = iContentTypeArray[n2];
                String id = type.getId();
                List<ILanguageDescriptor> list = map.get(id);
                if (list == null) {
                    list = new ArrayList<ILanguageDescriptor>();
                    map.put(id, list);
                }
                list.add(des);
                ++n2;
            }
        }
        return map;
    }

    public ILanguage getLanguage(String id) {
        ILanguage language = this.fLanguageCache.get(id);
        if (language != null) {
            return language;
        }
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT_ID);
        int j = 0;
        while (j < configs.length) {
            String langId;
            final IConfigurationElement languageElem = configs[j];
            if (ELEMENT_LANGUAGE.equals(languageElem.getName()) && (langId = this.getLanguageID(languageElem)).equals(id)) {
                final ILanguage[] result = new ILanguage[1];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CCorePlugin.log(exception);
                    }

                    public void run() throws Exception {
                        result[0] = (ILanguage)languageElem.createExecutableExtension(LanguageManager.ATTRIBUTE_CLASS);
                    }
                });
                if (result[0] != null) {
                    this.fLanguageCache.put(id, result[0]);
                    return result[0];
                }
            }
            ++j;
        }
        return null;
    }

    private String getLanguageID(IConfigurationElement languageElem) {
        return String.valueOf(languageElem.getNamespaceIdentifier()) + NAMESPACE_SEPARATOR + languageElem.getAttribute(ATTRIBUTE_ID);
    }

    public ILanguage getLanguage(IContentType contentType) {
        String contentTypeID = contentType.getId();
        return this.getLanguageForContentTypeID(contentTypeID);
    }

    public ILanguage getLanguageForContentTypeID(String contentTypeID) {
        this.cacheAllLanguages();
        ILanguage language = this.fContentTypeToLanguageCache.get(contentTypeID);
        if (language != null || this.fContentTypeToLanguageCache.containsKey(contentTypeID)) {
            return language;
        }
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT_ID);
        int j = 0;
        while (j < configs.length) {
            IConfigurationElement languageElem = configs[j];
            if (ELEMENT_LANGUAGE.equals(languageElem.getName())) {
                IConfigurationElement[] assocContentTypes = languageElem.getChildren(ELEMENT_CONTENT_TYPE);
                int k = 0;
                while (k < assocContentTypes.length) {
                    if (contentTypeID.equals(assocContentTypes[k].getAttribute(ATTRIBUTE_ID))) {
                        String id = this.getLanguageID(languageElem);
                        ILanguage lang = this.getLanguage(id);
                        this.fContentTypeToLanguageCache.put(contentTypeID, lang);
                        return lang;
                    }
                    ++k;
                }
            }
            ++j;
        }
        this.fContentTypeToLanguageCache.put(contentTypeID, null);
        return null;
    }

    @Deprecated
    public ArrayList<String> getAllContentTypes() {
        ArrayList<String> allTypes = new ArrayList<String>();
        allTypes.add("org.eclipse.cdt.core.asmSource");
        allTypes.add("org.eclipse.cdt.core.cHeader");
        allTypes.add("org.eclipse.cdt.core.cSource");
        allTypes.add("org.eclipse.cdt.core.cxxHeader");
        allTypes.add("org.eclipse.cdt.core.cxxSource");
        IContentTypeManager manager = Platform.getContentTypeManager();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT_ID);
        int j = 0;
        while (j < configs.length) {
            IConfigurationElement languageElem = configs[j];
            if (ELEMENT_LANGUAGE.equals(languageElem.getName())) {
                IConfigurationElement[] contentTypes = languageElem.getChildren(ELEMENT_CONTENT_TYPE);
                int k = 0;
                while (k < contentTypes.length) {
                    IContentType langContType = manager.getContentType(contentTypes[k].getAttribute(ATTRIBUTE_ID));
                    allTypes.add(langContType.getId());
                    ++k;
                }
            }
            ++j;
        }
        return allTypes;
    }

    public String[] getRegisteredContentTypeIds() {
        Set<String> contentTypes = this.collectContentTypeIds();
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    private Set<String> collectContentTypeIds() {
        HashSet<String> allTypes = new HashSet<String>();
        allTypes.add("org.eclipse.cdt.core.asmSource");
        allTypes.add("org.eclipse.cdt.core.cHeader");
        allTypes.add("org.eclipse.cdt.core.cSource");
        allTypes.add("org.eclipse.cdt.core.cxxHeader");
        allTypes.add("org.eclipse.cdt.core.cxxSource");
        IContentTypeManager manager = Platform.getContentTypeManager();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT_ID);
        int j = 0;
        while (j < configs.length) {
            IConfigurationElement languageElem = configs[j];
            if (ELEMENT_LANGUAGE.equals(languageElem.getName())) {
                IConfigurationElement[] contentTypes = languageElem.getChildren(ELEMENT_CONTENT_TYPE);
                int k = 0;
                while (k < contentTypes.length) {
                    IContentType langContType = manager.getContentType(contentTypes[k].getAttribute(ATTRIBUTE_ID));
                    allTypes.add(langContType.getId());
                    ++k;
                }
            }
            ++j;
        }
        return allTypes;
    }

    public boolean isContributedContentType(String contentTypeId) {
        return contentTypeId != null && this.getLanguageForContentTypeID(contentTypeId) != null;
    }

    @Deprecated
    public IContributedModelBuilder getContributedModelBuilderFor(TranslationUnit tu) {
        try {
            ILanguage lang = tu.getLanguage();
            return lang == null ? null : lang.createModelBuilder(tu);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IContributedModelBuilder getContributedModelBuilderFor(ITranslationUnit tu) {
        try {
            ILanguage lang = tu.getLanguage();
            return lang == null ? null : lang.createModelBuilder(tu);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public Map<String, IPDOMLinkageFactory> getPDOMLinkageFactoryMappings() {
        IConfigurationElement[] configs;
        if (!this.fPDOMLinkageFactoryCache.isEmpty()) {
            return Collections.unmodifiableMap(this.fPDOMLinkageFactoryCache);
        }
        this.fPDOMLinkageFactoryCache.clear();
        final IPDOMLinkageFactory[] result = new IPDOMLinkageFactory[1];
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEMENT_PDOM_LINKAGE_FACTORY.equals(element.getName())) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CCorePlugin.log(exception);
                    }

                    public void run() throws Exception {
                        result[0] = (IPDOMLinkageFactory)element.createExecutableExtension(LanguageManager.ATTRIBUTE_CLASS);
                    }
                });
                this.fPDOMLinkageFactoryCache.put(element.getAttribute(ATTRIBUTE_ID), result[0]);
            }
            ++n2;
        }
        return Collections.unmodifiableMap(this.fPDOMLinkageFactoryCache);
    }

    public ILanguage[] getRegisteredLanguages() {
        this.cacheAllLanguages();
        ILanguage[] languages = new ILanguage[this.fLanguageCache.size()];
        Iterator<ILanguage> values = this.fLanguageCache.values().iterator();
        int i = 0;
        while (values.hasNext()) {
            languages[i] = values.next();
            ++i;
        }
        return languages;
    }

    private void cacheAllLanguages() {
        if (this.fIsFullyCached) {
            return;
        }
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_EXTENSION_POINT_ID);
        int j = 0;
        while (j < configs.length) {
            final IConfigurationElement languageElem = configs[j];
            if (ELEMENT_LANGUAGE.equals(languageElem.getName())) {
                String langId = this.getLanguageID(languageElem);
                final ILanguage[] result = new ILanguage[1];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CCorePlugin.log(exception);
                    }

                    public void run() throws Exception {
                        result[0] = (ILanguage)languageElem.createExecutableExtension(LanguageManager.ATTRIBUTE_CLASS);
                    }
                });
                if (result[0] != null) {
                    this.fLanguageCache.put(langId, result[0]);
                }
            }
            ++j;
        }
        this.fIsFullyCached = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceLanguageConfiguration getWorkspaceLanguageConfiguration() throws CoreException {
        LanguageManager languageManager = this;
        synchronized (languageManager) {
            if (this.fWorkspaceMappings != null) {
                return this.fWorkspaceMappings;
            }
            LanguageMappingStore store = new LanguageMappingStore();
            this.fWorkspaceMappings = store.decodeWorkspaceMappings();
            return this.fWorkspaceMappings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWorkspaceLanguageConfiguration(IContentType[] affectedContentTypes) throws CoreException {
        LanguageManager languageManager = this;
        synchronized (languageManager) {
            if (this.fWorkspaceMappings == null) {
                return;
            }
            LanguageMappingStore store = new LanguageMappingStore();
            store.storeMappings(this.fWorkspaceMappings);
        }
        LanguageMappingChangeEvent event = new LanguageMappingChangeEvent();
        event.setType(0);
        event.setAffectedContentTypes(affectedContentTypes);
        this.notifyLanguageChangeListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectLanguageConfiguration getLanguageConfiguration(IProject project) throws CoreException {
        LanguageManager languageManager = this;
        synchronized (languageManager) {
            ProjectLanguageConfiguration mappings = this.fLanguageConfigurationCache.get(project);
            if (mappings != null) {
                return mappings;
            }
            LanguageMappingStore store = new LanguageMappingStore();
            mappings = store.decodeMappings(project);
            this.fLanguageConfigurationCache.put(project, mappings);
            return mappings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLanguageMappingConfiguration(IProject project, IContentType[] affectedContentTypes) throws CoreException {
        LanguageManager languageManager = this;
        synchronized (languageManager) {
            ProjectLanguageConfiguration mappings = this.fLanguageConfigurationCache.get(project);
            LanguageMappingStore store = new LanguageMappingStore();
            store.storeMappings(project, mappings);
        }
        LanguageMappingChangeEvent event = new LanguageMappingChangeEvent();
        event.setType(1);
        event.setProject(project);
        event.setAffectedContentTypes(affectedContentTypes);
        this.notifyLanguageChangeListeners(event);
    }

    public ILanguage getLanguageForFile(String fullPathToFile, IProject project, ICConfigurationDescription configuration) throws CoreException {
        if (project == null) {
            throw new IllegalArgumentException("project must not be null in call to LanguageManager.getLanguageForFile(String, IProject)");
        }
        IContentType contentType = CContentTypes.getContentType(project, fullPathToFile);
        if (contentType == null) {
            return null;
        }
        String contentTypeID = contentType.getId();
        return LanguageMappingResolver.computeLanguage((IProject)project, (String)fullPathToFile, (ICConfigurationDescription)configuration, (String)contentTypeID, (boolean)false)[0].language;
    }

    public ILanguage getLanguageForFile(IPath pathToFile, IProject project, ICConfigurationDescription configuration) throws CoreException {
        return this.getLanguageForFile(pathToFile, project, configuration, null);
    }

    public ILanguage getLanguageForFile(IPath pathToFile, IProject project, ICConfigurationDescription configuration, String contentTypeID) throws CoreException {
        if (project == null) {
            IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(pathToFile);
            if (resource == null) {
                return null;
            }
            project = resource.getProject();
        }
        if (contentTypeID == null) {
            IContentType ct = CContentTypes.getContentType(project, pathToFile.toString());
            if (ct == null) {
                return null;
            }
            contentTypeID = ct.getId();
        }
        return LanguageMappingResolver.computeLanguage((IProject)project, (String)pathToFile.toPortableString(), (ICConfigurationDescription)configuration, (String)contentTypeID, (boolean)false)[0].language;
    }

    public ILanguage getLanguageForFile(IFile file, ICConfigurationDescription configuration) throws CoreException {
        return this.getLanguageForFile(file, configuration, null);
    }

    public ILanguage getLanguageForFile(IFile file, ICConfigurationDescription configuration, String contentTypeId) throws CoreException {
        IProject project = file.getProject();
        if (contentTypeId == null) {
            IContentType contentType = CContentTypes.getContentType(project, file.getLocation().toString());
            if (contentType == null) {
                return null;
            }
            contentTypeId = contentType.getId();
        }
        return LanguageMappingResolver.computeLanguage((IProject)project, (String)file.getProjectRelativePath().toPortableString(), (ICConfigurationDescription)configuration, (String)contentTypeId, (boolean)false)[0].language;
    }

    public void registerLanguageChangeListener(ILanguageMappingChangeListener listener) {
        this.fLanguageChangeListeners.add((Object)listener);
    }

    public void unregisterLanguageChangeListener(ILanguageMappingChangeListener listener) {
        this.fLanguageChangeListeners.remove((Object)listener);
    }

    public void notifyLanguageChangeListeners(ILanguageMappingChangeEvent event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fLanguageChangeListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ILanguageMappingChangeListener listener = (ILanguageMappingChangeListener)obj;
            listener.handleLanguageMappingChangeEvent(event);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLanguageMappingConfiguration(IFile file) throws CoreException {
        IProject project = file.getProject();
        LanguageManager languageManager = this;
        synchronized (languageManager) {
            ProjectLanguageConfiguration mappings = this.fLanguageConfigurationCache.get(project);
            LanguageMappingStore store = new LanguageMappingStore();
            store.storeMappings(project, mappings);
        }
        LanguageMappingChangeEvent event = new LanguageMappingChangeEvent();
        event.setType(2);
        event.setProject(project);
        event.setFile(file);
        this.notifyLanguageChangeListeners(event);
    }

    public ILanguage getLanguage(IContentType contentType, IProject project) {
        return this.getLanguage(contentType, project, null);
    }

    public ILanguage getLanguage(IContentType contentType, IProject project, ICConfigurationDescription configurationDescription) {
        try {
            ProjectLanguageConfiguration projectConfig = this.getLanguageConfiguration(project);
            String contentTypeId = contentType.getId();
            String langId = projectConfig.getLanguageForContentType(configurationDescription, contentTypeId);
            if (langId == null) {
                WorkspaceLanguageConfiguration wsConfig = this.getWorkspaceLanguageConfiguration();
                langId = wsConfig.getLanguageForContentType(contentTypeId);
            }
            return langId != null ? this.getLanguage(langId) : this.getLanguage(contentType);
        }
        catch (CoreException coreException) {
            return this.getLanguage(contentType);
        }
    }
}

