/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Iterator<T> reverseIterator(List<T> list) {
        return new Iterator<T>(list){
            ListIterator<T> iterator;
            {
                this.iterator = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasPrevious();
            }

            @Override
            public T next() {
                return this.iterator.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported");
            }
        };
    }

    public static <T> Iterable<T> reverseIterable(List<T> list) {
        return CollectionUtils.iterable(CollectionUtils.reverseIterator(list));
    }

    public static <T> Iterable<T> iterable(final Iterator<T> iter) {
        if (iter == null) {
            throw new NullPointerException("iter parameter is null");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iter;
            }
        };
    }

    public static <T> T findFirstAndRemove(List<?> list, Class<T> clazz) {
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!clazz.isInstance(o)) continue;
            iter.remove();
            return (T)o;
        }
        return null;
    }
}

