/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeStringInterner {
    public static String safeIntern(String string) {
        if (string != null) {
            return string.intern();
        }
        return string;
    }

    public static String[] safeIntern(String[] strArray) {
        if (strArray == null) {
            return null;
        }
        int i = 0;
        while (i < strArray.length) {
            strArray[i] = SafeStringInterner.safeIntern(strArray[i]);
            ++i;
        }
        return strArray;
    }

    public static <T> HashMap<String, T> safeIntern(HashMap<String, T> map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap<String, T> tempMap = new HashMap<String, T>(map);
        map.clear();
        for (String string : tempMap.keySet()) {
            Object value = tempMap.get(string);
            if (value instanceof String) {
                value = SafeStringInterner.safeIntern((String)value);
            }
            map.put(SafeStringInterner.safeIntern(string), value);
        }
        return map;
    }

    public static <T> LinkedHashMap<String, T> safeIntern(LinkedHashMap<String, T> map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        LinkedHashMap<String, T> tempMap = new LinkedHashMap<String, T>(map);
        map.clear();
        for (String string : tempMap.keySet()) {
            Object value = tempMap.get(string);
            if (value instanceof String) {
                value = SafeStringInterner.safeIntern((String)value);
            }
            map.put(SafeStringInterner.safeIntern(string), value);
        }
        return map;
    }

    public static <T> Map<String, T> safeIntern(Map<String, T> map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap<String, T> tempMap = new HashMap<String, T>(map);
        map.clear();
        for (String string : tempMap.keySet()) {
            Object value = tempMap.get(string);
            if (value instanceof String) {
                value = SafeStringInterner.safeIntern((String)value);
            }
            map.put(SafeStringInterner.safeIntern(string), value);
        }
        return map;
    }
}

