/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class NameWriter
extends NodeWriter {
    private static final String OPERATOR = "operator ";

    public NameWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    protected void writeName(IASTName name) {
        if (name instanceof ICPPASTTemplateId) {
            this.writeTempalteId((ICPPASTTemplateId)name);
        } else if (name instanceof ICPPASTConversionName) {
            this.scribe.print(OPERATOR);
            ((ICPPASTConversionName)name).getTypeId().accept(this.visitor);
        } else if (name instanceof ICPPASTQualifiedName) {
            this.writeQualifiedName((ICPPASTQualifiedName)name);
        } else {
            this.scribe.print(name.toString());
        }
        if (this.hasTrailingComments(name)) {
            this.writeTrailingComments(name);
        }
    }

    private void writeTempalteId(ICPPASTTemplateId tempId) {
        if (this.needsTemplateQualifier(tempId)) {
            this.scribe.print("template ");
        }
        this.scribe.print(tempId.getTemplateName().toString());
        this.scribe.print('<');
        IASTNode[] nodes = tempId.getTemplateArguments();
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept(this.visitor);
            if (i + 1 < nodes.length) {
                this.scribe.print(',');
            }
            ++i;
        }
        this.scribe.print('>');
        if (this.isNestedTemplateId(tempId)) {
            this.scribe.printSpace();
        }
    }

    private boolean needsTemplateQualifier(ICPPASTTemplateId templId) {
        if (templId.getParent() instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qName = (ICPPASTQualifiedName)templId.getParent();
            return this.isDependentName(qName, templId);
        }
        return false;
    }

    private boolean isDependentName(ICPPASTQualifiedName qname, ICPPASTTemplateId tempId) {
        IASTName[] names = qname.getNames();
        int i = 0;
        while (i < names.length) {
            if (names[i] == tempId) {
                return this.isDependentName(qname, tempId, i);
            }
            ++i;
        }
        return false;
    }

    private boolean isDependentName(ICPPASTQualifiedName qname, ICPPASTTemplateId tempId, int i) {
        if (i <= 0) {
            return false;
        }
        if (qname.getNames()[i - 1] instanceof ICPPASTTemplateId) {
            return true;
        }
        IBinding binding = qname.getNames()[i - 1].resolveBinding();
        if (binding instanceof CPPTemplateTypeParameter) {
            return true;
        }
        return this.isDependentName(qname, tempId, i - 1);
    }

    private boolean isNestedTemplateId(IASTNode node) {
        while ((node = node.getParent()) != null) {
            if (!(node instanceof ICPPASTTemplateId)) continue;
            return true;
        }
        return false;
    }

    private void writeQualifiedName(ICPPASTQualifiedName qname) {
        IASTName[] nodes = qname.getNames();
        int i = 0;
        while (i < nodes.length) {
            nodes[i].accept(this.visitor);
            if (i + 1 < nodes.length) {
                this.scribe.print("::");
            }
            ++i;
        }
    }
}

