/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class TemplateParameterWriter
extends NodeWriter {
    private static final String GREATER_THAN_CLASS = "> class";
    private static final String TEMPLATE_LESS_THAN = "template <";

    public TemplateParameterWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    protected void writeTemplateParameter(ICPPASTTemplateParameter parameter) {
        if (parameter instanceof ICPPASTParameterDeclaration) {
            ((ICPPASTParameterDeclaration)parameter).accept(this.visitor);
        } else if (parameter instanceof ICPPASTSimpleTypeTemplateParameter) {
            this.writeSimpleTypeTemplateParameter((ICPPASTSimpleTypeTemplateParameter)parameter);
        } else if (parameter instanceof ICPPASTTemplatedTypeTemplateParameter) {
            this.writeTemplatedTypeTemplateParameter((ICPPASTTemplatedTypeTemplateParameter)parameter);
        }
    }

    private void writeTemplatedTypeTemplateParameter(ICPPASTTemplatedTypeTemplateParameter templated) {
        this.scribe.print(TEMPLATE_LESS_THAN);
        IASTNode[] params = templated.getTemplateParameters();
        this.writeNodeList(params);
        this.scribe.print(GREATER_THAN_CLASS);
        if (templated.getName() != null) {
            this.scribe.printSpace();
            templated.getName().accept(this.visitor);
        }
        if (templated.getDefaultValue() != null) {
            this.scribe.print(" = ");
            templated.getDefaultValue().accept(this.visitor);
        }
    }

    private void writeSimpleTypeTemplateParameter(ICPPASTSimpleTypeTemplateParameter simple) {
        switch (simple.getParameterType()) {
            case 1: {
                this.scribe.print("class ");
                break;
            }
            case 2: {
                this.scribe.print("typename ");
            }
        }
        this.visitNodeIfNotNull(simple.getName());
        if (simple.getDefaultType() != null) {
            this.scribe.print(" = ");
            simple.getDefaultType().accept(this.visitor);
        }
    }
}

