/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.ResourceChangeHandlerBase;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ResourceChangeHandler
extends ResourceChangeHandlerBase
implements ISaveParticipant {
    protected ResourceChangeHandlerBase.IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent event) {
        return new RcMoveHandler();
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    protected void doHandleResourceMove(IResourceChangeEvent event, ResourceChangeHandlerBase.IResourceMoveHandler handler) {
        switch (event.getType()) {
            case 1: {
                IResourceDelta[] projs;
                IResourceDelta delta = event.getDelta();
                if (delta == null) break;
                IResourceDelta[] iResourceDeltaArray = projs = delta.getAffectedChildren();
                int n = projs.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta proj = iResourceDeltaArray[n2];
                    IResourceDelta projDelta = proj;
                    if (this.shouldVisit((IProject)projDelta.getResource()) && (projDelta.getKind() & 2) != 2) {
                        IResourceDelta[] children;
                        IResourceDelta[] iResourceDeltaArray2 = children = projDelta.getAffectedChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IResourceDelta child = iResourceDeltaArray2[n4];
                            IResource rc = child.getResource();
                            if (rc.getType() != 1) {
                                // empty if block
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                break;
            }
        }
        super.doHandleResourceMove(event, handler);
    }

    private static class RcMoveHandler
    implements ResourceChangeHandlerBase.IResourceMoveHandler {
        CProjectDescriptionManager fMngr = CProjectDescriptionManager.getInstance();
        Map<IProject, ICProjectDescription> fProjDesMap = new HashMap<IProject, ICProjectDescription>();
        Collection<IProject> fRemovedProjects = new HashSet<IProject>();
        Map<IResource, IResource> fMovedResources = new HashMap<IResource, IResource>();

        private RcMoveHandler() {
        }

        public void handleProjectClose(IProject project) {
            this.fMngr.projectClosedRemove(project);
        }

        private ICSourceEntry[] checkMove(IPath fromFullPath, IPath toFullPath, ICSourceEntry[] entries) {
            boolean modified = false;
            int k = 0;
            while (k < entries.length) {
                if (entries[k].getFullPath().equals((Object)fromFullPath)) {
                    ICSourceEntry entry = entries[k];
                    entries[k] = (ICSourceEntry)CDataUtil.createEntry(entry.getKind(), toFullPath.toString(), null, entry.getExclusionPatterns(), entry.getFlags());
                    modified = true;
                }
                ++k;
            }
            return modified ? entries : null;
        }

        private ICSourceEntry[] checkRemove(IPath rcFullPath, ICSourceEntry[] entries) {
            ArrayList<ICSourceEntry> updatedList = null;
            int num = 0;
            ICSourceEntry[] iCSourceEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ICSourceEntry entrie = iCSourceEntryArray[n2];
                if (entrie.getFullPath().equals((Object)rcFullPath)) {
                    if (updatedList == null) {
                        updatedList = new ArrayList<ICSourceEntry>(Arrays.asList(entries));
                    }
                    updatedList.remove(num);
                } else {
                    ++num;
                }
                ++n2;
            }
            return updatedList != null ? updatedList.toArray(new ICSourceEntry[updatedList.size()]) : null;
        }

        public boolean handleResourceMove(IResource fromRc, IResource toRc) {
            boolean proceed = true;
            IProject fromProject = fromRc.getProject();
            IProject toProject = toRc.getProject();
            switch (toRc.getType()) {
                case 4: {
                    ICProjectDescription des = this.fMngr.projectMove(fromProject, toProject);
                    this.fRemovedProjects.add(fromProject);
                    if (des == null) break;
                    this.fProjDesMap.put(toProject, des);
                    break;
                }
                case 1: 
                case 2: {
                    if (!toProject.equals((Object)fromProject) || fromRc.getFullPath().equals((Object)toRc.getFullPath())) break;
                    this.fMovedResources.put(fromRc, toRc);
                }
            }
            return proceed;
        }

        private ICProjectDescription getProjectDescription(IResource rc) {
            IProject project = rc.getProject();
            ICProjectDescription des = this.fProjDesMap.get(project);
            if (des == null && !this.fProjDesMap.containsKey(project)) {
                int flags = 0;
                flags |= Integer.MIN_VALUE;
                des = this.fMngr.getProjectDescription(project, flags |= 4);
                if (des != null) {
                    this.fProjDesMap.put(project, des);
                }
            }
            return des;
        }

        public boolean handleResourceRemove(IResource rc) {
            boolean proceed = true;
            IProject project = rc.getProject();
            switch (rc.getType()) {
                case 4: {
                    this.fMngr.projectClosedRemove(project);
                    this.fRemovedProjects.add(project);
                    proceed = false;
                    break;
                }
                case 1: 
                case 2: {
                    if (!project.isAccessible()) break;
                    this.fMovedResources.put(rc, null);
                }
            }
            return proceed;
        }

        public void done() {
            Iterator<IResource> it = this.fMovedResources.keySet().iterator();
            while (it.hasNext()) {
                if (!this.fRemovedProjects.contains(it.next().getProject())) continue;
                it.remove();
            }
            if (this.fMovedResources.isEmpty() && this.fProjDesMap.isEmpty()) {
                return;
            }
            CProjectDescriptionManager.runWspModification(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (Map.Entry<IResource, IResource> entry : RcMoveHandler.this.fMovedResources.entrySet()) {
                        ICProjectDescription prjDesc;
                        URI uri;
                        IResource from = entry.getKey();
                        IResource to = entry.getValue();
                        if (!$assertionsDisabled && to != null && !to.getProject().equals((Object)from.getProject())) {
                            throw new AssertionError();
                        }
                        if (to == null && (from.exists() || from.getWorkspace().validateFiltered(from).isOK() && (uri = from.getLocationURI()) != null && EFS.getStore((URI)uri).fetchInfo().exists()) || (prjDesc = RcMoveHandler.this.getProjectDescription(from)) == null) continue;
                        ICConfigurationDescription[] iCConfigurationDescriptionArray = prjDesc.getConfigurations();
                        int n = iCConfigurationDescriptionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
                            try {
                                ICResourceDescription rcDescription;
                                if (from instanceof IFolder) {
                                    ICSourceEntry[] entries = cfg.getSourceEntries();
                                    entries = to != null ? RcMoveHandler.this.checkMove(from.getFullPath(), to.getFullPath(), entries) : RcMoveHandler.this.checkRemove(from.getFullPath(), entries);
                                    if (entries != null) {
                                        cfg.setSourceEntries(entries);
                                    }
                                }
                                if ((rcDescription = cfg.getResourceDescription(from.getProjectRelativePath(), true)) != null) {
                                    if (to != null) {
                                        rcDescription.setPath(to.getProjectRelativePath());
                                    } else {
                                        cfg.removeResourceDescription(rcDescription);
                                    }
                                }
                            }
                            catch (WriteAccessException e) {
                                CCorePlugin.log(e);
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                            }
                            ++n2;
                        }
                    }
                    RcMoveHandler.this.fMovedResources.clear();
                    for (Map.Entry<Object, Object> entry : RcMoveHandler.this.fProjDesMap.entrySet()) {
                        if (!((IProject)entry.getKey()).isAccessible()) continue;
                        try {
                            RcMoveHandler.this.fMngr.setProjectDescription((IProject)entry.getKey(), (ICProjectDescription)entry.getValue());
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

