/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.cdt.debug.gdbjtag.core.Activator;
import org.eclipse.cdt.debug.gdbjtag.core.IGDBJtagConnection;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContribution;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.GDBJtagDeviceContributionFactory;
import org.eclipse.cdt.debug.gdbjtag.core.jtagdevice.IGDBJtagDevice;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.debug.gdbjtag.ui.Messages;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryDescriptor;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GDBJtagDebuggerTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "org.eclipse.cdt.debug.gdbjtag.ui.debuggertab.cdi";
    private CommandFactoryDescriptor[] cfDescs;
    private Text gdbCommand;
    private Combo commandFactory;
    private Combo miProtocol;
    private Button verboseMode;
    private Button useRemote;
    private Combo jtagDevice;
    private Composite remoteConnectionParameters;
    private StackLayout remoteConnectParmsLayout;
    private Composite remoteTcpipBox;
    private Text ipAddress;
    private Text portNumber;
    private Composite remoteConnectionBox;
    private Text connection;
    private String savedJtagDevice;

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        Group group = new Group(comp, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagDebuggerTab.gdbSetupGroup_Text"));
        this.createCommandControl((Composite)group);
        this.createCommandFactoryControl((Composite)group);
        this.createProtocolControl((Composite)group);
        this.createVerboseModeControl((Composite)group);
        this.createRemoteControl(comp);
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.append(dialog.getVariableExpression());
        }
    }

    private void createCommandControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandLabel"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.gdbCommand = new Text(comp, 2052);
        gd = new GridData(768);
        this.gdbCommand.setLayoutData((Object)gd);
        this.gdbCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.scheduleUpdateJob();
            }
        });
        Button button = new Button(comp, 0);
        button.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandBrowse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.browseButtonSelected(Messages.getString("GDBJtagDebuggerTab.gdbCommandBrowse_Title"), GDBJtagDebuggerTab.this.gdbCommand);
            }
        });
        button = new Button(comp, 0);
        button.setText(Messages.getString("GDBJtagDebuggerTab.gdbCommandVariable"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.variablesButtonSelected(GDBJtagDebuggerTab.this.gdbCommand);
            }
        });
    }

    private void createCommandFactoryControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.commandFactoryLabel"));
        this.commandFactory = new Combo(comp, 12);
        CommandFactoryManager cfManager = MIPlugin.getDefault().getCommandFactoryManager();
        this.cfDescs = cfManager.getDescriptors("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        int i = 0;
        while (i < this.cfDescs.length) {
            this.commandFactory.add(this.cfDescs[i].getName());
            ++i;
        }
        this.commandFactory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.commandFactoryChanged();
                GDBJtagDebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createProtocolControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.miProtocolLabel"));
        this.miProtocol = new Combo(comp, 12);
        this.miProtocol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void commandFactoryChanged() {
        int currsel = this.miProtocol.getSelectionIndex();
        String currProt = null;
        if (currsel >= 0) {
            currProt = this.miProtocol.getItem(currsel);
        }
        this.miProtocol.removeAll();
        int cfsel = this.commandFactory.getSelectionIndex();
        if (cfsel >= 0) {
            String[] protocols = this.cfDescs[cfsel].getMIVersions();
            int i = 0;
            while (i < protocols.length) {
                this.miProtocol.add(protocols[i]);
                if (currProt != null && protocols[i].equals(currProt)) {
                    this.miProtocol.select(i);
                }
                ++i;
            }
        }
        if (this.miProtocol.getSelectionIndex() < 0 && this.miProtocol.getItemCount() > 0) {
            this.miProtocol.select(0);
        }
    }

    private void createVerboseModeControl(Composite parent) {
        this.verboseMode = new Button(parent, 32);
        this.verboseMode.setText(Messages.getString("GDBJtagDebuggerTab.verboseModeLabel"));
        this.verboseMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("GDBJtagDebuggerTab.remoteGroup_Text"));
        this.useRemote = new Button((Composite)group, 32);
        this.useRemote.setText(Messages.getString("GDBJtagDebuggerTab.useRemote_Text"));
        this.useRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.useRemoteChanged();
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.jtagDeviceLabel"));
        this.jtagDevice = new Combo(comp, 12);
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int i = 0;
        while (i < availableDevices.length) {
            this.jtagDevice.add(availableDevices[i].getDeviceName());
            ++i;
        }
        this.jtagDevice.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.updateDeviceIpPort(GDBJtagDebuggerTab.this.jtagDevice.getText());
                GDBJtagDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.remoteConnectionParameters = new Composite((Composite)group, 524296);
        this.remoteConnectParmsLayout = new StackLayout();
        this.remoteConnectionParameters.setLayout((Layout)this.remoteConnectParmsLayout);
        this.remoteTcpipBox = new Composite(this.remoteConnectionParameters, 524296);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.remoteTcpipBox.setLayout((Layout)layout);
        this.remoteTcpipBox.setBackground(this.remoteConnectionParameters.getParent().getBackground());
        label = new Label(this.remoteTcpipBox, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.ipAddressLabel"));
        this.ipAddress = new Text(this.remoteTcpipBox, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.ipAddress.setLayoutData((Object)gd);
        label = new Label(this.remoteTcpipBox, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.portNumberLabel"));
        this.portNumber = new Text(this.remoteTcpipBox, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.portNumber.setLayoutData((Object)gd);
        this.remoteConnectionBox = new Composite(this.remoteConnectionParameters, 524296);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.remoteConnectionBox.setLayout((Layout)layout);
        this.remoteConnectionBox.setBackground(this.remoteConnectionParameters.getParent().getBackground());
        label = new Label(this.remoteConnectionBox, 0);
        label.setText(Messages.getString("GDBJtagDebuggerTab.connectionLabel"));
        this.connection = new Text(this.remoteConnectionBox, 2048);
        gd = new GridData();
        gd.widthHint = 125;
        this.connection.setLayoutData((Object)gd);
        this.ipAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.portNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.portNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.connection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    protected void updateDeviceIpPort(String selectedDeviceName) {
        if (selectedDeviceName.equals(this.savedJtagDevice)) {
            return;
        }
        GDBJtagDeviceContribution[] availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        IGDBJtagDevice selectedDevice = null;
        int i = 0;
        while (i < availableDevices.length) {
            String name = availableDevices[i].getDeviceName();
            if (name.equals(selectedDeviceName) && (selectedDevice = availableDevices[i].getDevice()) != null) {
                if (selectedDevice instanceof IGDBJtagConnection) {
                    IGDBJtagConnection connectionDevice = (IGDBJtagConnection)selectedDevice;
                    this.connection.setText(connectionDevice.getDefaultDeviceConnection());
                } else {
                    this.ipAddress.setText(selectedDevice.getDefaultIpAddress());
                    this.portNumber.setText(selectedDevice.getDefaultPortNumber());
                }
                this.useRemoteChanged();
                this.updateLaunchConfigurationDialog();
                break;
            }
            ++i;
        }
    }

    private void useRemoteChanged() {
        boolean enabled = this.useRemote.getSelection();
        this.jtagDevice.setEnabled(enabled);
        this.ipAddress.setEnabled(enabled);
        this.portNumber.setEnabled(enabled);
        this.connection.setEnabled(enabled);
        GDBJtagDeviceContribution selectedDeviceEntry = this.findJtagDeviceByName(this.jtagDevice.getText());
        if (selectedDeviceEntry == null || selectedDeviceEntry.getDevice() == null) {
            this.remoteConnectParmsLayout.topControl = null;
            this.remoteConnectionParameters.layout();
        } else {
            IGDBJtagDevice device = selectedDeviceEntry.getDevice();
            if (device instanceof IGDBJtagConnection) {
                this.remoteConnectParmsLayout.topControl = this.remoteConnectionBox;
                this.remoteConnectionBox.getParent().layout();
            } else {
                this.remoteConnectParmsLayout.topControl = this.remoteTcpipBox;
                this.remoteTcpipBox.getParent().layout();
            }
        }
    }

    private GDBJtagDeviceContribution findJtagDeviceByName(String name) {
        GDBJtagDeviceContribution[] availableDevices;
        GDBJtagDeviceContribution[] gDBJtagDeviceContributionArray = availableDevices = GDBJtagDeviceContributionFactory.getInstance().getGDBJtagDeviceContribution();
        int n = availableDevices.length;
        int n2 = 0;
        while (n2 < n) {
            GDBJtagDeviceContribution device = gDBJtagDeviceContributionArray[n2];
            if (device.getDeviceName().equals(name)) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block11: {
            try {
                String gdbCommandAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                this.gdbCommand.setText(gdbCommandAttr);
                CommandFactoryManager cfManager = MIPlugin.getDefault().getCommandFactoryManager();
                CommandFactoryDescriptor defDesc = cfManager.getDefaultDescriptor("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
                String commandFactoryAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, defDesc.getName());
                int cfid = 0;
                int i = 0;
                while (i < this.cfDescs.length) {
                    if (this.cfDescs[i].getName().equals(commandFactoryAttr)) {
                        cfid = i;
                        break;
                    }
                    ++i;
                }
                this.commandFactory.select(cfid);
                String miProtocolAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, defDesc.getMIVersions()[0]);
                int n = this.miProtocol.getItemCount();
                int i2 = 0;
                while (i2 < n) {
                    if (this.miProtocol.getItem(i2).equals(miProtocolAttr)) {
                        this.miProtocol.select(i2);
                    }
                    ++i2;
                }
                boolean verboseModeAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
                this.verboseMode.setSelection(verboseModeAttr);
                boolean useRemoteAttr = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
                this.useRemote.setSelection(useRemoteAttr);
                this.useRemoteChanged();
                this.savedJtagDevice = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "");
                if (this.savedJtagDevice.length() == 0) {
                    this.jtagDevice.select(0);
                    break block11;
                }
                String storedAddress = "";
                int storedPort = 0;
                String storedConnection = "";
                int i3 = 0;
                while (i3 < this.jtagDevice.getItemCount()) {
                    if (this.jtagDevice.getItem(i3).equals(this.savedJtagDevice)) {
                        storedAddress = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "unspecified-ip-address");
                        storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
                        storedConnection = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", "unspecified-ip-address:unspecified-port-number");
                        this.jtagDevice.select(i3);
                        break;
                    }
                    ++i3;
                }
                try {
                    this.connection.setText(new URI(storedConnection).getSchemeSpecificPart());
                }
                catch (URISyntaxException e) {
                    Activator.log((Throwable)e);
                }
                this.ipAddress.setText(storedAddress);
                String portString = storedPort > 0 && storedPort <= 65535 ? Integer.valueOf(storedPort).toString() : "";
                this.portNumber.setText(portString);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    public String getId() {
        return TAB_ID;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, this.gdbCommand.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.gdbCommand.getText().trim());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, this.commandFactory.getText());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, this.miProtocol.getText());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, this.verboseMode.getSelection());
        this.savedJtagDevice = this.jtagDevice.getText();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", this.savedJtagDevice);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", this.useRemote.getSelection());
        if (this.savedJtagDevice.length() > 0) {
            try {
                IGDBJtagDevice device = this.findJtagDeviceByName(this.jtagDevice.getText()).getDevice();
                if (device instanceof IGDBJtagConnection) {
                    String conn = this.connection.getText().trim();
                    URI uri = new URI("gdb", conn, "");
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.connection", uri.toString());
                } else {
                    String ip = this.ipAddress.getText().trim();
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
                    int port = Integer.valueOf(this.portNumber.getText().trim());
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port);
                }
            }
            catch (URISyntaxException e) {
                Activator.log((Throwable)e);
            }
            catch (NumberFormatException e) {
                Activator.log((Throwable)e);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        CommandFactoryManager cfManager = MIPlugin.getDefault().getCommandFactoryManager();
        CommandFactoryDescriptor defDesc = cfManager.getDefaultDescriptor("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, defDesc.getName());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, defDesc.getMIVersions()[0]);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
    }
}

