/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.event.ChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.CreatedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DisconnectedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ExitedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.MemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ResumedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.SuspendedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIStackInfoDepth;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MICreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorSignalExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackInfoDepthInfo;

public class EventManager
extends SessionObject
implements ICDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList(1));
    MIRunningEvent lastRunningEvent;
    Command lastUserCommand = null;
    boolean fAllowProcessingEvents = true;

    public void update(Observable o, Object arg) {
        MIEvent bpoint;
        MIEvent miEvent = (MIEvent)arg;
        Session session = (Session)this.getSession();
        Target currentTarget = session.getTarget(miEvent.getMISession());
        if (currentTarget == null) {
            return;
        }
        ArrayList<Object> cdiList = new ArrayList<Object>(1);
        if (miEvent instanceof MIStoppedEvent) {
            if (this.processSuspendedEvent((MIStoppedEvent)miEvent)) {
                cdiList.add(new SuspendedEvent(session, miEvent));
            }
        } else if (miEvent instanceof MIRunningEvent) {
            if (this.processRunningEvent((MIRunningEvent)miEvent)) {
                cdiList.add(new ResumedEvent(session, (MIRunningEvent)miEvent));
            }
        } else if (miEvent instanceof MIChangedEvent) {
            if (miEvent instanceof MIVarChangedEvent) {
                cdiList.add(new ChangedEvent(session, (MIVarChangedEvent)miEvent));
            } else if (miEvent instanceof MIRegisterChangedEvent) {
                cdiList.add(new ChangedEvent(session, (MIRegisterChangedEvent)miEvent));
            } else if (miEvent instanceof MIMemoryChangedEvent) {
                MemoryManager mgr = session.getMemoryManager();
                MemoryBlock[] blocks = mgr.getMemoryBlocks(miEvent.getMISession());
                MIMemoryChangedEvent miMem = (MIMemoryChangedEvent)miEvent;
                BigInteger[] addresses = miMem.getAddresses();
                int i = 0;
                while (i < blocks.length) {
                    if (blocks[i].contains(addresses) && (!blocks[i].isFrozen() || blocks[i].isDirty())) {
                        cdiList.add(new MemoryChangedEvent(session, blocks[i], miMem));
                        blocks[i].setDirty(false);
                    }
                    ++i;
                }
            } else if (miEvent instanceof MIBreakpointChangedEvent) {
                bpoint = (MIBreakpointChangedEvent)miEvent;
                if (((MIBreakpointChangedEvent)bpoint).getNumber() > 0) {
                    cdiList.add(new ChangedEvent(session, (MIBreakpointChangedEvent)bpoint));
                } else {
                    try {
                        session.getBreakpointManager().update(currentTarget, miEvent);
                    }
                    catch (CDIException cDIException) {}
                }
            } else if (miEvent instanceof MISharedLibChangedEvent) {
                cdiList.add(new ChangedEvent(session, (MISharedLibChangedEvent)miEvent));
            } else if (miEvent instanceof MISignalChangedEvent) {
                MISignalChangedEvent sig = (MISignalChangedEvent)miEvent;
                String name = sig.getName();
                if (name == null || name.length() == 0) {
                    try {
                        SignalManager sMgr = session.getSignalManager();
                        sMgr.update(currentTarget);
                    }
                    catch (CDIException cDIException) {}
                } else {
                    cdiList.add(new ChangedEvent(session, sig));
                }
            }
        } else if (miEvent instanceof MIDestroyedEvent) {
            if (miEvent instanceof MIThreadExitEvent) {
                cdiList.add(new DestroyedEvent(session, (MIThreadExitEvent)miEvent));
            } else if (miEvent instanceof MIInferiorSignalExitEvent) {
                cdiList.add(new ExitedEvent(session, (MIInferiorSignalExitEvent)miEvent));
            } else if (miEvent instanceof MIInferiorExitEvent) {
                cdiList.add(new ExitedEvent(session, (MIInferiorExitEvent)miEvent));
            } else if (miEvent instanceof MIGDBExitEvent) {
                Target target = session.getTarget(miEvent.getMISession());
                if (target != null) {
                    session.removeTargets(new Target[]{target});
                }
                cdiList.add(new ExitedEvent(session, (MIGDBExitEvent)miEvent));
            } else if (miEvent instanceof MIDetachedEvent) {
                cdiList.add(new DisconnectedEvent(session, (MIDetachedEvent)miEvent));
            } else if (miEvent instanceof MIBreakpointDeletedEvent) {
                bpoint = (MIBreakpointDeletedEvent)miEvent;
                if (((MIBreakpointDeletedEvent)bpoint).getNumber() > 0) {
                    cdiList.add(new DestroyedEvent(session, (MIBreakpointDeletedEvent)bpoint));
                } else {
                    try {
                        session.getBreakpointManager().update(currentTarget);
                    }
                    catch (CDIException cDIException) {}
                }
            } else if (miEvent instanceof MISharedLibUnloadedEvent) {
                this.processSharedLibUnloadedEvent((MISharedLibUnloadedEvent)miEvent);
                cdiList.add(new DestroyedEvent(session, (MISharedLibUnloadedEvent)miEvent));
            } else if (miEvent instanceof MIVarDeletedEvent) {
                cdiList.add(new DestroyedEvent(session, (MIVarDeletedEvent)miEvent));
            }
        } else if (miEvent instanceof MICreatedEvent) {
            if (miEvent instanceof MIBreakpointCreatedEvent) {
                bpoint = (MIBreakpointCreatedEvent)miEvent;
                if (((MIBreakpointCreatedEvent)bpoint).getNumber() > 0) {
                    cdiList.add(new CreatedEvent(session, (MIBreakpointCreatedEvent)bpoint));
                } else {
                    try {
                        session.getBreakpointManager().update(currentTarget);
                    }
                    catch (CDIException cDIException) {}
                }
            } else if (miEvent instanceof MIVarCreatedEvent) {
                cdiList.add(new CreatedEvent(session, (MIVarCreatedEvent)miEvent));
            } else if (miEvent instanceof MIRegisterCreatedEvent) {
                cdiList.add(new CreatedEvent(session, (MIRegisterCreatedEvent)miEvent));
            } else if (miEvent instanceof MIThreadCreatedEvent) {
                cdiList.add(new CreatedEvent(session, (MIThreadCreatedEvent)miEvent));
            } else if (miEvent instanceof MIMemoryCreatedEvent) {
                cdiList.add(new CreatedEvent(session, (MIMemoryCreatedEvent)miEvent));
            } else if (miEvent instanceof MISharedLibCreatedEvent) {
                cdiList.add(new CreatedEvent(session, (MISharedLibCreatedEvent)miEvent));
            } else if (miEvent instanceof MIInferiorCreatedEvent) {
                cdiList.add(new CreatedEvent(session, (MIInferiorCreatedEvent)miEvent));
            }
        }
        ICDIEvent[] cdiEvents = cdiList.toArray(new ICDIEvent[0]);
        this.fireEvents(cdiEvents);
    }

    public EventManager(Session session) {
        super(session);
    }

    public void addEventListener(ICDIEventListener listener) {
        this.list.add(listener);
    }

    public void removeEventListener(ICDIEventListener listener) {
        this.list.remove(listener);
    }

    public void removeEventListeners() {
        this.list.clear();
    }

    public void fireEvents(ICDIEvent[] cdiEvents) {
        if (cdiEvents != null && cdiEvents.length > 0) {
            ICDIEventListener[] listeners = this.list.toArray(new ICDIEventListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleDebugEvents(cdiEvents);
                ++i;
            }
        }
    }

    boolean processSuspendedEvent(MIStoppedEvent stopped) {
        Target currentTarget;
        Session session;
        block16: {
            session = (Session)this.getSession();
            MISession miSession = stopped.getMISession();
            currentTarget = session.getTarget(miSession);
            currentTarget.setSupended(true);
            if (!this.isAllowingProcessingEvents()) {
                return false;
            }
            if (this.processSharedLibEvent(stopped)) {
                return false;
            }
            if (this.processBreakpointHitEvent(stopped)) {
                return false;
            }
            int threadId = stopped.getThreadId();
            currentTarget.updateState(threadId);
            try {
                Thread cthread = (Thread)currentTarget.getCurrentThread();
                if (cthread != null) {
                    cthread.getCurrentStackFrame();
                    break block16;
                }
                return true;
            }
            catch (CDIException cDIException) {
                return true;
            }
        }
        VariableManager varMgr = session.getVariableManager();
        ExpressionManager expMgr = session.getExpressionManager();
        RegisterManager regMgr = session.getRegisterManager();
        MemoryManager memMgr = session.getMemoryManager();
        BreakpointManager bpMgr = session.getBreakpointManager();
        SignalManager sigMgr = session.getSignalManager();
        SourceManager srcMgr = session.getSourceManager();
        SharedLibraryManager libMgr = session.getSharedLibraryManager();
        try {
            if (varMgr.isAutoUpdate()) {
                varMgr.update(currentTarget);
            }
            if (expMgr.isAutoUpdate()) {
                expMgr.update(currentTarget);
            }
            if (regMgr.isAutoUpdate()) {
                regMgr.update(currentTarget);
            }
            if (memMgr.isAutoUpdate()) {
                memMgr.update(currentTarget);
            }
            if (bpMgr.isAutoUpdate()) {
                bpMgr.update(currentTarget);
            }
            if (sigMgr.isAutoUpdate()) {
                sigMgr.update(currentTarget);
            }
            if (libMgr.isAutoUpdate()) {
                libMgr.update(currentTarget);
            }
            if (srcMgr.isAutoUpdate()) {
                srcMgr.update(currentTarget);
            }
        }
        catch (CDIException e) {
            MIPlugin.log(e);
        }
        return true;
    }

    boolean processSharedLibUnloadedEvent(MISharedLibUnloadedEvent unLoaded) {
        Session session = (Session)this.getSession();
        MISession miSession = unLoaded.getMISession();
        Target target = session.getTarget(miSession);
        ExpressionManager expMgr = session.getExpressionManager();
        try {
            expMgr.deleteAllVariables(target);
        }
        catch (CDIException cDIException) {}
        return false;
    }

    boolean processSharedLibEvent(MIStoppedEvent stopped) {
        Session session = (Session)this.getSession();
        MISession miSession = stopped.getMISession();
        Target currentTarget = session.getTarget(miSession);
        SharedLibraryManager mgr = session.getSharedLibraryManager();
        if (mgr.isDeferredBreakpoint(currentTarget)) {
            if (stopped instanceof MISharedLibEvent) {
                int type;
                try {
                    mgr.update(currentTarget);
                }
                catch (CDIException cDIException) {}
                CommandFactory factory = miSession.getCommandFactory();
                int n = type = this.lastRunningEvent == null ? 0 : this.lastRunningEvent.getType();
                if (this.lastUserCommand == null) {
                    switch (type) {
                        case 1: {
                            this.lastUserCommand = factory.createMIExecNext(1);
                            break;
                        }
                        case 2: {
                            this.lastUserCommand = factory.createMIExecNextInstruction(1);
                            break;
                        }
                        case 3: {
                            this.lastUserCommand = factory.createMIExecStep(1);
                            break;
                        }
                        case 4: {
                            this.lastUserCommand = factory.createMIExecStepInstruction(1);
                            break;
                        }
                        case 5: {
                            this.lastUserCommand = factory.createMIExecFinish();
                            break;
                        }
                        case 7: {
                            this.lastUserCommand = factory.createMIExecReturn();
                            break;
                        }
                        case 0: {
                            MIExecContinue cont = factory.createMIExecContinue();
                            cont.setQuiet(true);
                            try {
                                miSession.postCommand(cont);
                                MIInfo info = cont.getMIInfo();
                            }
                            catch (MIException mIException) {}
                            return true;
                        }
                    }
                }
                int miLevel = 0;
                int tid = 0;
                Thread currentThread = null;
                try {
                    currentThread = (Thread)currentTarget.getCurrentThread();
                }
                catch (CDIException cDIException) {}
                tid = currentThread.getId();
                if (tid > 0) {
                    MIThreadSelect selectThread = factory.createMIThreadSelect(tid);
                    try {
                        miSession.postCommand(selectThread);
                    }
                    catch (MIException mIException) {}
                }
                StackFrame frame = null;
                try {
                    frame = currentThread.getCurrentStackFrame();
                }
                catch (CDIException cDIException) {}
                int count = 0;
                try {
                    MIStackInfoDepth depth = factory.createMIStackInfoDepth();
                    miSession.postCommand(depth);
                    MIStackInfoDepthInfo info = depth.getMIStackInfoDepthInfo();
                    count = info.getDepth();
                }
                catch (MIException mIException) {}
                if (frame != null) {
                    miLevel = count - frame.getLevel() - 1;
                }
                if (miLevel >= 0) {
                    MIStackSelectFrame selectFrame = factory.createMIStackSelectFrame(miLevel);
                    MIExecFinish finish = factory.createMIExecFinish();
                    finish.setQuiet(true);
                    try {
                        miSession.postCommand(selectFrame);
                        miSession.postCommand(finish);
                    }
                    catch (MIException mIException) {}
                } else {
                    Command cmd = this.lastUserCommand;
                    cmd.setQuiet(true);
                    this.lastUserCommand = null;
                    try {
                        miSession.postCommand(cmd);
                    }
                    catch (MIException mIException) {}
                }
                return true;
            }
            if (this.lastUserCommand != null) {
                Command cmd = this.lastUserCommand;
                cmd.setQuiet(true);
                this.lastUserCommand = null;
                try {
                    miSession.postCommand(cmd);
                }
                catch (MIException mIException) {}
                return true;
            }
        }
        return false;
    }

    boolean processBreakpointHitEvent(MIStoppedEvent stopped) {
        return false;
    }

    boolean processRunningEvent(MIRunningEvent running) {
        this.lastRunningEvent = running;
        Session session = (Session)this.getSession();
        MISession miSession = running.getMISession();
        Target currentTarget = session.getTarget(miSession);
        currentTarget.setSupended(false);
        return this.isAllowingProcessingEvents() && running.propagate();
    }

    public boolean isAllowingProcessingEvents() {
        return this.fAllowProcessingEvents;
    }

    public void allowProcessingEvents(boolean allowed) {
        this.fAllowProcessingEvents = allowed;
    }
}

