/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIWatchpointTriggerEvent
extends MIStoppedEvent {
    int number;
    String exp = "";
    String oldValue = "";
    String newValue = "";

    public MIWatchpointTriggerEvent(MISession source, MIExecAsyncOutput async) {
        super(source, async);
        this.parse();
    }

    public MIWatchpointTriggerEvent(MISession source, MIResultRecord record) {
        super(source, record);
        this.parse();
    }

    public int getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=").append(this.number).append('\n');
        buffer.append("expression=" + this.exp + "\n");
        buffer.append("old=" + this.oldValue + "\n");
        buffer.append("new=" + this.newValue + "\n");
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        MIFrame f = this.getFrame();
        if (f != null) {
            buffer.append(f.toString());
        }
        return buffer.toString();
    }

    void parse() {
        MIResult[] results = null;
        MIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        MIResultRecord rr = this.getMIResultRecord();
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                if (var.equals("wpt") || var.equals("hw-awpt") || var.equals("hw-rwpt")) {
                    if (value instanceof MITuple) {
                        this.parseWPT((MITuple)value);
                    }
                } else if (var.equals("value")) {
                    if (value instanceof MITuple) {
                        this.parseValue((MITuple)value);
                    }
                } else if (var.equals("thread-id")) {
                    if (value instanceof MIConst) {
                        String str = ((MIConst)value).getString();
                        try {
                            int id = Integer.parseInt(str.trim());
                            this.setThreadId(id);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("frame") && value instanceof MITuple) {
                    MIFrame f = new MIFrame((MITuple)value);
                    this.setFrame(f);
                }
                ++i;
            }
        }
    }

    void parseWPT(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (var.equals("number")) {
                if (value instanceof MIConst) {
                    String str = ((MIConst)value).getString();
                    try {
                        this.number = Integer.parseInt(str);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (var.equals("exp") && value instanceof MIConst) {
                this.exp = ((MIConst)value).getString();
            }
            ++i;
        }
    }

    void parseValue(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("old")) {
                this.oldValue = str;
            } else if (var.equals("new")) {
                this.newValue = str;
            } else if (var.equals("value")) {
                this.oldValue = this.newValue = str;
            }
            ++i;
        }
    }
}

