/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIShared;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIInfoSharedLibraryInfo
extends MIInfo {
    MIShared[] shared = new MIShared[0];

    public MIInfoSharedLibraryInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    private void parse() {
        if (this.isDone()) {
            ArrayList<MIShared> aList = new ArrayList<MIShared>();
            MIOutput out = this.getMIOutput();
            MIResultRecord rr = out.getMIResultRecord();
            if (rr != null) {
                MIResult[] results = rr.getMIResults();
                int i = 0;
                while (i < results.length) {
                    MIValue val;
                    String var = results[i].getVariable();
                    if (var.equals("shlib-info") && (val = results[i].getMIValue()) instanceof MITuple) {
                        MIResult[] libResults = ((MITuple)val).getMIResults();
                        String from = "";
                        String to = "";
                        boolean syms = true;
                        String name = "";
                        int j = 0;
                        while (j < libResults.length) {
                            if (libResults[j].getVariable().equals("description")) {
                                name = libResults[j].getMIValue().toString();
                            }
                            if (libResults[j].getVariable().equals("loaded_addr")) {
                                to = from = libResults[j].getMIValue().toString();
                            }
                            ++j;
                        }
                        MIShared s = new MIShared(from, to, syms, name);
                        aList.add(s);
                    }
                    ++i;
                }
            }
            this.shared = aList.toArray(new MIShared[aList.size()]);
        }
    }

    public MIShared[] getMIShared() {
        return this.shared;
    }
}

