/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.ui.console;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.GDBProcess;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.ui.console.VerboseModeChangedEvent;
import org.eclipse.cdt.debug.mi.ui.console.actions.MiConsoleSaveAction;
import org.eclipse.cdt.debug.mi.ui.console.actions.MiConsoleVerboseModeAction;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class MiConsolePageParticipant
implements IConsolePageParticipant,
IDebugEventSetListener,
Observer {
    private MiConsoleSaveAction fSaveConsole = null;
    private MiConsoleVerboseModeAction fVerboseMode = null;
    private IConsole fConsole = null;
    private GDBProcess GDBProcess = null;

    public void activated() {
    }

    public void deactivated() {
    }

    public void dispose() {
        if (this.GDBProcess != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }
        this.fSaveConsole = null;
        this.fVerboseMode = null;
        this.GDBProcess = null;
        this.fConsole = null;
    }

    public void init(IPageBookViewPage page, org.eclipse.ui.console.IConsole console) {
        if (console instanceof IConsole) {
            this.fConsole = (IConsole)console;
            if (this.fConsole.getProcess() instanceof GDBProcess) {
                this.GDBProcess = (GDBProcess)this.fConsole.getProcess();
                IActionBars bars = page.getSite().getActionBars();
                bars.getToolBarManager().appendToGroup("outputGroup", (IContributionItem)new Separator());
                this.fSaveConsole = new MiConsoleSaveAction(this.fConsole);
                bars.getToolBarManager().appendToGroup("outputGroup", (IAction)this.fSaveConsole);
                this.fVerboseMode = new MiConsoleVerboseModeAction(this.fConsole);
                bars.getToolBarManager().appendToGroup("outputGroup", (IAction)this.fVerboseMode);
                bars.getToolBarManager().appendToGroup("outputGroup", (IContributionItem)new Separator());
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
                this.fVerboseMode.updateStateAndEnablement();
                Target target = this.GDBProcess.getTarget();
                if (target != null) {
                    target.getMISession().addObserver((Observer)this);
                }
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.GDBProcess) && this.fVerboseMode != null) {
                this.fVerboseMode.updateStateAndEnablement();
                Target target = this.GDBProcess.getTarget();
                if (target != null) {
                    target.getMISession().addObserver((Observer)this);
                }
            }
            ++i;
        }
    }

    public void update(Observable arg0, Object arg1) {
        if (arg1 != null && arg1 instanceof VerboseModeChangedEvent && this.fVerboseMode != null) {
            try {
                this.fVerboseMode.updateStateAndEnablement();
            }
            catch (Exception exception) {}
        }
    }
}

