/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.memorybrowser;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.provisional.IMemoryRenderingViewportProvider;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlockRetrieval;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.GoToAddressBarWidget;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.MemoryBrowserPlugin;
import org.eclipse.cdt.debug.ui.memory.memorybrowser.Messages;
import org.eclipse.cdt.debug.ui.provisional.IRepositionableMemoryRendering2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.memory.MemoryRenderingManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBrowser
extends ViewPart
implements IDebugContextListener,
IMemoryRenderingSite,
IDebugEventSetListener {
    public static final String ID = "org.eclipse.cdt.debug.ui.memory.memorybrowser.MemoryBrowser";
    protected StackLayout fStackLayout;
    private Composite fRenderingsComposite;
    private GoToAddressBarWidget fGotoAddressBar;
    private DropTarget fDropTarget;
    private Control fGotoAddressBarControl;
    private Combo fGotoMemorySpaceControl;
    private Label fUnsupportedLabel;
    private Composite fMainComposite;
    private String defaultRenderingTypeId = null;
    private IMemoryRendering fActiveRendering;
    private Map<IMemoryBlockRetrieval, CTabFolder> fContextFolders = new HashMap<IMemoryBlockRetrieval, CTabFolder>();
    private List<IMemoryRenderingContainer> fCurrentContainers = new ArrayList<IMemoryRenderingContainer>();
    private static final String KEY_CONTEXT = "CONTEXT";
    private static final String KEY_CONTAINER = "CONTAINER";
    private static final String KEY_RENDERING_TYPE = "RENDERING_TYPE";
    private static final String KEY_RETRIEVAL = "RETRIEVAL";
    private static final String KEY_MEMORY_SPACE = "MEMORY_SPACE";
    private static final String KEY_RENDERINGS = "RENDERINGS";
    private static final String KEY_RENDERING = "RENDERING";
    private static final String KEY_MEMORY_BLOCKS = "MEMORY_BLOCKS";
    private static final String KEY_EXPRESSION = "EXPRESSION";
    public static final String PREF_DEFAULT_RENDERING = "org.eclipse.cdt.debug.ui.memory.memorybrowser.defaultRendering";
    private static final String NA_MEMORY_SPACE_ID = "   -----";

    public Control getControl() {
        return this.fMainComposite;
    }

    public void createPartControl(Composite parent) {
        IMemoryRenderingType[] types;
        boolean isDefaultRenderingAvailable = false;
        IPreferenceStore store = MemoryBrowserPlugin.getDefault().getPreferenceStore();
        String defaultRendering = store.getString(PREF_DEFAULT_RENDERING);
        if (defaultRendering == null || defaultRendering.trim().length() == 0) {
            defaultRendering = "org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRendering";
        }
        IMemoryRenderingType[] iMemoryRenderingTypeArray = types = this.getRenderingTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
            if (type.getId().equals(defaultRendering)) {
                isDefaultRenderingAvailable = true;
                break;
            }
            ++n2;
        }
        if (isDefaultRenderingAvailable) {
            this.defaultRenderingTypeId = defaultRendering;
        } else if (types.length > 0) {
            this.defaultRenderingTypeId = types[0].getId();
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new SelectionProviderAdapter());
        this.fMainComposite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.spacing = 0;
        this.fMainComposite.setLayout((Layout)layout);
        this.fGotoMemorySpaceControl = new Combo(this.fMainComposite, 12);
        this.fGotoAddressBar = new GoToAddressBarWidget();
        this.fGotoAddressBarControl = this.fGotoAddressBar.createControl(this.fMainComposite);
        if (this.fDropTarget == null) {
            this.fDropTarget = new DropTarget(this.fGotoAddressBarControl, 17);
            this.fDropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            this.fDropTarget.addDropListener((DropTargetListener)new MemoryDropAdapter());
        }
        this.fGotoAddressBar.getButton(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemoryBrowser.this.performGo(false);
            }
        });
        this.fGotoAddressBar.getButton(GoToAddressBarWidget.ID_GO_NEW_TAB).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemoryBrowser.this.performGo(true);
            }
        });
        this.fGotoAddressBar.getExpressionWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MemoryBrowser.this.performGo(false);
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryBrowser.this.performGo(false);
            }
        });
        this.fGotoMemorySpaceControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder activeFolder;
                if (MemoryBrowser.this.fGotoMemorySpaceControl.getItemCount() >= 2 && (activeFolder = (CTabFolder)MemoryBrowser.this.fStackLayout.topControl) != null) {
                    Object context = activeFolder.getData(MemoryBrowser.KEY_CONTEXT);
                    MemoryBrowser.this.fGotoAddressBar.loadSavedExpressions(context, MemoryBrowser.this.fGotoMemorySpaceControl.getText());
                }
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.fGotoMemorySpaceControl);
        data.right = new FormAttachment(100);
        this.fGotoAddressBarControl.setLayoutData((Object)data);
        this.fRenderingsComposite = new Composite(this.fMainComposite, 0);
        data = new FormData();
        data.top = new FormAttachment(this.fGotoAddressBarControl);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.fRenderingsComposite.setLayoutData((Object)data);
        this.fStackLayout = new StackLayout();
        this.fRenderingsComposite.setLayout((Layout)this.fStackLayout);
        this.fUnsupportedLabel = new Label(this.fRenderingsComposite, 0);
        this.fUnsupportedLabel.setText("");
        this.handleUnsupportedSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fMainComposite, "org.eclipse.cdt.debug.ui.memory.memorybrowser");
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        ISelection selection = null;
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow());
        if (this.isBug145635Patched()) {
            String presentationContextId = this.getPresentationContextId();
            contextService.addDebugContextListener((IDebugContextListener)this, presentationContextId);
            selection = contextService.getActiveContext(presentationContextId);
        } else {
            DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
            selection = contextService.getActiveContext(this.getSite().getId(), ((IViewSite)this.getSite()).getSecondaryId());
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        if (selection instanceof StructuredSelection) {
            this.handleDebugContextChanged(((StructuredSelection)selection).getFirstElement());
        }
    }

    private boolean isBug145635Patched() {
        Type[] managerTypes = DebugUITools.getDebugContextManager().getClass().getGenericInterfaces();
        int i = 0;
        while (i < managerTypes.length) {
            Class clazz;
            if (managerTypes[i] instanceof Class && "org.eclipse.debug.ui.contexts.IBug145635Marker".equals((clazz = (Class)managerTypes[i]).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clearExpressionHistoryForActiveTab() {
        CTabFolder activeFolder = (CTabFolder)this.fStackLayout.topControl;
        if (activeFolder != null) {
            Object context = activeFolder.getData(KEY_CONTEXT);
            this.fGotoAddressBar.clearExpressionHistory(context);
        }
    }

    private String getPresentationContextId() {
        IViewSite site = (IViewSite)this.getSite();
        return String.valueOf(site.getId()) + (site.getSecondaryId() != null ? ":" + site.getSecondaryId() : "");
    }

    public void dispose() {
        if (this.fDropTarget != null) {
            this.fDropTarget.dispose();
            this.fDropTarget = null;
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow());
        if (this.isBug145635Patched()) {
            String presentationContextId = this.getPresentationContextId();
            contextService.removeDebugContextListener((IDebugContextListener)this, presentationContextId);
        } else {
            DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
        }
        super.dispose();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (event.getKind() == 8 && source instanceof IMemoryBlockRetrieval) {
                this.releaseTabFolder((IMemoryBlockRetrieval)source);
            }
            ++n2;
        }
    }

    public IMemoryRenderingContainer getContainer(String id) {
        return null;
    }

    public IMemoryRenderingContainer[] getMemoryRenderingContainers() {
        IMemoryRenderingContainer[] containerList = new IMemoryRenderingContainer[this.fCurrentContainers.size()];
        int idx = 0;
        while (idx < this.fCurrentContainers.size()) {
            containerList[idx] = this.fCurrentContainers.get(idx);
            ++idx;
        }
        return containerList;
    }

    public IMemoryRenderingSynchronizationService getSynchronizationService() {
        return null;
    }

    private void handleUnsupportedSelection() {
        this.fStackLayout.topControl = this.fUnsupportedLabel;
        this.fGotoAddressBarControl.setVisible(false);
        this.fGotoMemorySpaceControl.setVisible(false);
    }

    private void performGo(boolean inNewTab) {
        String expression;
        String memorySpace = null;
        if (this.fGotoMemorySpaceControl.isVisible()) {
            memorySpace = this.fGotoMemorySpaceControl.getText();
            if (memorySpace.equals(NA_MEMORY_SPACE_ID)) {
                memorySpace = null;
            }
            assert (memorySpace == null || memorySpace.length() > 0);
        }
        if ((expression = this.fGotoAddressBar.getExpressionText()).length() > 0) {
            CTabFolder activeFolder = (CTabFolder)this.fStackLayout.topControl;
            Object context = null;
            if (activeFolder != null) {
                context = activeFolder.getData(KEY_CONTEXT);
            }
            this.fGotoAddressBar.addExpressionToHistory(context, expression, memorySpace);
            this.performGo(inNewTab, expression, memorySpace);
        }
    }

    public void performGo(boolean inNewTab, final String expression, final String memorySpaceId) {
        final CTabFolder activeFolder = (CTabFolder)this.fStackLayout.topControl;
        if (activeFolder != null) {
            final IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)activeFolder.getData(KEY_RETRIEVAL);
            final Object context = activeFolder.getData(KEY_CONTEXT);
            IMemoryRendering rendering = null;
            CTabItem item = activeFolder.getSelection();
            if (inNewTab || item == null) {
                try {
                    item = this.createTab(activeFolder, activeFolder.getSelectionIndex() + 1);
                    rendering = this.populateTabWithRendering(item, retrieval, context, memorySpaceId, expression);
                    this.fContextFolders.put(retrieval, activeFolder);
                    activeFolder.setSelection(item);
                    this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(item.getData(KEY_RENDERING)));
                    this.handleTabActivated(item);
                }
                catch (DebugException e1) {
                    this.fGotoAddressBar.handleExpressionStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", Messages.getString("MemoryBrowser.FailedToGoToAddressTitle"), (Throwable)e1));
                    if (item != null) {
                        item.dispose();
                    }
                    return;
                }
            }
            String oldMemorySpaceId = (String)activeFolder.getSelection().getData(KEY_MEMORY_SPACE);
            assert (oldMemorySpaceId == null || !oldMemorySpaceId.equals(NA_MEMORY_SPACE_ID)) : "should be null reference or an explicit, valid memory space ID (not including '----')";
            if (oldMemorySpaceId != null && !oldMemorySpaceId.equals(memorySpaceId) || oldMemorySpaceId == null && memorySpaceId != null) {
                try {
                    rendering = this.populateTabWithRendering(item, retrieval, context, memorySpaceId, expression);
                    activeFolder.setSelection(item);
                    this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(item.getData(KEY_RENDERING)));
                    this.handleTabActivated(item);
                }
                catch (DebugException e) {
                    this.fGotoAddressBar.handleExpressionStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", Messages.getString("MemoryBrowser.FailedToGoToAddressTitle"), (Throwable)e));
                    return;
                }
            }
            if (rendering == null) {
                rendering = (IRepositionableMemoryRendering)activeFolder.getSelection().getData(KEY_RENDERING);
            }
            if (retrieval instanceof IMemoryBlockRetrievalExtension && rendering instanceof IRepositionableMemoryRendering) {
                final IRepositionableMemoryRendering renderingFinal = (IRepositionableMemoryRendering)rendering;
                new Thread(){

                    public void run() {
                        try {
                            BigInteger newBase = MemoryBrowser.this.getExpressionAddress(retrieval, expression, context, memorySpaceId);
                            IMemoryBlockExtension block = (IMemoryBlockExtension)renderingFinal.getMemoryBlock();
                            if (block.supportBaseAddressModification()) {
                                block.setBaseAddress(newBase);
                            }
                            if (renderingFinal instanceof IRepositionableMemoryRendering2) {
                                ((IRepositionableMemoryRendering2)renderingFinal).goToAddress(newBase, expression);
                            } else {
                                renderingFinal.goToAddress(newBase);
                            }
                            MemoryBrowser.this.runOnUIThread(new Runnable(){

                                public void run() {
                                    CTabItem selection = activeFolder.getSelection();
                                    selection.setData(MemoryBrowser.KEY_EXPRESSION, (Object)expression);
                                    MemoryBrowser.this.fGotoAddressBar.handleExpressionStatus(Status.OK_STATUS);
                                    MemoryBrowser.this.updateLabel(selection, (IMemoryRendering)renderingFinal);
                                }
                            });
                        }
                        catch (DebugException e1) {
                            MemoryBrowser.this.runOnUIThread(new Runnable(){

                                public void run() {
                                    MemoryBrowser.this.fGotoAddressBar.handleExpressionStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", Messages.getString("MemoryBrowser.FailedToGoToAddressTitle"), (Throwable)e1));
                                }
                            });
                        }
                    }
                }.start();
            }
        }
    }

    private void updateLabel(CTabItem tab, IMemoryRendering rendering) {
        String label = rendering.getLabel();
        if (rendering instanceof IMemoryRenderingViewportProvider) {
            String newLabel;
            IMemoryBlock block;
            ILabelDecorator labelDec;
            IMemoryBlockRetrieval retrieval;
            BigInteger viewportAddress = ((IMemoryRenderingViewportProvider)rendering).getViewportAddress();
            String renderingType = null;
            int i = label.indexOf(60);
            if (i >= 0) {
                renderingType = label.substring(i);
            }
            label = null;
            String memorySpaceID = (String)tab.getData(KEY_MEMORY_SPACE);
            if (memorySpaceID != null && (retrieval = (IMemoryBlockRetrieval)tab.getParent().getData(KEY_RETRIEVAL)) instanceof IMemorySpaceAwareMemoryBlockRetrieval) {
                label = String.valueOf(((IMemorySpaceAwareMemoryBlockRetrieval)retrieval).encodeAddress("0x" + viewportAddress.toString(16), memorySpaceID)) + ' ' + renderingType;
            }
            if (label == null) {
                label = "0x" + viewportAddress.toString(16) + ' ' + renderingType;
            }
            if ((labelDec = (ILabelDecorator)(block = rendering.getMemoryBlock()).getAdapter(ILabelDecorator.class)) != null && (newLabel = labelDec.decorateText(label, (Object)rendering)) != null) {
                label = newLabel;
            }
        }
        tab.setText(label);
    }

    private CTabFolder createTabFolder(Composite parent) {
        final CTabFolder folder = new CTabFolder(parent, 0x900008);
        ColorRegistry reg = JFaceResources.getColorRegistry();
        Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        folder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        folder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        folder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        folder.setBorderVisible(true);
        folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = true;
                CTabItem item = (CTabItem)event.item;
                MemoryBrowser.this.disposeTab(item);
            }
        });
        folder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CTabItem[] cTabItemArray = folder.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem tab = cTabItemArray[n2];
                    MemoryBrowser.this.disposeTab(tab);
                    ++n2;
                }
                folder.removeDisposeListener((DisposeListener)this);
            }
        });
        return folder;
    }

    private static Map<String, IMemoryRendering> getRenderings(CTabItem tabItem) {
        return (Map)tabItem.getData(KEY_RENDERINGS);
    }

    private static List<IMemoryBlockExtension> getMemoryBlocks(CTabItem tabItem) {
        return (List)tabItem.getData(KEY_MEMORY_BLOCKS);
    }

    private void disposeTab(CTabItem item) {
        if (item.isDisposed()) {
            return;
        }
        IMemoryRenderingContainer container = (IMemoryRenderingContainer)item.getData(KEY_CONTAINER);
        this.fCurrentContainers.remove(container);
        Map<String, IMemoryRendering> map = MemoryBrowser.getRenderings(item);
        Collection<IMemoryRendering> renderings = map.values();
        for (IMemoryRendering rendering : renderings) {
            rendering.deactivated();
            rendering.dispose();
            if (rendering != this.fActiveRendering) continue;
            this.fActiveRendering = null;
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
        }
        map.clear();
        List<IMemoryBlockExtension> blocks = MemoryBrowser.getMemoryBlocks(item);
        for (IMemoryBlockExtension block : blocks) {
            try {
                block.dispose();
            }
            catch (DebugException e) {
                MemoryBrowserPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", "Could not dispose memory block", (Throwable)e));
            }
        }
        blocks.clear();
    }

    private CTabItem createTab(CTabFolder tabFolder, int index) {
        int swtStyle = 64;
        CTabItem tab = new CTabItem(tabFolder, swtStyle, index);
        tab.setData(KEY_RENDERINGS, new HashMap());
        tab.setData(KEY_MEMORY_BLOCKS, new ArrayList());
        return tab;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MemoryBrowser.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        MenuManager sub = new MenuManager(Messages.getString("MemoryBrowser.DefaultRendering"));
        IMemoryRenderingType[] iMemoryRenderingTypeArray = this.getRenderingTypes();
        int n = iMemoryRenderingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
            Action action = new Action(type.getLabel(), 8){

                public void run() {
                    MemoryBrowser.this.setDefaultRenderingTypeId(type.getId());
                }
            };
            action.setChecked(type.getId().equals(this.getDefaultRenderingTypeId()));
            sub.add((IAction)action);
            ++n2;
        }
        manager.add((IContributionItem)sub);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
    }

    private IMemoryRenderingType[] getRenderingTypes() {
        return MemoryRenderingManager.getDefault().getRenderingTypes((IMemoryBlock)new IMemoryBlockExtension(){

            public void connect(Object client) {
            }

            public void disconnect(Object client) {
            }

            public void dispose() throws DebugException {
            }

            public int getAddressSize() throws DebugException {
                return 0;
            }

            public int getAddressableSize() throws DebugException {
                return 0;
            }

            public BigInteger getBigBaseAddress() throws DebugException {
                return null;
            }

            public BigInteger getBigLength() throws DebugException {
                return null;
            }

            public MemoryByte[] getBytesFromAddress(BigInteger address, long units) throws DebugException {
                return null;
            }

            public MemoryByte[] getBytesFromOffset(BigInteger unitOffset, long addressableUnits) throws DebugException {
                return null;
            }

            public Object[] getConnections() {
                return null;
            }

            public String getExpression() {
                return null;
            }

            public BigInteger getMemoryBlockEndAddress() throws DebugException {
                return null;
            }

            public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
                return null;
            }

            public BigInteger getMemoryBlockStartAddress() throws DebugException {
                return null;
            }

            public void setBaseAddress(BigInteger address) throws DebugException {
            }

            public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
            }

            public boolean supportBaseAddressModification() throws DebugException {
                return false;
            }

            public boolean supportsChangeManagement() {
                return false;
            }

            public byte[] getBytes() throws DebugException {
                return null;
            }

            public long getLength() {
                return 0L;
            }

            public long getStartAddress() {
                return 0L;
            }

            public void setValue(long offset, byte[] bytes) throws DebugException {
            }

            public boolean supportsValueModification() {
                return false;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public ILaunch getLaunch() {
                return null;
            }

            public String getModelIdentifier() {
                return null;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        });
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.handleDebugContextChanged(((StructuredSelection)event.getContext()).getFirstElement());
    }

    public void handleDebugContextChanged(final Object context) {
        if (this.defaultRenderingTypeId == null) {
            return;
        }
        IAdaptable adaptable = null;
        IMemoryBlockRetrieval retrieval = null;
        ILaunch launch = null;
        if (context instanceof IAdaptable) {
            adaptable = (IAdaptable)context;
            retrieval = (IMemoryBlockRetrieval)adaptable.getAdapter(IMemoryBlockRetrieval.class);
            launch = (ILaunch)adaptable.getAdapter(ILaunch.class);
        }
        if (retrieval != null && launch != null && !launch.isTerminated()) {
            if (retrieval instanceof IMemorySpaceAwareMemoryBlockRetrieval) {
                final IMemoryBlockRetrieval _retrieval = retrieval;
                ((IMemorySpaceAwareMemoryBlockRetrieval)retrieval).getMemorySpaces(context, (IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest)new GetMemorySpacesRequest(){

                    public void done() {
                        MemoryBrowser.this.updateTab(_retrieval, context, this.isSuccess() ? this.getMemorySpaces() : new String[]{});
                    }
                });
            } else {
                this.updateTab(retrieval, context, new String[0]);
            }
        } else {
            this.handleUnsupportedSelection();
        }
        this.fGotoMemorySpaceControl.pack(true);
        this.fStackLayout.topControl.getParent().layout(true);
    }

    private void updateTab(final IMemoryBlockRetrieval retrieval, final Object context, final String[] memorySpaces) {
        this.runOnUIThread(new Runnable(){

            public void run() {
                if (MemoryBrowser.this.fGotoAddressBarControl.isDisposed()) {
                    return;
                }
                MemoryBrowser.this.fGotoAddressBarControl.setVisible(true);
                CTabFolder tabFolder = (CTabFolder)MemoryBrowser.this.fContextFolders.get(retrieval);
                if (tabFolder != null) {
                    MemoryBrowser.this.fStackLayout.topControl = tabFolder;
                    MemoryBrowser.this.handleTabActivated(tabFolder.getSelection());
                } else {
                    tabFolder = MemoryBrowser.this.createTabFolder(MemoryBrowser.this.fRenderingsComposite);
                    tabFolder.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            CTabItem tabItem = (CTabItem)e.item;
                            MemoryBrowser.this.updateExpression(tabItem);
                            MemoryBrowser.this.updateMemorySpaceControlSelection(tabItem);
                            MemoryBrowser.this.fGotoAddressBar.loadSavedExpressions(context, MemoryBrowser.this.fGotoMemorySpaceControl.isVisible() ? MemoryBrowser.this.fGotoMemorySpaceControl.getText() : null);
                            MemoryBrowser.this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(tabItem.getData(MemoryBrowser.KEY_RENDERING)));
                            MemoryBrowser.this.handleTabActivated(tabItem);
                        }
                    });
                    tabFolder.setData(MemoryBrowser.KEY_RETRIEVAL, (Object)retrieval);
                    MemoryBrowser.this.fContextFolders.put(retrieval, tabFolder);
                    MemoryBrowser.this.fStackLayout.topControl = tabFolder;
                    MemoryBrowser.this.fGotoAddressBar.setExpressionText("");
                    MemoryBrowser.this.fGotoAddressBar.loadSavedExpressions(context, MemoryBrowser.this.fGotoMemorySpaceControl.isVisible() ? MemoryBrowser.this.fGotoMemorySpaceControl.getText() : null);
                }
                tabFolder.setData(MemoryBrowser.KEY_CONTEXT, context);
                CTabFolder activeFolder = tabFolder;
                if (!activeFolder.equals(tabFolder)) {
                    return;
                }
                if (memorySpaces.length >= 2) {
                    MemoryBrowser.this.fGotoMemorySpaceControl.setItems(memorySpaces);
                    boolean addNA = true;
                    if (retrieval instanceof IMemorySpaceAwareMemoryBlockRetrieval) {
                        boolean bl = addNA = !((IMemorySpaceAwareMemoryBlockRetrieval)retrieval).creatingBlockRequiresMemorySpaceID();
                    }
                    if (addNA) {
                        MemoryBrowser.this.fGotoMemorySpaceControl.add(MemoryBrowser.NA_MEMORY_SPACE_ID, 0);
                    }
                    MemoryBrowser.this.setMemorySpaceControlVisible(true);
                } else {
                    MemoryBrowser.this.fGotoMemorySpaceControl.setItems(new String[0]);
                    MemoryBrowser.this.setMemorySpaceControlVisible(false);
                }
                MemoryBrowser.this.updateExpression(activeFolder.getSelection());
                MemoryBrowser.this.updateMemorySpaceControlSelection(activeFolder.getSelection());
                MemoryBrowser.this.fGotoAddressBar.loadSavedExpressions(context, MemoryBrowser.this.fGotoMemorySpaceControl.isVisible() ? MemoryBrowser.this.fGotoMemorySpaceControl.getText() : null);
                MemoryBrowser.this.fStackLayout.topControl.getParent().layout(true);
            }
        });
    }

    protected void updateExpression(CTabItem activeFolder) {
        String expression;
        String string = expression = activeFolder != null ? (String)activeFolder.getData(KEY_EXPRESSION) : null;
        if (expression != null) {
            this.fGotoAddressBar.setExpressionText(expression);
        }
    }

    protected final void handleTabActivated(CTabItem item) {
        if (item != null) {
            this.updateActiveRendering((IMemoryRendering)item.getData(KEY_RENDERING));
        }
    }

    private void updateActiveRendering(IMemoryRendering rendering) {
        if (this.fActiveRendering == rendering) {
            return;
        }
        if (this.fActiveRendering != null) {
            this.fActiveRendering.deactivated();
            this.fActiveRendering.becomesHidden();
        }
        if (rendering != null) {
            rendering.activated();
            rendering.becomesVisible();
        }
        this.fActiveRendering = rendering;
    }

    private void setMemorySpaceControlVisible(boolean visible) {
        FormData data = (FormData)this.fGotoAddressBarControl.getLayoutData();
        data.left = visible ? new FormAttachment((Control)this.fGotoMemorySpaceControl) : new FormAttachment(0);
        this.fGotoMemorySpaceControl.setVisible(visible);
    }

    private void updateMemorySpaceControlSelection(CTabItem item) {
        String[] memorySpaces = this.fGotoMemorySpaceControl.getItems();
        if (memorySpaces.length > 0) {
            String currentMemorySpace;
            boolean foundIt = false;
            if (item != null && (currentMemorySpace = (String)item.getData(KEY_MEMORY_SPACE)) != null) {
                assert (currentMemorySpace.length() > 0);
                String[] stringArray = memorySpaces;
                int n = memorySpaces.length;
                int n2 = 0;
                while (n2 < n) {
                    String memorySpace = stringArray[n2];
                    if (memorySpace.equals(currentMemorySpace)) {
                        foundIt = true;
                        this.fGotoMemorySpaceControl.setText(currentMemorySpace);
                        break;
                    }
                    ++n2;
                }
            }
            if (!foundIt) {
                this.fGotoMemorySpaceControl.select(0);
                if (item != null) {
                    item.setData(KEY_MEMORY_SPACE, null);
                }
            }
            this.fGotoMemorySpaceControl.setVisible(true);
        } else {
            this.fGotoMemorySpaceControl.setVisible(false);
        }
        this.fGotoMemorySpaceControl.getParent().layout(true);
    }

    private String getDefaultRenderingTypeId() {
        return this.defaultRenderingTypeId;
    }

    public void setDefaultRenderingTypeId(String id) {
        this.defaultRenderingTypeId = id;
        IPreferenceStore store = MemoryBrowserPlugin.getDefault().getPreferenceStore();
        store.setValue(PREF_DEFAULT_RENDERING, this.defaultRenderingTypeId);
    }

    private IMemoryRendering populateTabWithRendering(CTabItem tab, IMemoryBlockRetrieval retrieval, Object context, String memorySpaceId, String expression) throws DebugException {
        IMemoryRendering rendering;
        IMemoryRenderingType type = DebugUITools.getMemoryRenderingManager().getRenderingType(this.getDefaultRenderingTypeId());
        IMemoryRenderingContainer container = (IMemoryRenderingContainer)tab.getData(KEY_CONTAINER);
        if (container == null) {
            container = new MemoryBrowserRenderingContainer();
            this.fCurrentContainers.add(container);
        }
        if ((rendering = MemoryBrowser.getRenderings(tab).get(memorySpaceId)) == null) {
            IMemoryBlockExtension block = this.createMemoryBlock(retrieval, expression, context, memorySpaceId);
            try {
                rendering = type.createRendering();
            }
            catch (CoreException e) {
                MemoryBrowserPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", "", (Throwable)e));
                return null;
            }
            rendering.init(container, (IMemoryBlock)block);
            container.addMemoryRendering(rendering);
            rendering.createControl((Composite)tab.getParent());
            MemoryBrowser.getRenderings(tab).put(memorySpaceId, rendering);
            MemoryBrowser.getMemoryBlocks(tab).add(block);
            rendering.addPropertyChangeListener((IPropertyChangeListener)new RenderingPropertyChangeListener(tab, rendering));
        }
        tab.setControl(rendering.getControl());
        tab.getParent().setSelection(0);
        tab.setData(KEY_RENDERING, (Object)rendering);
        tab.setData(KEY_MEMORY_SPACE, (Object)memorySpaceId);
        tab.setData(KEY_CONTAINER, (Object)container);
        tab.setData(KEY_RENDERING_TYPE, (Object)type);
        this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(tab.getData(KEY_RENDERING)));
        this.updateLabel(tab, rendering);
        return rendering;
    }

    private void releaseTabFolder(final IMemoryBlockRetrieval retrieval) {
        final CTabFolder folder = this.fContextFolders.get(retrieval);
        if (folder != null) {
            Runnable run = new Runnable(){

                public void run() {
                    CTabItem[] cTabItemArray = folder.getItems();
                    int n = cTabItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CTabItem tab = cTabItemArray[n2];
                        MemoryBrowser.this.disposeTab(tab);
                        ++n2;
                    }
                    MemoryBrowser.this.fContextFolders.remove(retrieval);
                    folder.dispose();
                    if (MemoryBrowser.this.fStackLayout.topControl.equals(folder)) {
                        MemoryBrowser.this.handleUnsupportedSelection();
                    }
                }
            };
            this.runOnUIThread(run);
        }
    }

    private IMemoryBlockExtension createMemoryBlock(IMemoryBlockRetrieval retrieval, String expression, Object context, String memorySpaceID) throws DebugException {
        Object block = null;
        IMemoryBlockRetrievalExtension retrievalExtension = null;
        if (retrieval instanceof IMemoryBlockRetrievalExtension) {
            retrievalExtension = (IMemoryBlockRetrievalExtension)retrieval;
        } else if (retrieval instanceof IAdaptable) {
            retrievalExtension = (IMemoryBlockRetrievalExtension)((IAdaptable)retrieval).getAdapter(IMemoryBlockRetrievalExtension.class);
        }
        if (retrievalExtension != null) {
            block = retrievalExtension instanceof IMemorySpaceAwareMemoryBlockRetrieval ? ((IMemorySpaceAwareMemoryBlockRetrieval)retrievalExtension).getMemoryBlock(expression, context, memorySpaceID) : retrievalExtension.getExtendedMemoryBlock(expression, context);
        }
        if (block == null) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.debug.ui.memory.memorybrowser", "Extended Memory Block could not be obtained"));
        }
        return block;
    }

    private BigInteger getExpressionAddress(IMemoryBlockRetrieval retrieval, String expression, Object context, String memorySpaceId) throws DebugException {
        IMemoryBlockExtension newBlock = this.createMemoryBlock(retrieval, expression, context, memorySpaceId);
        BigInteger address = newBlock.getBigBaseAddress();
        newBlock.dispose();
        return address;
    }

    private void runOnUIThread(final Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            UIJob job = new UIJob("Memory Browser UI Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    runnable.run();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private class GetMemorySpacesRequest
    extends CRequest
    implements IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest {
        String[] fMemorySpaces;

        private GetMemorySpacesRequest() {
        }

        public String[] getMemorySpaces() {
            return this.fMemorySpaces;
        }

        public void setMemorySpaces(String[] memorySpaceIds) {
            this.fMemorySpaces = memorySpaceIds;
        }
    }

    private final class MemoryBrowserRenderingContainer
    implements IMemoryRenderingContainer {
        private final List<IMemoryRendering> renderings = new ArrayList<IMemoryRendering>();

        private MemoryBrowserRenderingContainer() {
        }

        public void addMemoryRendering(IMemoryRendering rendering) {
            if (!this.renderings.contains(rendering)) {
                this.renderings.add(rendering);
            }
        }

        public IMemoryRendering getActiveRendering() {
            return this.renderings.isEmpty() ? null : this.renderings.get(this.renderings.size() - 1);
        }

        public String getId() {
            return "???";
        }

        public String getLabel() {
            IMemoryRendering rendering = this.getActiveRendering();
            return rendering != null ? rendering.getLabel() : null;
        }

        public IMemoryRenderingSite getMemoryRenderingSite() {
            return MemoryBrowser.this;
        }

        public IMemoryRendering[] getRenderings() {
            return this.renderings.toArray(new IMemoryRendering[this.renderings.size()]);
        }

        public void removeMemoryRendering(IMemoryRendering rendering) {
            this.renderings.remove(rendering);
        }
    }

    private class MemoryDropAdapter
    extends DropTargetAdapter {
        private MemoryDropAdapter() {
        }

        public void drop(DropTargetEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof String) {
                MemoryBrowser.this.fGotoAddressBar.setExpressionText((String)event.data);
                MemoryBrowser.this.performGo(false);
            }
        }

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
            event.feedback = 0;
        }
    }

    private final class RenderingPropertyChangeListener
    implements IPropertyChangeListener {
        private final CTabItem tab;
        private final IMemoryRendering newRendering;

        private RenderingPropertyChangeListener(CTabItem tab, IMemoryRendering newRendering) {
            this.tab = tab;
            this.newRendering = newRendering;
        }

        public void propertyChange(final PropertyChangeEvent event) {
            WorkbenchJob job = new WorkbenchJob("MemoryBrowser PropertyChanged"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (RenderingPropertyChangeListener.this.tab.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    if (event.getProperty().equals("org.eclipse.jface.text")) {
                        MemoryBrowser.this.updateLabel(RenderingPropertyChangeListener.this.tab, RenderingPropertyChangeListener.this.newRendering);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    class SelectionProviderAdapter
    implements ISelectionProvider {
        List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        ISelection theSelection = StructuredSelection.EMPTY;

        SelectionProviderAdapter() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public ISelection getSelection() {
            return this.theSelection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            this.theSelection = selection;
            final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] listenersArray = this.listeners.toArray();
            int i = 0;
            while (i < listenersArray.length) {
                final ISelectionChangedListener l = (ISelectionChangedListener)listenersArray[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(e);
                    }
                });
                ++i;
            }
        }
    }
}

