/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class RestoreDefaultTypeActionHandler
extends AbstractHandler {
    private ICastToType[] fCastableItems = new ICastToType[0];
    private IStatus fStatus = null;

    protected ICastToType[] getCastToType() {
        return this.fCastableItems;
    }

    protected void setCastToType(ICastToType[] castableItems) {
        this.fCastableItems = castableItems;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getCastToType() == null || this.getCastToType().length == 0) {
            return null;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    RestoreDefaultTypeActionHandler.this.doAction(RestoreDefaultTypeActionHandler.this.getCastToType());
                    RestoreDefaultTypeActionHandler.this.setStatus(null);
                }
                catch (DebugException e) {
                    RestoreDefaultTypeActionHandler.this.setStatus(e.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog(ActionMessages.getString("RestoreDefaultTypeActionDelegate.0"), this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        ICastToType[] castableItems = this.getCastToType(evaluationContext);
        this.setBaseEnabled(castableItems.length > 0);
        this.setCastToType(castableItems);
    }

    private ICastToType[] getCastToType(Object evaluationContext) {
        Object s;
        ArrayList<ICastToType> castableItems = new ArrayList<ICastToType>();
        if (evaluationContext instanceof IEvaluationContext && (s = ((IEvaluationContext)evaluationContext).getVariable("activeMenuSelection")) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)s).iterator();
            while (iter.hasNext()) {
                Object element = DebugPlugin.getAdapter(iter.next(), ICastToType.class);
                if (!(element instanceof ICastToType) || !((ICastToType)element).isCasted()) continue;
                castableItems.add((ICastToType)element);
            }
        }
        return castableItems.toArray(new ICastToType[castableItems.size()]);
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected void doAction(ICastToType[] castableItems) throws DebugException {
        ICastToType[] iCastToTypeArray = castableItems;
        int n = castableItems.length;
        int n2 = 0;
        while (n2 < n) {
            ICastToType castableItem = iCastToTypeArray[n2];
            castableItem.restoreOriginal();
            ++n2;
        }
    }
}

