/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlockRetrieval;
import org.eclipse.cdt.debug.internal.core.CMemoryBlockRetrievalExtension;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.debug.internal.core.model.CRegister;
import org.eclipse.cdt.debug.internal.ui.views.memory.AddMemoryBlockDialog;
import org.eclipse.cdt.debug.internal.ui.views.memory.Messages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryBlockAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IAddMemoryBlocksTarget;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

public class AddMemoryBlocks
implements IAddMemoryBlocksTarget {
    public void addMemoryBlocks(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (!(part instanceof IMemoryRenderingSite)) {
            assert (false) : "unexpected kind of view part";
            return;
        }
        final IMemoryRenderingSite renderingSite = (IMemoryRenderingSite)part;
        IAdaptable debugViewElement = DebugUITools.getDebugContext();
        IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)debugViewElement.getAdapter(IMemoryBlockRetrieval.class);
        if (retrieval == null && debugViewElement instanceof IDebugElement) {
            retrieval = ((IDebugElement)debugViewElement).getDebugTarget();
        }
        if (!(retrieval instanceof IMemorySpaceAwareMemoryBlockRetrieval)) {
            this.invokePlatformAction(renderingSite);
            return;
        }
        final IMemorySpaceAwareMemoryBlockRetrieval msRetrieval = (IMemorySpaceAwareMemoryBlockRetrieval)retrieval;
        final Object context = AddMemoryBlocks.getContextSelectionForPart(part);
        Job job = new Job("update memory space choices"){

            protected IStatus run(IProgressMonitor monitor) {
                msRetrieval.getMemorySpaces(context, (IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest)new GetMemorySpacesRequest(){

                    public void done() {
                        AddMemoryBlocks.this.runOnUIThread(new Runnable(){

                            public void run() {
                                String[] memorySpaces;
                                if (this.isSuccess() && (memorySpaces = this.getMemorySpaces()).length >= 2) {
                                    AddMemoryBlocks.this.doAddMemoryBlocks(renderingSite, context, msRetrieval, memorySpaces);
                                    return;
                                }
                                AddMemoryBlocks.this.invokePlatformAction(renderingSite);
                            }
                        });
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    void invokePlatformAction(IMemoryRenderingSite site) {
        class PlatformAction
        extends AddMemoryBlockAction {
            PlatformAction(IMemoryRenderingSite site) {
                super(site);
            }

            protected void dispose() {
                super.dispose();
            }
        }
        PlatformAction action = new PlatformAction(site);
        action.run();
        action.dispose();
    }

    private void doAddMemoryBlocks(final IMemoryRenderingSite renderingSite, final Object context, final IMemorySpaceAwareMemoryBlockRetrieval retrieval, String[] memorySpaces) {
        Shell shell = CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        AddMemoryBlockDialog dialog = new AddMemoryBlockDialog(shell, memorySpaces);
        dialog.open();
        int returnCode = dialog.getReturnCode();
        if (returnCode == 1) {
            return;
        }
        String input = dialog.enteredExpression() ? dialog.getExpression() : dialog.getAddress();
        ArrayList<String> list = new ArrayList<String>();
        if (input.length() == 0) {
            list.add("");
        } else {
            StringTokenizer tokenizer = new StringTokenizer(input, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        String[] addrsOrExprs = list.toArray(new String[list.size()]);
        ParamHolder params = dialog.enteredExpression() ? new ExpressionsHolder(addrsOrExprs) : new AddressAndSpaceHolder(addrsOrExprs, dialog.getMemorySpace());
        final ExpressionsHolder params_f = params;
        Job job = new Job("Add Memory Block"){

            protected IStatus run(IProgressMonitor monitor) {
                AddMemoryBlocks.this.addMemoryBlocks(context, retrieval, params_f, renderingSite);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean canAddMemoryBlocks(IWorkbenchPart part, ISelection selection) throws CoreException {
        return true;
    }

    public boolean supportsAddMemoryBlocks(IWorkbenchPart part) {
        return "org.eclipse.debug.ui.MemoryView".equals(part.getSite().getId());
    }

    private void addMemoryBlocks(Object context, IMemorySpaceAwareMemoryBlockRetrieval memRetrieval, ParamHolder params, IMemoryRenderingSite memRendSite) {
        String[] addrsOrExprs = params instanceof AddressAndSpaceHolder ? ((AddressAndSpaceHolder)params).addresses : ((ExpressionsHolder)params).expressions;
        int i = 0;
        while (i < addrsOrExprs.length) {
            String addrOrExpr = addrsOrExprs[i].trim();
            try {
                Object memBlock = params instanceof AddressAndSpaceHolder ? memRetrieval.getMemoryBlock(addrOrExpr, context, ((AddressAndSpaceHolder)params).memorySpace) : memRetrieval.getExtendedMemoryBlock(addrOrExpr, context);
                if (memBlock != null) {
                    IMemoryBlock[] memArray = new IMemoryBlock[]{memBlock};
                    DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(memArray);
                    this.addDefaultRenderings((IMemoryBlock)memBlock, memRendSite);
                } else {
                    AddMemoryBlocks.openError(Messages.AddMemBlocks_title, Messages.AddMemBlocks_noMemoryBlock, null);
                }
            }
            catch (DebugException e1) {
                AddMemoryBlocks.openError(Messages.AddMemBlocks_title, Messages.AddMemBlocks_failed, (Exception)((Object)e1));
            }
            catch (NumberFormatException numberFormatException) {
                String message = String.valueOf(Messages.AddMemBlocks_failed) + "\n" + Messages.AddMemBlocks_input_invalid;
                AddMemoryBlocks.openError(Messages.AddMemBlocks_title, message, null);
            }
            ++i;
        }
    }

    private void addDefaultRenderings(IMemoryBlock memoryBlock, IMemoryRenderingSite memRendSite) {
        IMemoryRenderingType primaryType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType(memoryBlock);
        IMemoryRenderingType[] renderingTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes(memoryBlock);
        try {
            if (primaryType != null) {
                this.createRenderingInContainer(memoryBlock, memRendSite, primaryType, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            } else if (renderingTypes.length > 0) {
                primaryType = renderingTypes[0];
                this.createRenderingInContainer(memoryBlock, memRendSite, renderingTypes[0], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            }
        }
        catch (CoreException e1) {
            CDebugUIPlugin.log(e1);
        }
        int i = 0;
        while (i < renderingTypes.length) {
            try {
                boolean create = true;
                if (primaryType != null && primaryType.getId().equals(renderingTypes[i].getId())) {
                    create = false;
                }
                if (create) {
                    this.createRenderingInContainer(memoryBlock, memRendSite, renderingTypes[i], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2");
                }
            }
            catch (CoreException e) {
                CDebugUIPlugin.log(e);
            }
            ++i;
        }
    }

    private void createRenderingInContainer(IMemoryBlock memoryBlock, IMemoryRenderingSite memRendSite, IMemoryRenderingType primaryType, String paneId) throws CoreException {
        IMemoryRendering rendering = primaryType.createRendering();
        IMemoryRenderingContainer container = memRendSite.getContainer(paneId);
        rendering.init(container, memoryBlock);
        container.addMemoryRendering(rendering);
    }

    public void addMemoryBlocksForVariables(ICVariable[] variables, IMemoryRenderingSite memSite) throws DebugException {
        IAdaptable debugViewElement = DebugUITools.getDebugContext();
        CMemoryBlockRetrievalExtension cdtRetrieval = null;
        IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)debugViewElement.getAdapter(IMemoryBlockRetrieval.class);
        if (retrieval == null && debugViewElement instanceof IDebugElement) {
            retrieval = ((IDebugElement)debugViewElement).getDebugTarget();
        }
        if (retrieval == null || !(retrieval instanceof CMemoryBlockRetrievalExtension)) {
            return;
        }
        cdtRetrieval = (CMemoryBlockRetrievalExtension)retrieval;
        String[] expressions = new String[variables.length];
        int i = 0;
        while (i < variables.length) {
            String exp = variables[i].getExpressionString();
            expressions[i] = variables[i].getType().isPointer() || variables[i].getType().isArray() || variables[i].getType().isReference() || variables[i] instanceof CRegister ? exp : "&" + exp;
            ++i;
        }
        ExpressionsHolder params = new ExpressionsHolder(expressions);
        final IAdaptable debugViewElement_f = debugViewElement;
        final CMemoryBlockRetrievalExtension retrieval_f = cdtRetrieval;
        final ExpressionsHolder params_f = params;
        final IMemoryRenderingSite memRendSite = memSite;
        Job job = new Job("Add Memory Block"){

            protected IStatus run(IProgressMonitor monitor) {
                AddMemoryBlocks.this.addMemoryBlocks(debugViewElement_f, (IMemorySpaceAwareMemoryBlockRetrieval)retrieval_f, params_f, memRendSite);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public static void openError(final String title, final String message, final Exception e) {
        UIJob uiJob = new UIJob("open error"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String detail = "";
                if (e != null) {
                    detail = e.getMessage();
                }
                Shell shell = CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(message) + "\n" + detail));
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    private static Object getContextSelectionForPart(IWorkbenchPart part) {
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow());
        ISelection debugContext = contextService.getActiveContext(AddMemoryBlocks.getPartId(part));
        if (debugContext == null) {
            debugContext = contextService.getActiveContext();
        }
        if (debugContext instanceof IStructuredSelection) {
            return ((IStructuredSelection)debugContext).getFirstElement();
        }
        return null;
    }

    private static String getPartId(IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            IViewSite site = (IViewSite)part.getSite();
            return String.valueOf(site.getId()) + (site.getSecondaryId() != null ? ":" + site.getSecondaryId() : "");
        }
        return part.getSite().getId();
    }

    private void runOnUIThread(final Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            UIJob job = new UIJob("Memory Browser UI Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    runnable.run();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    class AddressAndSpaceHolder
    extends ParamHolder {
        public String[] addresses;
        public String memorySpace;

        public AddressAndSpaceHolder(String[] addresses, String memorySpace) {
            this.addresses = addresses;
            this.memorySpace = memorySpace;
        }
    }

    private class ExpressionsHolder
    extends ParamHolder {
        public String[] expressions;

        public ExpressionsHolder(String[] expressions) {
            this.expressions = expressions;
        }
    }

    private static class GetMemorySpacesRequest
    extends CRequest
    implements IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest {
        String[] fMemorySpaces = new String[0];

        private GetMemorySpacesRequest() {
        }

        public String[] getMemorySpaces() {
            return this.fMemorySpaces;
        }

        public void setMemorySpaces(String[] memorySpaceIds) {
            this.fMemorySpaces = memorySpaceIds;
        }
    }

    private class ParamHolder {
        private ParamHolder() {
        }
    }
}

