/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.actions.IConnect;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.ProcessInfo;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.ProcessPrompter;
import org.eclipse.cdt.dsf.gdb.launching.IProcessExtendedInfo;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class GdbConnectCommand
implements IConnect {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private Map<String, String> fProcessNameToBinaryMap = new HashMap<String, String>();

    public GdbConnectCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean canConnect() {
        Query<Boolean> canConnectQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                if (procService != null && commandControl != null) {
                    procService.isDebuggerAttachSupported((IDMContext)commandControl.getContext(), rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canConnectQuery);
            return (Boolean)canConnectQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    public void connect(RequestMonitor requestMonitor) {
        final RequestMonitor rm = requestMonitor == null ? new RequestMonitor((Executor)this.fExecutor, null) : requestMonitor;
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                final IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                if (procService != null && commandControl != null) {
                    final ICommandControlService.ICommandControlDMContext controlCtx = commandControl.getContext();
                    procService.isDebugNewProcessSupported((IDMContext)controlCtx, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)GdbConnectCommand.this.fExecutor, null){

                        protected void handleCompleted() {
                            final boolean newProcessSupported = this.isSuccess() && (Boolean)this.getData() != false;
                            procService.getRunningProcesses((IDMContext)controlCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IProcessDMContext[]>((Executor)GdbConnectCommand.this.fExecutor, rm){

                                protected void handleSuccess() {
                                    final ArrayList<ProcessInfo> procInfoList = new ArrayList<ProcessInfo>();
                                    final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)GdbConnectCommand.this.fExecutor, rm){

                                        protected void handleSuccess() {
                                            new PromptForPidJob("Prompt for Process", newProcessSupported, procInfoList.toArray(new IProcessExtendedInfo[0]), new DataRequestMonitor<Object>((Executor)GdbConnectCommand.this.fExecutor, rm){

                                                protected void handleCancel() {
                                                    rm.cancel();
                                                    rm.done();
                                                }

                                                protected void handleSuccess() {
                                                    IGDBProcesses procService = (IGDBProcesses)GdbConnectCommand.this.fTracker.getService(IGDBProcesses.class);
                                                    if (procService != null) {
                                                        Object data = this.getData();
                                                        if (data instanceof String) {
                                                            String binaryPath = (String)data;
                                                            procService.debugNewProcess((IDMContext)controlCtx, binaryPath, new HashMap(), new DataRequestMonitor((Executor)GdbConnectCommand.this.fExecutor, rm));
                                                        } else if (data instanceof IProcessExtendedInfo) {
                                                            IProcessExtendedInfo process = (IProcessExtendedInfo)data;
                                                            String pidStr = Integer.toString(process.getPid());
                                                            IGDBBackend backend = (IGDBBackend)GdbConnectCommand.this.fTracker.getService(IGDBBackend.class);
                                                            if (backend != null && backend.getSessionType() == SessionType.REMOTE) {
                                                                IPath binaryPath;
                                                                if (GdbConnectCommand.this.fProcessNameToBinaryMap.isEmpty() && (binaryPath = backend.getProgramPath()) != null && !binaryPath.isEmpty()) {
                                                                    GdbConnectCommand.this.fProcessNameToBinaryMap.put(binaryPath.lastSegment(), binaryPath.toOSString());
                                                                }
                                                                Path processPath = new Path(process.getName());
                                                                String processShortName = processPath.lastSegment();
                                                                new PromptAndAttachToProcessJob(pidStr, processShortName, rm).schedule();
                                                            } else {
                                                                IProcesses.IProcessDMContext procDmc = procService.createProcessContext(controlCtx, pidStr);
                                                                procService.attachDebuggerToProcess(procDmc, null, new DataRequestMonitor((Executor)GdbConnectCommand.this.fExecutor, rm));
                                                            }
                                                        } else {
                                                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Invalid return type for process prompter", null));
                                                            rm.done();
                                                        }
                                                    }
                                                }
                                            }).schedule();
                                        }
                                    };
                                    if (((IProcesses.IProcessDMContext[])this.getData()).length > 0 && ((IProcesses.IProcessDMContext[])this.getData())[0] instanceof IProcesses.IThreadDMData) {
                                        IProcesses.IProcessDMContext[] iProcessDMContextArray = (IProcesses.IProcessDMContext[])this.getData();
                                        int n = iProcessDMContextArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IProcesses.IProcessDMContext processCtx = iProcessDMContextArray[n2];
                                            IProcesses.IThreadDMData processData = (IProcesses.IThreadDMData)processCtx;
                                            int pid = 0;
                                            try {
                                                pid = Integer.parseInt(processData.getId());
                                            }
                                            catch (NumberFormatException numberFormatException) {}
                                            String[] cores = null;
                                            String owner = null;
                                            if (processData instanceof IGDBProcesses.IGdbThreadDMData) {
                                                cores = ((IGDBProcesses.IGdbThreadDMData)processData).getCores();
                                                owner = ((IGDBProcesses.IGdbThreadDMData)processData).getOwner();
                                            }
                                            procInfoList.add(new ProcessInfo(pid, processData.getName(), cores, owner));
                                            ++n2;
                                        }
                                        countingRm.setDoneCount(0);
                                    } else {
                                        IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                                        if (procService != null) {
                                            countingRm.setDoneCount(((IProcesses.IProcessDMContext[])this.getData()).length);
                                            IProcesses.IProcessDMContext[] iProcessDMContextArray = (IProcesses.IProcessDMContext[])this.getData();
                                            int n = iProcessDMContextArray.length;
                                            int n3 = 0;
                                            while (n3 < n) {
                                                IProcesses.IProcessDMContext processCtx = iProcessDMContextArray[n3];
                                                procService.getExecutionData((IProcesses.IThreadDMContext)processCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IThreadDMData>((Executor)GdbConnectCommand.this.fExecutor, (RequestMonitor)countingRm){

                                                    protected void handleSuccess() {
                                                        IProcesses.IThreadDMData processData = (IProcesses.IThreadDMData)this.getData();
                                                        int pid = 0;
                                                        try {
                                                            pid = Integer.parseInt(processData.getId());
                                                        }
                                                        catch (NumberFormatException numberFormatException) {}
                                                        String[] cores = null;
                                                        String owner = null;
                                                        if (processData instanceof IGDBProcesses.IGdbThreadDMData) {
                                                            cores = ((IGDBProcesses.IGdbThreadDMData)processData).getCores();
                                                            owner = ((IGDBProcesses.IGdbThreadDMData)processData).getOwner();
                                                        }
                                                        procInfoList.add(new ProcessInfo(pid, processData.getName(), cores, owner));
                                                        countingRm.done();
                                                    }
                                                });
                                                ++n3;
                                            }
                                        } else {
                                            countingRm.setDoneCount(0);
                                        }
                                    }
                                }
                            });
                        }
                    });
                } else {
                    rm.done();
                }
            }
        });
    }

    private class PromptAndAttachToProcessJob
    extends UIJob {
        private final String fPid;
        private final RequestMonitor fRm;
        private final String fProcName;

        public PromptAndAttachToProcessJob(String pid, String procName, RequestMonitor rm) {
            super("");
            this.fPid = pid;
            this.fProcName = procName;
            this.fRm = rm;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Shell shell;
            String binaryPath = (String)GdbConnectCommand.this.fProcessNameToBinaryMap.get(this.fProcName);
            if (binaryPath == null && (shell = Display.getCurrent().getActiveShell()) != null) {
                FileDialog fd = new FileDialog(shell, 0);
                binaryPath = fd.open();
            }
            if (binaryPath == null) {
                this.fRm.done();
            } else {
                final String finalBinaryPath = binaryPath;
                GdbConnectCommand.this.fExecutor.execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IGDBProcesses procService = (IGDBProcesses)GdbConnectCommand.this.fTracker.getService(IGDBProcesses.class);
                        ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                        if (procService != null && commandControl != null) {
                            IProcesses.IProcessDMContext procDmc = procService.createProcessContext(commandControl.getContext(), PromptAndAttachToProcessJob.this.fPid);
                            procService.attachDebuggerToProcess(procDmc, finalBinaryPath, (DataRequestMonitor)new DataRequestMonitor<IDMContext>((Executor)GdbConnectCommand.this.fExecutor, PromptAndAttachToProcessJob.this.fRm){

                                protected void handleSuccess() {
                                    GdbConnectCommand.this.fProcessNameToBinaryMap.put(PromptAndAttachToProcessJob.this.fProcName, finalBinaryPath);
                                    PromptAndAttachToProcessJob.this.fRm.done();
                                }
                            });
                        } else {
                            PromptAndAttachToProcessJob.this.fRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Cannot find services", null));
                            PromptAndAttachToProcessJob.this.fRm.done();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PromptForPidJob
    extends Job {
        IProcessExtendedInfo[] fProcessList;
        DataRequestMonitor<Object> fRequestMonitor;
        boolean fNewProcessSupported;

        public PromptForPidJob(String name, boolean newProcessSupported, IProcessExtendedInfo[] procs, DataRequestMonitor<Object> rm) {
            super(name);
            this.fProcessList = null;
            this.fNewProcessSupported = newProcessSupported;
            this.fProcessList = procs;
            this.fRequestMonitor = rm;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Status promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
            Status processPromptStatus = new Status(1, "org.eclipse.cdt.dsf.gdb.ui", 100, "", null);
            IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)promptStatus);
            Status NO_PID_STATUS = new Status(4, "org.eclipse.cdt.dsf.gdb.ui", -1, LaunchMessages.getString((String)"LocalAttachLaunchDelegate.No_Process_ID_selected"), null);
            if (prompter == null) {
                this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
                this.fRequestMonitor.done();
                return Status.OK_STATUS;
            }
            try {
                ProcessPrompter.PrompterInfo info = new ProcessPrompter.PrompterInfo(this.fNewProcessSupported, this.fProcessList);
                Object result = prompter.handleStatus((IStatus)processPromptStatus, (Object)info);
                if (result == null) {
                    this.fRequestMonitor.cancel();
                } else if (result instanceof IProcessExtendedInfo || result instanceof String) {
                    this.fRequestMonitor.setData(result);
                } else {
                    this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
                }
            }
            catch (CoreException coreException) {
                this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
            }
            this.fRequestMonitor.done();
            return Status.OK_STATUS;
        }
    }
}

