/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.ui.preferences.ReadOnlyFieldEditor;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.breakpoints.Messages;
import org.eclipse.cdt.dsf.gdb.internal.ui.breakpoints.TracepointPreferenceStore;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBTracepointPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private BooleanFieldEditor fEnabled;
    private TracepointStringFieldEditor fCondition;
    private Text fIgnoreCountTextControl;
    private TracepointIntegerFieldEditor fIgnoreCount;
    private Text fPassCountTextControl;
    private TracepointIntegerFieldEditor fPassCount;
    private IAdaptable fElement;
    private TracepointPreferenceStore fTracepointPreferenceStore;

    public GDBTracepointPropertyPage() {
        super(1);
        this.noDefaultAndApplyButton();
        this.fTracepointPreferenceStore = new TracepointPreferenceStore();
    }

    protected void createFieldEditors() {
        ICTracepoint tracepoint = this.getTracepoint();
        this.createMainLabel(tracepoint);
        this.createTypeSpecificLabelFieldEditors(tracepoint);
        this.createEnabledField(this.getFieldEditorParent());
        IPreferenceStore store = this.getPreferenceStore();
        try {
            String condition = tracepoint.getCondition();
            if (condition == null) {
                condition = "";
            }
            store.setValue("CONDITION", condition);
            this.createConditionEditor(this.getFieldEditorParent());
            store.setValue("ENABLED", tracepoint.isEnabled());
            int passCount = tracepoint.getPassCount();
            store.setValue("PASS_COUNT", passCount >= 0 ? passCount : 0);
            this.createPassCountEditor(this.getFieldEditorParent());
        }
        catch (CoreException ce) {
            GdbUIPlugin.log(ce);
        }
    }

    private void createMainLabel(ICTracepoint tracepoint) {
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.TracepointPropertyPage_Class, this.getTracepointMainLabel(tracepoint)));
    }

    private void createTypeSpecificLabelFieldEditors(ICTracepoint tracepoint) {
        if (tracepoint instanceof ICFunctionBreakpoint) {
            ICFunctionBreakpoint ftrpt = (ICFunctionBreakpoint)tracepoint;
            String function = Messages.TracepointPropertyPage_NotAvailable;
            try {
                function = ftrpt.getFunction();
            }
            catch (CoreException e) {
                GdbUIPlugin.log(e);
            }
            if (function != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.TracepointPropertyPage_FunctionName, function));
            }
        } else if (tracepoint instanceof ICAddressBreakpoint) {
            ICAddressBreakpoint atrpt = (ICAddressBreakpoint)tracepoint;
            String address = Messages.TracepointPropertyPage_NotAvailable;
            try {
                address = atrpt.getAddress();
            }
            catch (CoreException e) {
                GdbUIPlugin.log(e);
            }
            if (address != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.TracepointPropertyPage_Address, address));
            }
        } else {
            String fileName = null;
            try {
                fileName = tracepoint.getSourceHandle();
            }
            catch (CoreException e) {
                GdbUIPlugin.log(e);
            }
            if (fileName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.TracepointPropertyPage_File, fileName));
            }
            ICTracepoint ltrpt = tracepoint;
            int lNumber = 0;
            try {
                lNumber = ltrpt.getLineNumber();
            }
            catch (CoreException e) {
                GdbUIPlugin.log(e);
            }
            if (lNumber > 0) {
                this.getPreferenceStore().setValue("LINE", lNumber);
                this.createLineNumberEditor(this.getFieldEditorParent());
            }
        }
    }

    private String getTracepointMainLabel(ICTracepoint tracepoint) {
        if (tracepoint instanceof ICFunctionBreakpoint) {
            return Messages.TracepointPropertyPage_FunctionTracepoint;
        }
        if (tracepoint instanceof ICAddressBreakpoint) {
            return Messages.TracepointPropertyPage_AddressTracepoint;
        }
        return Messages.TracepointPropertyPage_LineTracepoint;
    }

    protected void createLineNumberEditor(Composite parent) {
        String title = Messages.TracepointPropertyPage_LineNumber;
        TracepointIntegerFieldEditor labelFieldEditor = new TracepointIntegerFieldEditor("LINE", title, parent);
        labelFieldEditor.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)labelFieldEditor);
    }

    protected void createEnabledField(Composite parent) {
        this.fEnabled = new BooleanFieldEditor("ENABLED", Messages.TracepointPropertyPage_Enabled, parent);
        this.addField((FieldEditor)this.fEnabled);
    }

    protected void createConditionEditor(Composite parent) {
        this.fCondition = new TracepointStringFieldEditor("CONDITION", Messages.TracepointPropertyPage_Condition, parent);
        this.fCondition.setEmptyStringAllowed(true);
        this.fCondition.setErrorMessage(Messages.TracepointPropertyPage_InvalidCondition);
        this.addField((FieldEditor)this.fCondition);
    }

    protected void createIgnoreCountEditor(Composite parent) {
        this.fIgnoreCount = new TracepointIntegerFieldEditor("IGNORE_COUNT", Messages.TracepointPropertyPage_IgnoreCount, parent);
        this.fIgnoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.fIgnoreCountTextControl = this.fIgnoreCount.getTextControl(parent);
        try {
            this.fIgnoreCountTextControl.setEnabled(this.getTracepoint().getIgnoreCount() >= 0);
        }
        catch (CoreException ce) {
            GdbUIPlugin.log(ce);
        }
        this.addField((FieldEditor)this.fIgnoreCount);
    }

    protected void createPassCountEditor(Composite parent) {
        this.fPassCount = new TracepointIntegerFieldEditor("PASS_COUNT", Messages.TracepointPropertyPage_PassCount, parent);
        this.fPassCount.setValidRange(0, Integer.MAX_VALUE);
        this.fPassCountTextControl = this.fPassCount.getTextControl(parent);
        try {
            this.fPassCountTextControl.setEnabled(this.getTracepoint().getPassCount() >= 0);
        }
        catch (CoreException ce) {
            GdbUIPlugin.log(ce);
        }
        this.addField((FieldEditor)this.fPassCount);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected ICTracepoint getTracepoint() {
        IAdaptable element = this.getElement();
        return element instanceof ICTracepoint ? (ICTracepoint)element : (ICTracepoint)element.getAdapter(ICTracepoint.class);
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fTracepointPreferenceStore;
    }

    public boolean performOk() {
        final ArrayList<String> changedProperties = new ArrayList<String>(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        });
        boolean result = super.performOk();
        this.setBreakpointProperties(changedProperties);
        return result;
    }

    protected void setBreakpointProperties(final List<String> changedProperties) {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICTracepoint tracepoint = GDBTracepointPropertyPage.this.getTracepoint();
                for (String property : changedProperties) {
                    if (property.equals("ENABLED")) {
                        tracepoint.setEnabled(GDBTracepointPropertyPage.this.getPreferenceStore().getBoolean("ENABLED"));
                        continue;
                    }
                    if (property.equals("IGNORE_COUNT")) {
                        tracepoint.setIgnoreCount(GDBTracepointPropertyPage.this.getPreferenceStore().getInt("IGNORE_COUNT"));
                        continue;
                    }
                    if (property.equals("PASS_COUNT")) {
                        tracepoint.setPassCount(GDBTracepointPropertyPage.this.getPreferenceStore().getInt("PASS_COUNT"));
                        continue;
                    }
                    if (property.equals("CONDITION")) {
                        tracepoint.setCondition(GDBTracepointPropertyPage.this.getPreferenceStore().getString("CONDITION"));
                        continue;
                    }
                    if (property.equals("LINE")) {
                        tracepoint.getMarker().setAttribute("lineNumber", GDBTracepointPropertyPage.this.getPreferenceStore().getInt("LINE"));
                        continue;
                    }
                    String value = GDBTracepointPropertyPage.this.getPropertyAsString(property);
                    tracepoint.getMarker().setAttribute(property, (Object)value);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException ce) {
            GdbUIPlugin.log(ce);
        }
    }

    protected String getPropertyAsString(String property) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains(property)) {
            String value = store.getString(property);
            return value;
        }
        return null;
    }

    class LabelFieldEditor
    extends ReadOnlyFieldEditor {
        private String fValue;

        public LabelFieldEditor(Composite parent, String title, String value) {
            super(title, title, parent);
            this.fValue = value;
        }

        protected void doLoad() {
            if (this.textField != null) {
                this.textField.setText(this.fValue);
            }
        }

        protected void doLoadDefault() {
        }
    }

    class TracepointIntegerFieldEditor
    extends IntegerFieldEditor {
        public TracepointIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage(Messages.TracepointPropertyPage_integer_negative);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class TracepointStringFieldEditor
    extends StringFieldEditor {
        public TracepointStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }
}

