/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public class GdbReverseToggleCommand
extends AbstractDebugCommand
implements IReverseToggleHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbReverseToggleCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        IDMContext dmc = ((IDMVMContext)targets[0]).getDMContext();
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc == null) {
            return;
        }
        Query<Object> setReverseMode = new Query<Object>(){

            public void execute(final DataRequestMonitor<Object> rm) {
                final IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.isReverseModeEnabled(controlDmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)GdbReverseToggleCommand.this.fExecutor, rm){

                        public void handleSuccess() {
                            runControl.enableReverseMode(controlDmc, (Boolean)this.getData() == false, (RequestMonitor)rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)setReverseMode);
            setReverseMode.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        IDMContext dmc = ((IDMVMContext)targets[0]).getDMContext();
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IExecutionDMContext.class);
        if (controlDmc == null && execDmc == null) {
            return false;
        }
        Query<Boolean> canSetReverseMode = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null && runControl instanceof IRunControl && ((IRunControl)runControl).isSuspended(execDmc)) {
                    runControl.canEnableReverseMode(controlDmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canSetReverseMode);
            return (Boolean)canSetReverseMode.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return true;
    }

    public boolean toggleNeedsUpdating() {
        return true;
    }

    public boolean isReverseToggled(Object context) {
        IDMContext dmc;
        if (context instanceof IDMContext) {
            dmc = (IDMContext)context;
        } else if (context instanceof IDMVMContext) {
            dmc = ((IDMVMContext)context).getDMContext();
        } else {
            return false;
        }
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc == null) {
            return false;
        }
        Query<Boolean> isToggledQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseToggleCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.isReverseModeEnabled(controlDmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)isToggledQuery);
            return (Boolean)isToggledQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }
}

