/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.preferences;

import java.io.File;
import org.eclipse.cdt.dsf.debug.internal.ui.preferences.StringWithBooleanFieldEditor;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.preferences.MessagesForPreferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class GdbDebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public GdbDebugPreferencePage() {
        super(0);
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(MessagesForPreferences.GdbDebugPreferencePage_description);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.dsf.gdb.ui.dsfgdb_preference_page");
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Group group1 = new Group(parent, 0);
        group1.setText(MessagesForPreferences.GdbDebugPreferencePage_defaults_label);
        GridLayout groupLayout = new GridLayout(3, false);
        group1.setLayout((Layout)groupLayout);
        group1.setLayoutData((Object)new GridData(768));
        final StringFieldEditor stringFieldEditorCommand = new StringFieldEditor("defaultGdbCommand", LaunchUIMessages.getString("GDBDebuggerPage.gdb_debugger"), (Composite)group1);
        stringFieldEditorCommand.fillIntoGrid((Composite)group1, 2);
        this.addField((FieldEditor)stringFieldEditorCommand);
        Button browsebutton = new Button((Composite)group1, 8);
        browsebutton.setText(LaunchUIMessages.getString("GDBDebuggerPage.gdb_browse"));
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebugPreferencePage.this.handleBrowseButtonSelected(LaunchUIMessages.getString("GDBDebuggerPage.gdb_browse_dlg_title"), stringFieldEditorCommand);
            }
        });
        final StringFieldEditor stringFieldEditorGdbInit = new StringFieldEditor("defaultGdbInit", LaunchUIMessages.getString("GDBDebuggerPage.gdb_command_file"), (Composite)group1);
        stringFieldEditorGdbInit.fillIntoGrid((Composite)group1, 2);
        this.addField((FieldEditor)stringFieldEditorGdbInit);
        browsebutton = new Button((Composite)group1, 8);
        browsebutton.setText(LaunchUIMessages.getString("GDBDebuggerPage.gdb_browse"));
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebugPreferencePage.this.handleBrowseButtonSelected(LaunchUIMessages.getString("GDBDebuggerPage.gdb_cmdfile_dlg_title"), stringFieldEditorGdbInit);
            }
        });
        StringWithBooleanFieldEditor enableStopAtMain = new StringWithBooleanFieldEditor("defaultStopAtMain", "defaultStopAtMainSymbol", LaunchUIMessages.getString("CDebuggerTab.Stop_at_main_on_startup"), (Composite)group1);
        enableStopAtMain.fillIntoGrid((Composite)group1, 2);
        this.addField((FieldEditor)enableStopAtMain);
        ListenableBooleanFieldEditor enableNonStop = new ListenableBooleanFieldEditor("defaultNonStop", LaunchUIMessages.getString("GDBDebuggerPage.nonstop_mode"), 0, (Composite)group1);
        enableNonStop.fillIntoGrid((Composite)group1, 3);
        this.addField((FieldEditor)enableNonStop);
        group1.setLayout((Layout)groupLayout);
        final Group group2 = new Group(parent, 0);
        group2.setText(MessagesForPreferences.GdbDebugPreferencePage_traces_label);
        groupLayout = new GridLayout(3, false);
        group2.setLayout((Layout)groupLayout);
        group2.setLayoutData((Object)new GridData(768));
        final ListenableBooleanFieldEditor enableGdbTracesField = new ListenableBooleanFieldEditor("tracesEnable", MessagesForPreferences.GdbDebugPreferencePage_enableTraces_label, 0, (Composite)group2);
        enableGdbTracesField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)enableGdbTracesField);
        final IntegerFieldEditor maxCharactersField = new IntegerFieldEditor("maxGdbTraces", MessagesForPreferences.GdbDebugPreferencePage_maxGdbTraces_label, (Composite)group2);
        maxCharactersField.setValidRange(10000, 2000000000);
        maxCharactersField.fillIntoGrid((Composite)group2, 3);
        this.addField((FieldEditor)maxCharactersField);
        enableGdbTracesField.getChangeControl((Composite)group2).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = enableGdbTracesField.getBooleanValue();
                maxCharactersField.setEnabled(enabled, (Composite)group2);
            }
        });
        group2.setLayout((Layout)groupLayout);
        Group group = new Group(parent, 0);
        group.setText(MessagesForPreferences.GdbDebugPreferencePage_termination_label);
        groupLayout = new GridLayout(3, false);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        BooleanFieldEditor boolField = new BooleanFieldEditor("autoTerminateGdb", MessagesForPreferences.GdbDebugPreferencePage_autoTerminateGdb_label, (Composite)group);
        boolField.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)boolField);
        group.setLayout((Layout)groupLayout);
        group = new Group(parent, 0);
        group.setText(MessagesForPreferences.GdbDebugPreferencePage_hover_label);
        groupLayout = new GridLayout(3, false);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        boolField = new BooleanFieldEditor("useInspectorHover", MessagesForPreferences.GdbDebugPreferencePage_useInspectorHover_label, (Composite)group);
        boolField.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)boolField);
        group.setLayout((Layout)groupLayout);
        group = new Group(parent, 0);
        group.setText(MessagesForPreferences.GdbDebugPreferencePage_prettyPrinting_label);
        groupLayout = new GridLayout(3, false);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        final ListenableBooleanFieldEditor enablePrettyPrintingField = new ListenableBooleanFieldEditor("enablePrettyPrinting", String.valueOf(MessagesForPreferences.GdbDebugPreferencePage_enablePrettyPrinting_label1) + "\n" + MessagesForPreferences.GdbDebugPreferencePage_enablePrettyPrinting_label2, 0, (Composite)group);
        enablePrettyPrintingField.fillIntoGrid((Composite)group, 3);
        this.addField((FieldEditor)enablePrettyPrintingField);
        final Composite indentHelper = new Composite((Composite)group, 0);
        GridLayout helperLayout = new GridLayout(3, false);
        indentHelper.setLayout((Layout)helperLayout);
        GridData helperData = new GridData(4, 4, true, false, 3, 1);
        helperData.horizontalIndent = 20;
        indentHelper.setLayoutData((Object)helperData);
        final IntegerFieldEditor childCountLimitField = new IntegerFieldEditor("initialChildCountLimitForCollections", MessagesForPreferences.GdbDebugPreferencePage_initialChildCountLimitForCollections_label, indentHelper);
        childCountLimitField.setValidRange(1, 10000);
        childCountLimitField.fillIntoGrid(indentHelper, 3);
        boolean prettyPrintingEnabled = this.getPreferenceStore().getBoolean("enablePrettyPrinting");
        childCountLimitField.setEnabled(prettyPrintingEnabled, indentHelper);
        this.addField((FieldEditor)childCountLimitField);
        enablePrettyPrintingField.getChangeControl((Composite)group).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = enablePrettyPrintingField.getBooleanValue();
                childCountLimitField.setEnabled(enabled, indentHelper);
            }
        });
        indentHelper.setLayout((Layout)helperLayout);
        group.setLayout((Layout)groupLayout);
    }

    private void handleBrowseButtonSelected(String dialogTitle, StringFieldEditor stringFieldEditor) {
        String res;
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(dialogTitle);
        String gdbCommand = stringFieldEditor.getStringValue().trim();
        int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
        }
        if ((res = dialog.open()) == null) {
            return;
        }
        stringFieldEditor.setStringValue(res);
    }

    protected void adjustGridLayout() {
    }

    private class ListenableBooleanFieldEditor
    extends BooleanFieldEditor {
        public ListenableBooleanFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }
    }
}

