/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.actions;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IStepReturnHandler;

@Immutable
public class DsfStepReturnCommand
implements IStepReturnHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfStepReturnCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){

            public void doExecute() {
                SteppingController steppingControl = this.getSteppingController();
                if (steppingControl == null) {
                    request.setEnabled(false);
                    request.done();
                    return;
                }
                steppingControl.canEnqueueStep(this.getContext(), IRunControl.StepType.STEP_RETURN, new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

                    protected void handleCompleted() {
                        request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                        request.done();
                    }
                });
            }
        }));
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                this.getSteppingController().enqueueStep(this.getContext(), IRunControl.StepType.STEP_RETURN);
            }
        }));
        return true;
    }
}

