/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointsChangedEvent;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBreakpointVMNode
extends AbstractVMNode {
    public AbstractBreakpointVMNode(BreakpointVMProvider provider) {
        super(provider);
    }

    protected abstract Object createBreakpiontElement(IBreakpoint var1);

    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ((BreakpointVMProvider)this.getVMProvider()).getNestingCategoryBreakpoints(update.getElementPath(), (DataRequestMonitor<IBreakpoint[]>)new ViewerDataRequestMonitor<IBreakpoint[]>(this.getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            update.setHasChilren(((IBreakpoint[])this.getData()).length != 0);
                        } else {
                            update.setHasChilren(false);
                        }
                        update.done();
                    }
                });
            }
            ++n2;
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ((BreakpointVMProvider)this.getVMProvider()).getNestingCategoryBreakpoints(update.getElementPath(), (DataRequestMonitor<IBreakpoint[]>)new ViewerDataRequestMonitor<IBreakpoint[]>(this.getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            update.setChildCount(((IBreakpoint[])this.getData()).length);
                        } else {
                            update.setChildCount(0);
                        }
                        update.done();
                    }
                });
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenUpdate update = iChildrenUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ((BreakpointVMProvider)this.getVMProvider()).getNestingCategoryBreakpoints(update.getElementPath(), (DataRequestMonitor<IBreakpoint[]>)new ViewerDataRequestMonitor<IBreakpoint[]>(this.getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            Comparator comparator = (Comparator)AbstractBreakpointVMNode.this.getVMProvider().getPresentationContext().getProperty("ElementComparator");
                            if (comparator != null) {
                                Arrays.sort((IBreakpoint[])this.getData(), comparator);
                            }
                            AbstractBreakpointVMNode.this.fillUpdateWithBreakpointElements(update, (IBreakpoint[])this.getData());
                        }
                        update.done();
                    }
                });
            }
            ++n2;
        }
    }

    private void fillUpdateWithBreakpointElements(IChildrenUpdate update, IBreakpoint[] bps) {
        int updateIdx = update.getOffset() != -1 ? update.getOffset() : 0;
        int endIdx = updateIdx + (update.getLength() != -1 ? update.getLength() : bps.length);
        while (updateIdx < endIdx && updateIdx < bps.length) {
            update.setChild(this.createBreakpiontElement(bps[updateIdx]), updateIdx);
            ++updateIdx;
        }
    }

    @Override
    public int getDeltaFlags(Object event) {
        if (event instanceof BreakpointsChangedEvent) {
            BreakpointsChangedEvent bpChangedEvent = (BreakpointsChangedEvent)event;
            if (BreakpointsChangedEvent.Type.ADDED.equals((Object)bpChangedEvent.getType())) {
                return 0x300400;
            }
            return 1024;
        }
        if (BreakpointVMProvider.isPresentationContextEvent(event)) {
            PropertyChangeEvent propertyEvent = (PropertyChangeEvent)event;
            if ("FilterSelection".equals(propertyEvent.getProperty()) || "ElementComparator".equals(propertyEvent.getProperty())) {
                return 1024;
            }
            if ("BreakpointOrganizers".equals(propertyEvent.getProperty())) {
                return 0x100400;
            }
            if ("TrackSelection".equals(propertyEvent.getProperty()) && Boolean.TRUE.equals(propertyEvent.getNewValue())) {
                return 0x300000;
            }
        } else {
            if (event instanceof DebugContextEvent && (((DebugContextEvent)event).getFlags() | 1) != 0) {
                int flags = 0;
                if (Boolean.TRUE.equals(this.getVMProvider().getPresentationContext().getProperty("FilterSelection"))) {
                    flags |= 0x400;
                }
                if (Boolean.TRUE.equals(this.getVMProvider().getPresentationContext().getProperty("TrackSelection"))) {
                    flags |= 0x300000;
                }
                return flags;
            }
            if (event instanceof ModelProxyInstalledEvent && Boolean.TRUE.equals(this.getVMProvider().getPresentationContext().getProperty("TrackSelection"))) {
                return 0x300000;
            }
        }
        return 0;
    }

    @Override
    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        IWorkbenchWindow window;
        if (event instanceof BreakpointsChangedEvent) {
            BreakpointsChangedEvent bpChangedEvent = (BreakpointsChangedEvent)event;
            if (BreakpointsChangedEvent.Type.ADDED.equals((Object)bpChangedEvent.getType())) {
                this.buildBreakpointAddedDelta(bpChangedEvent, parent, nodeOffset, rm);
                return;
            }
            parent.setFlags(parent.getFlags() | 0x400);
        } else if (BreakpointVMProvider.isPresentationContextEvent(event)) {
            IWorkbenchWindow window2;
            PropertyChangeEvent propertyEvent = (PropertyChangeEvent)event;
            if ("FilterSelection".equals(propertyEvent.getProperty()) || "ElementComparator".equals(propertyEvent.getProperty())) {
                parent.setFlags(parent.getFlags() | 0x400);
            } else if ("BreakpointOrganizers".equals(propertyEvent.getProperty())) {
                parent.setFlags(parent.getFlags() | 0x100000 | 0x400);
            } else if ("TrackSelection".equals(propertyEvent.getProperty()) && Boolean.TRUE.equals(propertyEvent.getNewValue()) && (window2 = this.getVMProvider().getPresentationContext().getWindow()) != null) {
                ISelection activeContext = DebugUITools.getDebugContextManager().getContextService(window2).getActiveContext();
                this.buildTrackSelectionDelta(activeContext, parent, nodeOffset, rm);
                return;
            }
        } else if (event instanceof DebugContextEvent && (((DebugContextEvent)event).getFlags() | 1) != 0) {
            if (Boolean.TRUE.equals(this.getVMProvider().getPresentationContext().getProperty("FilterSelection"))) {
                parent.setFlags(parent.getFlags() | 0x400);
            }
            if (Boolean.TRUE.equals(this.getVMProvider().getPresentationContext().getProperty("TrackSelection"))) {
                this.buildTrackSelectionDelta(((DebugContextEvent)event).getContext(), parent, nodeOffset, rm);
                return;
            }
        } else if (event instanceof ModelProxyInstalledEvent && Boolean.TRUE.equals(this.getVMProvider().getPresentationContext().getProperty("TrackSelection")) && (window = this.getVMProvider().getPresentationContext().getWindow()) != null) {
            ISelection activeContext = DebugUITools.getDebugContextManager().getContextService(window).getActiveContext();
            this.buildTrackSelectionDelta(activeContext, parent, nodeOffset, rm);
            return;
        }
        rm.done();
    }

    private void buildBreakpointAddedDelta(final BreakpointsChangedEvent event, final VMDelta parent, int nodeOffset, final RequestMonitor rm) {
        this.getVMProvider().updateNode((IVMNode)this, new VMChildrenUpdate((IModelDelta)parent, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            protected void handleSuccess() {
                int i = 0;
                while (i < event.getBreakpoints().length) {
                    IBreakpoint eventBp = event.getBreakpoints()[i];
                    int bpIndex = AbstractBreakpointVMNode.this.findBreakpointIndex(eventBp, (List)this.getData());
                    if (bpIndex >= 0) {
                        if (i == 0) {
                            parent.addNode(((List)this.getData()).get(bpIndex), bpIndex, 0x200000);
                        }
                        parent.setFlags(parent.getFlags() | 0x400 | 0x100000);
                    }
                    ++i;
                }
                rm.done();
            }
        }));
    }

    protected void buildTrackSelectionDelta(ISelection debugContext, final VMDelta parent, int nodeOffset, final RequestMonitor rm) {
        assert (this.getVMProvider() instanceof BreakpointVMProvider);
        ((BreakpointVMProvider)this.getVMProvider()).getBreakpointsForDebugContext(debugContext, new DataRequestMonitor<IBreakpoint[]>(this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((IBreakpoint[])this.getData()).length == 0) {
                    rm.done();
                    return;
                }
                final IBreakpoint[] bpsToSelect = (IBreakpoint[])this.getData();
                AbstractBreakpointVMNode.this.getVMProvider().updateNode((IVMNode)AbstractBreakpointVMNode.this, new VMChildrenUpdate((IModelDelta)parent, AbstractBreakpointVMNode.this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(AbstractBreakpointVMNode.this.getExecutor(), rm){

                    protected void handleSuccess() {
                        int i = 0;
                        while (i < bpsToSelect.length) {
                            int bpIndex = AbstractBreakpointVMNode.this.findBreakpointIndex(bpsToSelect[i], (List)this.getData());
                            if (bpIndex >= 0) {
                                if (i == 0) {
                                    parent.addNode(((List)this.getData()).get(bpIndex), bpIndex, 0x200000);
                                }
                                parent.setFlags(parent.getFlags() | 0x100000);
                            }
                            ++i;
                        }
                        rm.done();
                    }
                }));
            }

            protected void handleErrorOrWarning() {
                rm.done();
            }
        });
    }

    private int findBreakpointIndex(IBreakpoint bp, List<Object> bpElements) {
        int j = 0;
        while (j < bpElements.size()) {
            IBreakpoint elementBp = (IBreakpoint)DebugPlugin.getAdapter((Object)bpElements.get(j), IBreakpoint.class);
            if (elementBp != null && elementBp.equals(bp)) {
                return j;
            }
            ++j;
        }
        return -1;
    }
}

