/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.xlc.core.scannerconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector3;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.xlc.core.activator.Activator;
import org.eclipse.cdt.make.xlc.core.messages.Messages;
import org.eclipse.cdt.make.xlc.core.scannerconfig.util.XLCCommandDSC;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerFileXLCScannerInfoCollector
implements IScannerInfoCollector3,
IManagedScannerInfoCollector {
    protected static final String APPLIES_TO_ATTR = "appliesToFiles";
    protected static final String CC_ELEM = "compilerCommand";
    public static final String COLLECTOR_ID = "org.eclipse.cdt.make.xlc.core.PerFileXLCScannerInfoCollector";
    protected static final String FILE_ELEM = "file";
    protected static final String FILE_TYPE_ATTR = "fileType";
    protected static final String ID_ATTR = "id";
    protected static final int INCLUDE_FILE = 3;
    protected static final int INCLUDE_PATH = 1;
    protected static final int MACROS_FILE = 4;
    protected static final String PATH_ATTR = "path";
    protected static final int QUOTE_INCLUDE_PATH = 2;
    protected int commandIdCounter = 0;
    protected InfoContext context;
    protected final Object fLock = new Object();
    private Map<IProject, Map<?, ?>> fProjectSettingsMap = new HashMap();
    protected final SortedSet<Integer> freeCommandIdPool;
    protected IProject project;
    protected ProjectScannerInfo psi = null;
    protected final List<Integer> siChangedForCommandIdList;
    protected final Map<IResource, Integer> siChangedForFileMap;
    protected ScannerInfoData sid = new ScannerInfoData();

    protected static PathInfo createFilePathInfo(CCommandDSC cmd) {
        IPath[] includes = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getIncludes());
        IPath[] quotedIncludes = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getQuoteIncludes());
        IPath[] incFiles = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getIncludeFile());
        IPath[] macroFiles = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getImacrosFile());
        List symbols = cmd.getSymbols();
        HashMap<String, String> definedSymbols = new HashMap<String, String>(symbols.size());
        for (String symbol : symbols) {
            String key = ScannerConfigUtil.getSymbolKey((String)symbol);
            String value = ScannerConfigUtil.getSymbolValue((String)symbol);
            definedSymbols.put(key, value);
        }
        return new PathInfo(includes, quotedIncludes, definedSymbols, incFiles, macroFiles);
    }

    protected static IPath[] stringListToPathArray(List<String> discovered) {
        ArrayList<Path> allIncludes = new ArrayList<Path>(discovered.size());
        for (String include : discovered) {
            if (allIncludes.contains(include)) continue;
            allIncludes.add(new Path(include));
        }
        return allIncludes.toArray(new IPath[allIncludes.size()]);
    }

    public PerFileXLCScannerInfoCollector() {
        this.siChangedForFileMap = new HashMap<IResource, Integer>();
        this.siChangedForCommandIdList = new ArrayList<Integer>();
        this.freeCommandIdPool = new TreeSet<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCompilerCommand(IFile file, CCommandDSC cmd) {
        Object object = this.fLock;
        synchronized (object) {
            ArrayList<CCommandDSC> existingCommands = new ArrayList<CCommandDSC>(this.sid.commandIdCommandMap.values());
            int index = existingCommands.indexOf(cmd);
            if (index != -1) {
                cmd = (CCommandDSC)existingCommands.get(index);
            } else {
                int commandId = -1;
                if (!this.freeCommandIdPool.isEmpty()) {
                    Integer freeCommandId = this.freeCommandIdPool.first();
                    this.freeCommandIdPool.remove(freeCommandId);
                    commandId = freeCommandId;
                } else {
                    commandId = ++this.commandIdCounter;
                }
                cmd.setCommandId(commandId);
                this.sid.commandIdCommandMap.put(cmd.getCommandIdAsInteger(), cmd);
            }
            this.generateFileDelta(file, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addScannerInfo(Integer commandId, Map scannerInfo) {
        Object object = this.fLock;
        synchronized (object) {
            CCommandDSC cmd = this.sid.commandIdCommandMap.get(commandId);
            if (cmd != null) {
                List siItem = (List)scannerInfo.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
                cmd.setSymbols(siItem);
                siItem = (List)scannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
                siItem = CygpathTranslator.translateIncludePaths((IProject)this.project, (List)siItem);
                siItem = CCommandDSC.makeRelative((IProject)this.project, (List)siItem);
                cmd.setIncludes(siItem);
                siItem = (List)scannerInfo.get(ScannerInfoTypes.QUOTE_INCLUDE_PATHS);
                siItem = CygpathTranslator.translateIncludePaths((IProject)this.project, (List)siItem);
                siItem = CCommandDSC.makeRelative((IProject)this.project, (List)siItem);
                cmd.setQuoteIncludes(siItem);
                cmd.setDiscovered(true);
            }
        }
    }

    protected void addScannerInfo(ScannerInfoTypes type, List delta) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFileDeltas() {
        Object object = this.fLock;
        synchronized (object) {
            for (IFile iFile : this.siChangedForFileMap.keySet()) {
                Integer commandId = this.siChangedForFileMap.get(iFile);
                if (commandId == null) continue;
                Set<IFile> fileSet = this.sid.commandIdToFilesMap.get(commandId);
                if (fileSet == null) {
                    fileSet = new HashSet<IFile>();
                    this.sid.commandIdToFilesMap.put(commandId, fileSet);
                    CCommandDSC cmd = this.sid.commandIdCommandMap.get(commandId);
                    if (cmd != null) {
                        cmd.resolveOptions(this.project);
                    }
                }
                if (!fileSet.add(iFile)) continue;
                boolean change = true;
                Integer oldCommandId = this.sid.fileToCommandIdMap.get(iFile);
                if (oldCommandId != null) {
                    if (oldCommandId.equals(commandId)) {
                        change = false;
                    } else {
                        Set<IFile> oldFileSet = this.sid.commandIdToFilesMap.get(oldCommandId);
                        if (oldFileSet != null) {
                            oldFileSet.remove(iFile);
                        }
                    }
                }
                if (!change) continue;
                this.sid.fileToCommandIdMap.put(iFile, commandId);
            }
            this.generateProjectScannerInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<IResource, PathInfo> calculatePathInfoMap() {
        Object object = this.fLock;
        synchronized (object) {
            PathInfo fpi;
            HashMap<IResource, PathInfo> map = new HashMap<IResource, PathInfo>(this.sid.fileToCommandIdMap.size() + 1);
            for (Map.Entry<IFile, Integer> entry : this.sid.fileToCommandIdMap.entrySet()) {
                CCommandDSC cmd;
                IFile file = entry.getKey();
                if (file == null || (cmd = this.sid.commandIdCommandMap.get(entry.getValue())) == null) continue;
                fpi = PerFileXLCScannerInfoCollector.createFilePathInfo(cmd);
                map.put((IResource)file, fpi);
            }
            if (this.project != null) {
                if (this.psi == null) {
                    this.generateProjectScannerInfo();
                }
                fpi = new PathInfo(this.psi.includePaths, this.psi.quoteIncludePaths, this.psi.definedSymbols, this.psi.includeFiles, this.psi.macrosFiles);
                map.put((IResource)this.project, fpi);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contributeToScannerConfig(Object resource, Map scannerInfo) {
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (resource instanceof Integer) {
            Object object = this.fLock;
            synchronized (object) {
                this.addScannerInfo((Integer)resource, scannerInfo);
            }
            return;
        }
        if (resource instanceof IFile) {
            if (((IFile)resource).getProject() == null) {
                errorMessage = "project is null";
            } else if (!((IFile)resource).getProject().equals((Object)this.project)) {
                errorMessage = "wrong project";
            }
            if (errorMessage != null) {
                TraceUtil.outputError((String)"PerFileSICollector.contributeToScannerConfig : ", (String)errorMessage);
                return;
            }
            IFile file = (IFile)resource;
            Object object = this.fLock;
            synchronized (object) {
                for (ScannerInfoTypes type : scannerInfo.keySet()) {
                    if (type.equals(ScannerInfoTypes.COMPILER_COMMAND)) {
                        List commands = (List)scannerInfo.get(type);
                        Iterator j = commands.iterator();
                        while (j.hasNext()) {
                            this.addCompilerCommand(file, (CCommandDSC)j.next());
                        }
                        continue;
                    }
                    this.addScannerInfo(type, (List)scannerInfo.get(type));
                }
            }
        }
        if (resource instanceof IProject) {
            Object object = this.fLock;
            synchronized (object) {
                this.fProjectSettingsMap.put((IProject)resource, scannerInfo);
            }
        } else {
            TraceUtil.outputError((String)"PerFileSICollector.contributeToScannerConfig : ", (String)"Not a project or file.");
            return;
        }
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo createPathInfoObject() {
        return new PerFileDiscoveredPathInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(IResource resource) {
        Object object = this.fLock;
        synchronized (object) {
            if (resource instanceof IProject) {
                this.fProjectSettingsMap.remove((IProject)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll1(IResource resource) {
        if (resource.equals((Object)this.project)) {
            Object object = this.fLock;
            synchronized (object) {
                this.siChangedForFileMap.clear();
                Set<IFile> changedFiles = this.sid.fileToCommandIdMap.keySet();
                for (IFile file : changedFiles) {
                    this.siChangedForFileMap.put((IResource)file, null);
                }
                this.sid = new ScannerInfoData();
                this.psi = null;
                this.commandIdCounter = 0;
                this.freeCommandIdPool.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllPaths(IResource resource) {
        Object object = this.fLock;
        synchronized (object) {
            if (resource instanceof IProject && this.fProjectSettingsMap != null) {
                this.fProjectSettingsMap.remove((IProject)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSymbols(IResource resource) {
        Object object = this.fLock;
        synchronized (object) {
            if (resource instanceof IProject && this.fProjectSettingsMap != null) {
                this.fProjectSettingsMap.remove((IProject)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePath(IResource resource, String path) {
        Object object = this.fLock;
        synchronized (object) {
            if (resource instanceof IProject && this.fProjectSettingsMap != null) {
                this.fProjectSettingsMap.remove((IProject)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSymbol(IResource resource, String symbol) {
        Object object = this.fLock;
        synchronized (object) {
            if (resource instanceof IProject && this.fProjectSettingsMap != null) {
                this.fProjectSettingsMap.remove((IProject)resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFileDelta(IFile file, CCommandDSC cmd) {
        Object object = this.fLock;
        synchronized (object) {
            Integer commandId = cmd.getCommandIdAsInteger();
            Integer oldCommandId = this.sid.fileToCommandIdMap.get(file);
            if (oldCommandId != null && oldCommandId.equals(commandId)) {
                this.siChangedForFileMap.remove(file);
            } else {
                this.siChangedForFileMap.put((IResource)file, commandId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateProjectScannerInfo() {
        Object object = this.fLock;
        synchronized (object) {
            this.psi = new ProjectScannerInfo();
            this.psi.includePaths = this.getAllIncludePaths(1);
            this.psi.quoteIncludePaths = this.getAllIncludePaths(2);
            this.psi.includeFiles = this.getAllIncludePaths(3);
            this.psi.macrosFiles = this.getAllIncludePaths(4);
            this.psi.definedSymbols = this.getAllSymbols();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPath[] getAllIncludePaths(int type) {
        Object object = this.fLock;
        synchronized (object) {
            IPath[] fileIncludes;
            IProject project = this.getInfoContext().getProject();
            Map<?, ?> projectScannerInfo = this.fProjectSettingsMap.get(project);
            List includes = null;
            if (projectScannerInfo != null) {
                includes = (List)projectScannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
            }
            LinkedList<Object> pathList = new LinkedList<Object>();
            if (includes != null) {
                for (String include : includes) {
                    pathList.add(new Path(include));
                }
            }
            IPath[] iPathArray = fileIncludes = this.getAllIncludePaths1(type);
            int n = fileIncludes.length;
            int n2 = 0;
            while (n2 < n) {
                IPath include = iPathArray[n2];
                pathList.add(include);
                ++n2;
            }
            return pathList.toArray(new IPath[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPath[] getAllIncludePaths1(int type) {
        Object object = this.fLock;
        synchronized (object) {
            ArrayList<String> allIncludes = new ArrayList<String>();
            for (Integer cmdId : this.sid.commandIdCommandMap.keySet()) {
                CCommandDSC cmd = this.sid.commandIdCommandMap.get(cmdId);
                if (!cmd.isDiscovered()) continue;
                List discovered = null;
                switch (type) {
                    case 1: {
                        discovered = cmd.getIncludes();
                        break;
                    }
                    case 2: {
                        discovered = cmd.getQuoteIncludes();
                        break;
                    }
                    case 3: {
                        discovered = cmd.getIncludeFile();
                        break;
                    }
                    case 4: {
                        discovered = cmd.getImacrosFile();
                    }
                }
                for (String include : discovered) {
                    if (allIncludes.contains(include)) continue;
                    allIncludes.add(include);
                }
            }
            return PerFileXLCScannerInfoCollector.stringListToPathArray(allIncludes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getAllSymbols() {
        Object object = this.fLock;
        synchronized (object) {
            List projectSymbols;
            IProject project = this.getInfoContext().getProject();
            Map<?, ?> projectScannerInfo = this.fProjectSettingsMap.get(project);
            HashMap<String, String> symbols = new HashMap<String, String>();
            if (projectScannerInfo != null && (projectSymbols = (List)projectScannerInfo.get(ScannerInfoTypes.SYMBOL_DEFINITIONS)) != null) {
                for (String symbol : projectSymbols) {
                    symbols.put(symbol, "1");
                }
            }
            Map<String, String> fileSymbols = this.getAllSymbols1();
            symbols.putAll(fileSymbols);
            return symbols;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getAllSymbols1() {
        Object object = this.fLock;
        synchronized (object) {
            HashMap<String, String> symbols = new HashMap<String, String>();
            for (Integer cmdId : this.sid.commandIdCommandMap.keySet()) {
                CCommandDSC cmd = this.sid.commandIdCommandMap.get(cmdId);
                if (!cmd.isDiscovered()) continue;
                List discovered = cmd.getSymbols();
                for (String symbol : discovered) {
                    String key = ScannerConfigUtil.getSymbolKey((String)symbol);
                    String value = ScannerConfigUtil.getSymbolValue((String)symbol);
                    symbols.put(key, value);
                }
            }
            return symbols;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CCommandDSC> getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        ArrayList<CCommandDSC> rv = new ArrayList<CCommandDSC>();
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (((IResource)resource).getProject() != this.project) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            TraceUtil.outputError((String)"PerProjectSICollector.getCollectedScannerInfo : ", (String)errorMessage);
            return rv;
        }
        if (this.project.equals((Object)((IResource)resource).getProject())) {
            if (type.equals(ScannerInfoTypes.COMPILER_COMMAND)) {
                Object object = this.fLock;
                synchronized (object) {
                    for (Integer n : this.sid.commandIdCommandMap.keySet()) {
                        Set<IFile> fileSet = this.sid.commandIdToFilesMap.get(n);
                        if (fileSet == null || fileSet.isEmpty()) continue;
                        rv.add(this.sid.commandIdCommandMap.get(n));
                    }
                }
            }
            if (type.equals(ScannerInfoTypes.UNDISCOVERED_COMPILER_COMMAND)) {
                Object object = this.fLock;
                synchronized (object) {
                    if (this.scannerInfoChanged()) {
                        if (this.siChangedForCommandIdList.isEmpty()) {
                            for (IFile iFile : this.siChangedForFileMap.keySet()) {
                                Integer cmdId = this.siChangedForFileMap.get(iFile);
                                if (cmdId == null || this.siChangedForCommandIdList.contains(cmdId)) continue;
                                this.siChangedForCommandIdList.add(cmdId);
                            }
                        }
                        Collections.sort(this.siChangedForCommandIdList);
                        for (Integer n : this.siChangedForCommandIdList) {
                            CCommandDSC command = this.sid.commandIdCommandMap.get(n);
                            rv.add(command);
                        }
                    }
                }
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CCommandDSC getCommand(IFile file) {
        Object object = this.fLock;
        synchronized (object) {
            Integer cmdId;
            CCommandDSC cmd = null;
            if (file != null && (cmdId = this.sid.fileToCommandIdMap.get(file)) != null) {
                cmd = this.sid.commandIdCommandMap.get(cmdId);
            }
            return cmd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CCommandDSC getCommand(IPath path) {
        Object object = this.fLock;
        synchronized (object) {
            try {
                IFile file = this.project.getWorkspace().getRoot().getFile(path);
                return this.getCommand(file);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDefinedSymbols() {
        Object object = this.fLock;
        synchronized (object) {
            return this.getAllSymbols();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIncludePaths() {
        Object object = this.fLock;
        synchronized (object) {
            LinkedList<String> pathStrings = new LinkedList<String>();
            List<IPath> paths = Arrays.asList(this.getAllIncludePaths(1));
            paths.addAll(Arrays.asList(this.getAllIncludePaths(2)));
            for (IPath path : paths) {
                pathStrings.add(path.toString());
            }
            return pathStrings;
        }
    }

    protected InfoContext getInfoContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUnusedCommands() {
        Object object = this.fLock;
        synchronized (object) {
            for (Map.Entry<Integer, Set<IFile>> entry : this.sid.commandIdToFilesMap.entrySet()) {
                Integer cmdId = entry.getKey();
                Set<IFile> fileSet = entry.getValue();
                if (!fileSet.isEmpty()) continue;
                this.freeCommandIdPool.add(cmdId);
            }
            for (Integer cmdId : this.freeCommandIdPool) {
                this.sid.commandIdCommandMap.remove(cmdId);
                this.sid.commandIdToFilesMap.remove(cmdId);
            }
            while (!this.freeCommandIdPool.isEmpty()) {
                Integer last = this.freeCommandIdPool.last();
                if (last != this.commandIdCounter) break;
                this.freeCommandIdPool.remove(last);
                --this.commandIdCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scannerInfoChanged() {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fProjectSettingsMap.isEmpty() || !this.siChangedForFileMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfoContext(InfoContext context) {
        Object object = this.fLock;
        synchronized (object) {
            this.project = context.getProject();
            this.context = context;
            try {
                DiscoveredScannerInfoStore.getInstance().loadDiscoveredScannerInfoFromState(this.project, context, (IDiscoveredPathManager.IDiscoveredScannerInfoSerializable)this.sid);
            }
            catch (CoreException e) {
                MakeCorePlugin.log((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProject(IProject project) {
        Object object = this.fLock;
        synchronized (object) {
            this.setInfoContext(new InfoContext(project));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("ScannerInfoCollector.Processing"), 100);
        monitor.subTask(Messages.getString("ScannerInfoCollector.Processing"));
        ArrayList<IResource> changedResources = new ArrayList<IResource>();
        Object object = this.fLock;
        synchronized (object) {
            if (this.scannerInfoChanged()) {
                this.applyFileDeltas();
                this.removeUnusedCommands();
                changedResources.addAll(this.siChangedForFileMap.keySet());
                this.siChangedForFileMap.clear();
            }
            this.siChangedForCommandIdList.clear();
            changedResources.addAll(this.fProjectSettingsMap.keySet());
            monitor.worked(50);
            if (!changedResources.isEmpty()) {
                try {
                    monitor.subTask(String.valueOf(Messages.getString("ScannerInfoCollector.Updating")) + this.project.getName());
                    Object pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.project, this.context);
                    if (!(pathInfo instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo)) {
                        pathInfo = this.createPathInfoObject();
                    } else {
                        PerFileDiscoveredPathInfo perFilePathInfo = new PerFileDiscoveredPathInfo();
                        pathInfo = !(pathInfo instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo) ? new MergedPerFileDiscoveredPathInfo((IDiscoveredPathManager.IDiscoveredPathInfo)pathInfo, perFilePathInfo) : perFilePathInfo;
                    }
                    ScannerConfigUpdateJob job = new ScannerConfigUpdateJob(this.context, (IDiscoveredPathManager.IDiscoveredPathInfo)pathInfo, this.context.isDefaultContext(), (List<IResource>)changedResources);
                    IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
                    job.setRule((ISchedulingRule)rule);
                    job.schedule();
                }
                catch (CoreException e) {
                    MakeCorePlugin.log((Throwable)e);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        monitor.worked(50);
        monitor.done();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MergedPerFileDiscoveredPathInfo
    implements IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 {
        private IDiscoveredPathManager.IDiscoveredPathInfo fInfo1;
        private IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 fInfo2;

        public MergedPerFileDiscoveredPathInfo(IDiscoveredPathManager.IDiscoveredPathInfo info1, IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info2) {
            this.fInfo1 = info1;
            this.fInfo2 = info2;
        }

        private IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 getPerFileInfo1() {
            if (this.fInfo1 instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo2) {
                return (IDiscoveredPathManager.IPerFileDiscoveredPathInfo2)this.fInfo1;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<IResource, PathInfo> getPathInfoMap() {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info1 = this.getPerFileInfo1();
                if (info1 != null) {
                    HashMap<IResource, PathInfo> map = new HashMap<IResource, PathInfo>();
                    map.putAll(info1.getPathInfoMap());
                    map.putAll(this.fInfo2.getPathInfoMap());
                    return map;
                }
                return this.fInfo2.getPathInfoMap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getIncludeFiles(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info1 = this.getPerFileInfo1();
                if (info1 != null) {
                    IPath path1;
                    LinkedList<IPath> list = new LinkedList<IPath>();
                    IPath[] iPathArray = info1.getIncludeFiles(path);
                    int n = iPathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        path1 = iPathArray[n2];
                        list.add(path1);
                        ++n2;
                    }
                    iPathArray = this.fInfo2.getIncludeFiles(path);
                    n = iPathArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        path1 = iPathArray[n2];
                        list.add(path1);
                        ++n2;
                    }
                    return list.toArray(new IPath[0]);
                }
                return this.fInfo2.getIncludeFiles(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getIncludePaths(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                int n;
                IPath[] iPathArray;
                HashSet<IPath> pathSet = new HashSet<IPath>();
                if (this.fInfo1 instanceof DiscoveredPathInfo) {
                    iPathArray = this.fInfo1.getIncludePaths();
                    n = iPathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath path1 = iPathArray[n2];
                        pathSet.add(path1);
                        ++n2;
                    }
                } else {
                    IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info1 = this.getPerFileInfo1();
                    if (info1 != null) {
                        IPath[] iPathArray2 = info1.getIncludePaths(path);
                        int n3 = iPathArray2.length;
                        n = 0;
                        while (n < n3) {
                            IPath path1 = iPathArray2[n];
                            pathSet.add(path1);
                            ++n;
                        }
                    }
                }
                iPathArray = this.fInfo2.getIncludePaths(path);
                n = iPathArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IPath path2 = iPathArray[n4];
                    pathSet.add(path2);
                    ++n4;
                }
                return pathSet.toArray(new IPath[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getMacroFiles(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                int n;
                int n2;
                IPath[] iPathArray;
                HashSet<IPath> pathSet = new HashSet<IPath>();
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info1 = this.getPerFileInfo1();
                if (info1 != null) {
                    iPathArray = info1.getMacroFiles(path);
                    n2 = iPathArray.length;
                    n = 0;
                    while (n < n2) {
                        IPath path1 = iPathArray[n];
                        pathSet.add(path1);
                        ++n;
                    }
                }
                iPathArray = this.fInfo2.getMacroFiles(path);
                n2 = iPathArray.length;
                n = 0;
                while (n < n2) {
                    IPath path2 = iPathArray[n];
                    pathSet.add(path2);
                    ++n;
                }
                return pathSet.toArray(new IPath[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getQuoteIncludePaths(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                int n;
                int n2;
                IPath[] iPathArray;
                HashSet<IPath> pathSet = new HashSet<IPath>();
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info1 = this.getPerFileInfo1();
                if (info1 != null) {
                    iPathArray = info1.getQuoteIncludePaths(path);
                    n2 = iPathArray.length;
                    n = 0;
                    while (n < n2) {
                        IPath path1 = iPathArray[n];
                        pathSet.add(path1);
                        ++n;
                    }
                }
                iPathArray = this.fInfo2.getQuoteIncludePaths(path);
                n2 = iPathArray.length;
                n = 0;
                while (n < n2) {
                    IPath path2 = iPathArray[n];
                    pathSet.add(path2);
                    ++n;
                }
                return pathSet.toArray(new IPath[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getSymbols(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                HashMap<String, String> symbols = new HashMap<String, String>();
                Map projectSymbols = this.fInfo1.getSymbols();
                for (String symbol : projectSymbols.keySet()) {
                    symbols.put(symbol, (String)projectSymbols.get(symbol));
                }
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info1 = this.getPerFileInfo1();
                if (info1 != null) {
                    symbols.putAll(info1.getSymbols(path));
                }
                symbols.putAll(this.fInfo2.getSymbols(path));
                return symbols;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                boolean info1empty = false;
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info1 = this.getPerFileInfo1();
                info1empty = info1 != null ? info1.isEmpty(path) : this.fInfo1.getIncludePaths().length == 0 && this.fInfo1.getSymbols().size() == 0;
                return this.fInfo2.isEmpty(path) && info1empty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getIncludePaths() {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                return this.fInfo1.getIncludePaths();
            }
        }

        public IProject getProject() {
            return this.fInfo1.getProject();
        }

        public IDiscoveredPathManager.IDiscoveredScannerInfoSerializable getSerializable() {
            return this.fInfo2.getSerializable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getSymbols() {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                return this.fInfo1.getSymbols();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PerFileDiscoveredPathInfo
    implements IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 {
        protected PerFileDiscoveredPathInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getIncludeFiles(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                LinkedHashSet<IPath> pathSet = new LinkedHashSet<IPath>();
                CCommandDSC cmd = PerFileXLCScannerInfoCollector.this.getCommand(path);
                if (cmd != null) {
                    IPath[] paths = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getIncludeFile());
                    pathSet.addAll(Arrays.asList(paths));
                }
                if (PerFileXLCScannerInfoCollector.this.psi == null) {
                    PerFileXLCScannerInfoCollector.this.generateProjectScannerInfo();
                }
                IPath[] iPathArray = PerFileXLCScannerInfoCollector.this.psi.includeFiles;
                int n = PerFileXLCScannerInfoCollector.this.psi.includeFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path2 = iPathArray[n2];
                    pathSet.add(path2);
                    ++n2;
                }
                return pathSet.toArray(new IPath[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getIncludePaths() {
            IPath[] quotepaths;
            IPath[] includepaths;
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                includepaths = PerFileXLCScannerInfoCollector.this.getAllIncludePaths(1);
                quotepaths = PerFileXLCScannerInfoCollector.this.getAllIncludePaths(2);
            }
            if (quotepaths == null || quotepaths.length == 0) {
                return includepaths;
            }
            if (includepaths == null || includepaths.length == 0) {
                return quotepaths;
            }
            ArrayList<IPath> result = new ArrayList<IPath>(includepaths.length + quotepaths.length);
            result.addAll(Arrays.asList(includepaths));
            result.addAll(Arrays.asList(quotepaths));
            return result.toArray(new IPath[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getIncludePaths(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                LinkedHashSet<IPath> pathSet = new LinkedHashSet<IPath>();
                CCommandDSC cmd = PerFileXLCScannerInfoCollector.this.getCommand(path);
                if (cmd != null) {
                    IPath[] paths = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getIncludes());
                    pathSet.addAll(Arrays.asList(paths));
                }
                if (PerFileXLCScannerInfoCollector.this.psi == null) {
                    PerFileXLCScannerInfoCollector.this.generateProjectScannerInfo();
                }
                IPath[] iPathArray = PerFileXLCScannerInfoCollector.this.psi.includePaths;
                int n = PerFileXLCScannerInfoCollector.this.psi.includePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path2 = iPathArray[n2];
                    pathSet.add(path2);
                    ++n2;
                }
                return pathSet.toArray(new IPath[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getMacroFiles(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                LinkedHashSet<IPath> pathSet = new LinkedHashSet<IPath>();
                CCommandDSC cmd = PerFileXLCScannerInfoCollector.this.getCommand(path);
                if (cmd != null) {
                    IPath[] paths = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getImacrosFile());
                    pathSet.addAll(Arrays.asList(paths));
                }
                if (PerFileXLCScannerInfoCollector.this.psi == null) {
                    PerFileXLCScannerInfoCollector.this.generateProjectScannerInfo();
                }
                IPath[] iPathArray = PerFileXLCScannerInfoCollector.this.psi.macrosFiles;
                int n = PerFileXLCScannerInfoCollector.this.psi.macrosFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path2 = iPathArray[n2];
                    pathSet.add(path2);
                    ++n2;
                }
                return pathSet.toArray(new IPath[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<IResource, PathInfo> getPathInfoMap() {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                return PerFileXLCScannerInfoCollector.this.calculatePathInfoMap();
            }
        }

        public IProject getProject() {
            return PerFileXLCScannerInfoCollector.this.project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPath[] getQuoteIncludePaths(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                LinkedHashSet<IPath> pathSet = new LinkedHashSet<IPath>();
                CCommandDSC cmd = PerFileXLCScannerInfoCollector.this.getCommand(path);
                if (cmd != null) {
                    IPath[] paths = PerFileXLCScannerInfoCollector.stringListToPathArray(cmd.getQuoteIncludes());
                    pathSet.addAll(Arrays.asList(paths));
                }
                if (PerFileXLCScannerInfoCollector.this.psi == null) {
                    PerFileXLCScannerInfoCollector.this.generateProjectScannerInfo();
                }
                IPath[] iPathArray = PerFileXLCScannerInfoCollector.this.psi.quoteIncludePaths;
                int n = PerFileXLCScannerInfoCollector.this.psi.quoteIncludePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path2 = iPathArray[n2];
                    pathSet.add(path2);
                    ++n2;
                }
                return pathSet.toArray(new IPath[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IDiscoveredPathManager.IDiscoveredScannerInfoSerializable getSerializable() {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                return PerFileXLCScannerInfoCollector.this.sid;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getSymbols() {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                return PerFileXLCScannerInfoCollector.this.getAllSymbols();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getSymbols(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                HashMap<String, String> definedSymbols = new HashMap<String, String>();
                if (PerFileXLCScannerInfoCollector.this.psi == null) {
                    PerFileXLCScannerInfoCollector.this.generateProjectScannerInfo();
                }
                definedSymbols.putAll(PerFileXLCScannerInfoCollector.this.psi.definedSymbols);
                CCommandDSC cmd = PerFileXLCScannerInfoCollector.this.getCommand(path);
                if (cmd != null && cmd.isDiscovered()) {
                    List symbols = cmd.getSymbols();
                    for (String symbol : symbols) {
                        String key = ScannerConfigUtil.getSymbolKey((String)symbol);
                        String value = ScannerConfigUtil.getSymbolValue((String)symbol);
                        definedSymbols.put(key, value);
                    }
                }
                if (PerFileXLCScannerInfoCollector.this.psi == null) {
                    PerFileXLCScannerInfoCollector.this.generateProjectScannerInfo();
                }
                definedSymbols.putAll(PerFileXLCScannerInfoCollector.this.psi.definedSymbols);
                return definedSymbols;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty(IPath path) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                boolean rc = true;
                IResource resource = PerFileXLCScannerInfoCollector.this.project.getWorkspace().getRoot().findMember(path);
                if (resource != null) {
                    if (resource instanceof IFile) {
                        rc = PerFileXLCScannerInfoCollector.this.getCommand((IFile)resource) == null;
                    } else if (resource instanceof IProject) {
                        Object object2 = PerFileXLCScannerInfoCollector.this.fLock;
                        synchronized (object2) {
                            rc = PerFileXLCScannerInfoCollector.this.psi == null || PerFileXLCScannerInfoCollector.this.psi.isEmpty();
                        }
                    }
                }
                return rc;
            }
        }
    }

    public static class ProjectScannerInfo {
        public Map<String, String> definedSymbols;
        public IPath[] includeFiles;
        public IPath[] includePaths;
        public IPath[] macrosFiles;
        public IPath[] quoteIncludePaths;

        public boolean isEmpty() {
            return this.includePaths.length == 0 && this.quoteIncludePaths.length == 0 && this.includeFiles.length == 0 && this.macrosFiles.length == 0 && this.definedSymbols.size() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ScannerConfigUpdateJob
    extends Job {
        private InfoContext fContext;
        private IDiscoveredPathManager.IDiscoveredPathInfo fPathInfo;
        private boolean fIsDefaultContext;
        private List<IResource> fChangedResources;

        public ScannerConfigUpdateJob(InfoContext context, IDiscoveredPathManager.IDiscoveredPathInfo pathInfo, boolean isDefaultContext, List<IResource> changedResources) {
            super(Messages.getString("PerFileXLCScannerInfoCollector.0"));
            this.fContext = context;
            this.fPathInfo = pathInfo;
            this.fIsDefaultContext = isDefaultContext;
            this.fChangedResources = changedResources;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)PerFileXLCScannerInfoCollector.this.project);
                IConfiguration config = info.getDefaultConfiguration();
                String profileID = config.getToolChain().getScannerConfigDiscoveryProfileId();
                IDiscoveredPathManager manager = MakeCorePlugin.getDefault().getDiscoveryManager();
                if (manager instanceof DiscoveredPathManager) {
                    ((DiscoveredPathManager)manager).updateDiscoveredInfo(this.fContext, this.fPathInfo, this.fIsDefaultContext, this.fChangedResources, profileID);
                }
                ICProjectDescriptionManager descriptionManager = CoreModel.getDefault().getProjectDescriptionManager();
                ICProjectDescription cProjectDescription = descriptionManager.getProjectDescription(PerFileXLCScannerInfoCollector.this.project, true);
                ICConfigurationDescription configDes = cProjectDescription.getActiveConfiguration();
                IToolChain toolchain = config.getToolChain();
                ITool[] iToolArray = toolchain.getTools();
                int n = iToolArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    IInputType[] iInputTypeArray = tool.getInputTypes();
                    int n3 = iInputTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IInputType inputType = iInputTypeArray[n4];
                        IContentType contentType = inputType.getSourceContentType();
                        if (contentType != null) {
                            for (IResource resource : this.fChangedResources) {
                                ICLanguageSetting langSetting = configDes.getLanguageSettingForFile(resource.getProjectRelativePath(), false);
                                if (langSetting == null) continue;
                                String[] contentTypeIDs = langSetting.getSourceContentTypeIds();
                                boolean found = false;
                                String[] stringArray = contentTypeIDs;
                                int n5 = contentTypeIDs.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    String id = stringArray[n6];
                                    if (id.equals(contentType.getId())) {
                                        found = true;
                                        break;
                                    }
                                    ++n6;
                                }
                                if (!found) continue;
                                this.updateIncludeSettings(langSetting);
                                this.updateMacroSettings(langSetting);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
                descriptionManager.setProjectDescription(PerFileXLCScannerInfoCollector.this.project, cProjectDescription, true, monitor);
            }
            catch (CoreException e) {
                Activator.log(e);
                return Activator.createStatus(Messages.getString("PerFileXLCScannerInfoCollector.1"));
            }
            return Status.OK_STATUS;
        }

        private boolean updateMacroSettings(ICLanguageSetting langSetting) {
            ICLanguageSettingEntry[] entries = langSetting.getSettingEntries(4);
            LinkedList<Object> newEntries = new LinkedList<Object>();
            ICLanguageSettingEntry[] iCLanguageSettingEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n2];
                newEntries.add(entry);
                ++n2;
            }
            boolean entriesChanged = false;
            Map discSymbols = this.fPathInfo.getSymbols();
            for (String symbol : discSymbols.keySet()) {
                boolean symbolFound = false;
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray2 = entries;
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICLanguageSettingEntry entry = iCLanguageSettingEntryArray2[n4];
                    if (((CMacroEntry)entry).getName().equals(symbol)) {
                        symbolFound = true;
                        break;
                    }
                    ++n4;
                }
                if (symbolFound) continue;
                entriesChanged = true;
                CMacroEntry newEntry = new CMacroEntry(symbol, (String)discSymbols.get(symbol), 19);
                newEntries.add(newEntry);
            }
            if (entriesChanged) {
                langSetting.setSettingEntries(4, newEntries.toArray(new ICLanguageSettingEntry[0]));
            }
            return entriesChanged;
        }

        private boolean updateIncludeSettings(ICLanguageSetting langSetting) {
            IPath[] discPaths;
            ICLanguageSettingEntry[] entries = langSetting.getSettingEntries(1);
            LinkedList<Object> newEntries = new LinkedList<Object>();
            ICLanguageSettingEntry[] iCLanguageSettingEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n2];
                newEntries.add(entry);
                ++n2;
            }
            boolean entriesChanged = false;
            IPath[] iPathArray = discPaths = this.fPathInfo.getIncludePaths();
            int n3 = discPaths.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path = iPathArray[n4];
                boolean pathFound = false;
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray2 = entries;
                int n5 = entries.length;
                int n6 = 0;
                while (n6 < n5) {
                    ICLanguageSettingEntry entry = iCLanguageSettingEntryArray2[n6];
                    if (((CIncludePathEntry)entry).getLocation().equals((Object)path)) {
                        pathFound = true;
                        break;
                    }
                    ++n6;
                }
                if (!pathFound) {
                    entriesChanged = true;
                    CIncludePathEntry newEntry = new CIncludePathEntry(path, 19);
                    newEntries.add(newEntry);
                }
                ++n4;
            }
            if (entriesChanged) {
                langSetting.setSettingEntries(1, newEntries.toArray(new ICLanguageSettingEntry[0]));
            }
            return entriesChanged;
        }
    }

    public class ScannerInfoData
    implements IDiscoveredPathManager.IDiscoveredScannerInfoSerializable {
        public static final String DEFINED_SYMBOL = "definedSymbol";
        public static final String ID_ATTR = "id";
        public static final String INCLUDE_PATH = "includePath";
        private static final String NAME = "name";
        public static final String PATH = "path";
        private static final String PROJECT = "project";
        public static final String REMOVED = "removed";
        public static final String SYMBOL = "symbol";
        public final Map<Integer, CCommandDSC> commandIdCommandMap = new LinkedHashMap<Integer, CCommandDSC>();
        public final Map<Integer, Set<IFile>> commandIdToFilesMap;
        public final Map<IFile, Integer> fileToCommandIdMap = new HashMap<IFile, Integer>();

        public ScannerInfoData() {
            this.commandIdToFilesMap = new HashMap<Integer, Set<IFile>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deserialize(Element collectorElem) {
            Object object = PerFileXLCScannerInfoCollector.this.fLock;
            synchronized (object) {
                Node child = collectorElem.getFirstChild();
                while (child != null) {
                    if (child.getNodeName().equals(PROJECT)) {
                        Element projectElement = (Element)child;
                        String projectName = projectElement.getAttribute(NAME);
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        HashMap scannerInfo = new HashMap();
                        LinkedList<String> includes = new LinkedList<String>();
                        LinkedList<String> symbols = new LinkedList<String>();
                        Node projectChild = projectElement.getFirstChild();
                        while (projectChild != null) {
                            String symbol;
                            Element childElem;
                            if (projectChild.getNodeName().equals(INCLUDE_PATH)) {
                                childElem = (Element)projectChild;
                                String path = childElem.getAttribute("path");
                                if (path != null) {
                                    includes.add(path);
                                }
                            } else if (projectChild.getNodeName().equals(DEFINED_SYMBOL) && (symbol = (childElem = (Element)projectChild).getAttribute(SYMBOL)) != null) {
                                symbols.add(symbol);
                            }
                            projectChild = projectChild.getNextSibling();
                        }
                        scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, includes);
                        scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, symbols);
                        PerFileXLCScannerInfoCollector.this.fProjectSettingsMap.put(project, scannerInfo);
                    } else if (child.getNodeName().equals(PerFileXLCScannerInfoCollector.CC_ELEM)) {
                        Element cmdElem = (Element)child;
                        boolean cppFileType = cmdElem.getAttribute(PerFileXLCScannerInfoCollector.FILE_TYPE_ATTR).equals("c++");
                        XLCCommandDSC command = new XLCCommandDSC(cppFileType, PerFileXLCScannerInfoCollector.this.project);
                        command.setCommandId(Integer.parseInt(cmdElem.getAttribute("id")));
                        command.deserialize(cmdElem);
                        NodeList appliesList = cmdElem.getElementsByTagName(PerFileXLCScannerInfoCollector.APPLIES_TO_ATTR);
                        if (appliesList.getLength() > 0) {
                            Element appliesElem = (Element)appliesList.item(0);
                            NodeList fileList = appliesElem.getElementsByTagName(PerFileXLCScannerInfoCollector.FILE_ELEM);
                            int i = 0;
                            while (i < fileList.getLength()) {
                                Element fileElem = (Element)fileList.item(i);
                                String fileName = fileElem.getAttribute("path");
                                IFile file = PerFileXLCScannerInfoCollector.this.project.getFile(fileName);
                                PerFileXLCScannerInfoCollector.this.addCompilerCommand(file, command);
                                ++i;
                            }
                            PerFileXLCScannerInfoCollector.this.applyFileDeltas();
                        }
                    }
                    child = child.getNextSibling();
                }
            }
        }

        public String getCollectorId() {
            return PerFileXLCScannerInfoCollector.COLLECTOR_ID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(Element collectorElem) {
            try {
                Object object = PerFileXLCScannerInfoCollector.this.fLock;
                synchronized (object) {
                    Document doc = collectorElem.getOwnerDocument();
                    for (IProject project : PerFileXLCScannerInfoCollector.this.fProjectSettingsMap.keySet()) {
                        Element projectElement = doc.createElement(PROJECT);
                        projectElement.setAttribute(NAME, project.getName());
                        Map scannerInfo = (Map)PerFileXLCScannerInfoCollector.this.fProjectSettingsMap.get(project);
                        List includes = (List)scannerInfo.get(ScannerInfoTypes.INCLUDE_PATHS);
                        for (String include : includes) {
                            Element pathElement = doc.createElement(INCLUDE_PATH);
                            pathElement.setAttribute("path", include);
                            pathElement.setAttribute(REMOVED, "false");
                            projectElement.appendChild(pathElement);
                        }
                        List symbols = (List)scannerInfo.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
                        for (String symbol : symbols) {
                            Element symbolElement = doc.createElement(DEFINED_SYMBOL);
                            symbolElement.setAttribute(SYMBOL, symbol);
                            projectElement.appendChild(symbolElement);
                        }
                        collectorElem.appendChild(projectElement);
                    }
                    ArrayList<Integer> commandIds = new ArrayList<Integer>(this.commandIdCommandMap.keySet());
                    Collections.sort(commandIds);
                    for (Integer commandId : commandIds) {
                        CCommandDSC command = this.commandIdCommandMap.get(commandId);
                        Element cmdElem = doc.createElement(PerFileXLCScannerInfoCollector.CC_ELEM);
                        collectorElem.appendChild(cmdElem);
                        cmdElem.setAttribute("id", commandId.toString());
                        cmdElem.setAttribute(PerFileXLCScannerInfoCollector.FILE_TYPE_ATTR, command.appliesToCPPFileType() ? "c++" : "c");
                        command.serialize(cmdElem);
                        Element filesElem = doc.createElement(PerFileXLCScannerInfoCollector.APPLIES_TO_ATTR);
                        cmdElem.appendChild(filesElem);
                        Set<IFile> files = this.commandIdToFilesMap.get(commandId);
                        if (files == null) continue;
                        Iterator<IFile> j = files.iterator();
                        while (j.hasNext()) {
                            Element fileElem = doc.createElement(PerFileXLCScannerInfoCollector.FILE_ELEM);
                            IFile file = j.next();
                            IPath path = file.getProjectRelativePath();
                            fileElem.setAttribute("path", path.toString());
                            filesElem.appendChild(fileElem);
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

