/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.enablement;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.enablement.IBooleanExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.OptionEnablementExpression;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;

public class CheckStringExpression
implements IBooleanExpression {
    public static final String NAME = "checkString";
    public static final String STRING = "string";
    public static final String VALUE = "value";
    public static final String IS_REGEX = "isRegex";
    private String fString;
    private String fValue;
    private boolean fIsRegex;

    public CheckStringExpression(IManagedConfigElement element) {
        this.fString = element.getAttribute(STRING);
        if (this.fString == null) {
            this.fString = new String();
        }
        this.fValue = element.getAttribute(VALUE);
        if (this.fValue == null) {
            this.fValue = new String();
        }
        this.fIsRegex = OptionEnablementExpression.getBooleanValue(element.getAttribute(IS_REGEX));
    }

    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOption option) {
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        IEnvironmentVariableProvider env = ManagedBuildManager.getEnvironmentVariableProvider();
        String delimiter = env.getDefaultDelimiter();
        try {
            String resolvedString = provider.resolveValue(this.fString, " ", delimiter, 2, new OptionContextData(option, (IBuildObject)holder));
            String resolvedValue = provider.resolveValue(this.fValue, " ", delimiter, 2, new OptionContextData(option, (IBuildObject)holder));
            if (this.fIsRegex) {
                Pattern pattern = Pattern.compile(resolvedValue);
                Matcher matcher = pattern.matcher(resolvedString);
                return matcher.matches();
            }
            return resolvedString.equals(resolvedValue);
        }
        catch (BuildMacroException buildMacroException) {
            return false;
        }
    }

    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOptionCategory category) {
        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
        IEnvironmentVariableProvider env = ManagedBuildManager.getEnvironmentVariableProvider();
        String delimiter = env.getDefaultDelimiter();
        try {
            String resolvedString = provider.resolveValue(this.fString, " ", delimiter, 2, new OptionContextData(category, (IBuildObject)holder));
            String resolvedValue = provider.resolveValue(this.fValue, " ", delimiter, 2, new OptionContextData(category, (IBuildObject)holder));
            if (this.fIsRegex) {
                Pattern pattern = Pattern.compile(resolvedValue);
                Matcher matcher = pattern.matcher(resolvedString);
                return matcher.matches();
            }
            return resolvedString.equals(resolvedValue);
        }
        catch (BuildMacroException buildMacroException) {
            return false;
        }
    }
}

