/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathComparator
implements Comparator<IPath> {
    public static PathComparator INSTANCE = new PathComparator();

    private PathComparator() {
    }

    @Override
    public int compare(IPath arg0, IPath arg1) {
        if (arg0 == arg1) {
            return 0;
        }
        IPath path1 = arg0;
        IPath path2 = arg1;
        int length1 = path1.segmentCount();
        int length2 = path2.segmentCount();
        int i = 0;
        while (i < length1) {
            if (i >= length2) {
                return 1;
            }
            int comparison = path1.segment(i).compareTo(path2.segment(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        if (length1 == length2) {
            return 0;
        }
        return -1;
    }

    public static IPath getNext(IPath path) {
        if (path.segmentCount() == 0) {
            return null;
        }
        String newLast = String.valueOf(path.lastSegment()) + '\u0000';
        return path.removeLastSegments(1).append(newLast);
    }

    public static IPath getFirstChild(IPath path) {
        return path.append("\u0000");
    }

    public static SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> getChildPathMap(SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> map, IPath path, boolean includeThis, boolean copy) {
        SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> result;
        IPath start = includeThis ? path : PathComparator.getFirstChild(path);
        IPath next = PathComparator.getNext(path);
        SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> sortedMap = result = next != null ? map.subMap(start, next) : map.tailMap(start);
        if (copy) {
            result = new TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>>(result);
        }
        return result;
    }

    public static SortedSet<IPath> getChildPathSet(SortedSet<IPath> set, IPath path, boolean includeThis, boolean copy) {
        SortedSet<IPath> result;
        IPath start = includeThis ? path : PathComparator.getFirstChild(path);
        IPath next = PathComparator.getNext(path);
        SortedSet<IPath> sortedSet = result = next != null ? set.subSet(start, next) : set.tailSet(start);
        if (copy) {
            result = new TreeSet<IPath>(result);
        }
        return result;
    }

    public static SortedSet<IPath> getDirectChildPathSet(SortedSet<IPath> set, IPath path) {
        SortedSet<IPath> children = PathComparator.getChildPathSet(set, path, false, false);
        TreeSet<IPath> result = new TreeSet<IPath>(INSTANCE);
        for (IPath childPath : children) {
            result.add(childPath);
            children = children.tailSet(PathComparator.getNext(childPath));
        }
        return result;
    }

    public static SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> getDirectChildPathMap(SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> map, IPath path) {
        SortedMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> children = PathComparator.getChildPathMap(map, path, false, false);
        TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> result = new TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>>(INSTANCE);
        Iterator<Map.Entry<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>>> iter = children.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> entry = iter.next();
            IPath childPath = entry.getKey();
            result.put(childPath, entry.getValue());
            children = children.tailMap(PathComparator.getNext(childPath));
            iter = children.entrySet().iterator();
        }
        return result;
    }
}

